/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectRaiseVolcano
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectRaiseVolcano> DESERIALIZER = json -> new RiteEffectRaiseVolcano(JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)8), JsonUtils.func_151208_a((JsonObject)json, (String)"height", (int)8));
    private final int radius;
    private final int height;

    public RiteEffectRaiseVolcano(int radius, int height2) {
        this.radius = radius;
        this.height = height2;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if ((long)ticks % 15L != 0L) {
            return RiteHandler.Result.STARTING;
        }
        if (!world.field_72995_K) {
            if (stage.incrementAndGet() == 1) {
                boolean lavaFound = false;
                BlockPos y = pos;
                while (y.func_177956_o() > 0 && !lavaFound) {
                    Block blockID = world.func_180495_p(y).func_177230_c();
                    if (blockID == Blocks.field_150353_l && this.surroundedByBlocks(world, y)) {
                        lavaFound = true;
                    } else if (blockID == Blocks.field_150357_h) break;
                    y = y.func_177977_b();
                }
                if (!lavaFound) {
                    world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    RiteEffect.error("no_lava", ritual.getInitiatingPlayer(world));
                    return RiteHandler.Result.ABORTED_REFUND;
                }
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.5f, 1.0f, EnumParticleTypes.PORTAL), world, pos);
            }
            int height2 = this.height + 4 * ritual.covenSize;
            float radius = this.radius + 2 * ritual.covenSize;
            if (stage.get() <= height2) {
                for (int y2 = 1; y2 <= stage.get(); ++y2) {
                    float r = radius - (float)(height2 - stage.get() - 1 + y2) * radius / (float)height2;
                    AxisAlignedBB bounds = new AxisAlignedBB(pos.func_177963_a((double)(-r), (double)y2, (double)(-r)), pos.func_177963_a((double)r, (double)y2, (double)r));
                    this.drawFilledCircle(world, pos.func_177981_b(y2 - 1), Math.max((int)Math.ceil(r), 1), y2, true);
                    if (stage.get() == height2) {
                        int reduce = 0;
                        BlockPos minusY = pos.func_177977_b();
                        while (minusY.func_177956_o() > pos.func_177956_o() - 5) {
                            this.drawFilledCircle(world, minusY, Math.max((int)radius - reduce, 2), y2, false);
                            minusY = minusY.func_177977_b();
                            ++reduce;
                        }
                    }
                    for (Entity entity : world.func_72872_a(Entity.class, bounds)) {
                        Material material;
                        if (!(pos.func_177981_b(y2).func_185332_f((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v) <= (double)r) || !(material = world.func_180495_p(entity.func_180425_c()).func_185904_a()).func_76220_a()) continue;
                        if (entity instanceof EntityLivingBase) {
                            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
                            continue;
                        }
                        entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
                    }
                }
            } else {
                if (stage.get() >= height2 * 2) {
                    BlockPos p = pos;
                    while (p.func_177956_o() > 0) {
                        Block blockID2 = world.func_180495_p(p).func_177230_c();
                        if (blockID2 == Blocks.field_150353_l || blockID2 == Blocks.field_150356_k || blockID2 == Blocks.field_150357_h) {
                            while (blockID2 == Blocks.field_150353_l || blockID2 == Blocks.field_150356_k) {
                                this.setToAirIfLava(world, p);
                                this.setToAirIfLava(world, p.func_177974_f());
                                this.setToAirIfLava(world, p.func_177976_e());
                                this.setToAirIfLava(world, p.func_177968_d());
                                this.setToAirIfLava(world, p.func_177978_c());
                                p = p.func_177977_b();
                                blockID2 = world.func_180495_p(p).func_177230_c();
                            }
                            break;
                        }
                        world.func_175698_g(p);
                        p = p.func_177977_b();
                    }
                    return RiteHandler.Result.COMPLETED;
                }
                if (stage.get() == height2 * 2 - 1) {
                    world.func_175656_a(pos.func_177981_b(stage.get() - height2), Blocks.field_150356_k.func_176223_P());
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150353_l.func_176223_P());
                    if (radius == 16.0f) {
                        if (world.field_73012_v.nextInt(4) == 0) {
                            world.func_175656_a(pos.func_177981_b(1 + stage.get() - height2), Blocks.field_150356_k.func_176223_P());
                        }
                    } else {
                        switch (world.field_73012_v.nextInt(8)) {
                            case 0: {
                                world.func_175698_g(pos.func_177982_a(1, height2 - 1, 0));
                                break;
                            }
                            case 1: {
                                world.func_175698_g(pos.func_177982_a(0, height2 - 1, 1));
                                break;
                            }
                            case 2: {
                                world.func_175698_g(pos.func_177982_a(-1, height2 - 1, 0));
                                break;
                            }
                            case 3: {
                                world.func_175698_g(pos.func_177982_a(0, height2 - 1, -1));
                            }
                        }
                    }
                } else {
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(pos.func_177981_b(stage.get() - height2), Blocks.field_150353_l.func_176223_P());
                }
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    private boolean surroundedByBlocks(World world, BlockPos pos) {
        int count = 0;
        count += world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150353_l ? 1 : 0;
        count += world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150353_l ? 1 : 0;
        count += world.func_180495_p(pos.func_177982_a(1, -1, 0)).func_177230_c() == Blocks.field_150353_l ? 1 : 0;
        count += world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150353_l ? 1 : 0;
        count += world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150353_l ? 1 : 0;
        return (count += world.func_180495_p(pos.func_177982_a(0, 1, 1)).func_177230_c() == Blocks.field_150353_l ? 1 : 0) >= 2;
    }

    private void setToAirIfLava(World world, BlockPos pos) {
        Block blockID = world.func_180495_p(pos).func_177230_c();
        if (blockID == Blocks.field_150353_l || blockID == Blocks.field_150356_k) {
            world.func_175698_g(pos);
        }
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius, int height2, boolean replaceBlocks) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.func_177982_a(-x, 0, z), pos.func_177982_a(x, 0, z), pos, radius, height2, replaceBlocks);
            this.drawLine(world, pos.func_177982_a(-z, 0, x), pos.func_177982_a(z, 0, x), pos, radius, height2, replaceBlocks);
            this.drawLine(world, pos.func_177982_a(-x, 0, -z), pos.func_177982_a(x, 0, -z), pos, radius, height2, replaceBlocks);
            this.drawLine(world, pos.func_177982_a(-z, 0, -x), pos.func_177982_a(z, 0, -x), pos, radius, height2, replaceBlocks);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, BlockPos mid, int radius, int height2, boolean replaceBlocks) {
        BlockPos modX1 = radius > 1 && world.field_73012_v.nextInt(5) == 0 ? x1.func_177974_f() : x1;
        BlockPos modX2 = radius > 1 && world.field_73012_v.nextInt(5) == 0 ? x2.func_177976_e() : x2;
        boolean edgeZ = mid.func_177952_p() + radius == x1.func_177952_p() || mid.func_177952_p() - radius == x1.func_177952_p();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)modX1, (BlockPos)modX2)) {
            if (pos.equals((Object)mid)) continue;
            this.drawPixel(world, pos, (pos.equals((Object)modX1) || pos.equals((Object)modX2) || edgeZ) && height2 < 3, replaceBlocks);
        }
    }

    protected void drawPixel(World world, BlockPos pos, boolean lower, boolean replaceBlocks) {
        if (replaceBlocks && WitcheryUtils.canBreak(world.func_180495_p(pos)) || world.func_175623_d(pos)) {
            world.func_175656_a(pos, lower && world.field_73012_v.nextInt(5) != 0 ? Blocks.field_150349_c.func_176223_P() : Blocks.field_150348_b.func_176223_P());
        }
    }
}

