/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;
import net.msrandom.witchery.transformation.VampireCreatureTrait;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectRemoveVampirism
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectRemoveVampirism> DESERIALIZER = json -> new RiteEffectRemoveVampirism(ItemRiteSacrifice.parseIdentifier(json.get("target").getAsString()));
    private final long target;

    public RiteEffectRemoveVampirism(long target) {
        this.target = target;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.field_72995_K) {
            EntityLivingBase entity;
            boolean complete = false;
            boolean cursed = false;
            EntityPlayer curseMasterPlayer = ritual.getInitiatingPlayer(world);
            if (!Familiars.hasFamiliarPower(curseMasterPlayer, WitcheryFamiliars.CURSE_MASTERY)) {
                curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.no_curse_mastery", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (ritual.covenSize < 6) {
                curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.coven_not_full", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.target);
            if (sacrificedItem != null && (entity = ItemTaglockKit.getBoundEntity(world, sacrificedItem.getStack(), 0)) != null) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                    VampireCreatureTrait transformation = playerEx.getTransformation(WitcheryCreatureTraits.VAMPIRE);
                    if (transformation.getLevel() > 0) {
                        double MAX_RANGE_SQ = 64.0;
                        if (player.func_174818_b(pos) <= MAX_RANGE_SQ) {
                            if (world.field_73012_v.nextInt(4) != 0) {
                                transformation.setLevel(0);
                                playerEx.markChanged();
                            } else {
                                cursed = true;
                            }
                            complete = true;
                        } else {
                            curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.too_far", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                    } else {
                        curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.not_cursed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                } else {
                    curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.not_cursed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
            if (!complete) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (cursed) {
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187525_aO, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, 1.0f, 2.0f, EnumParticleTypes.FLAME), world, pos);
            } else {
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), world, pos);
            }
        }
        return RiteHandler.Result.COMPLETED;
    }
}

