/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectSummonCreature
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectSummonCreature> DESERIALIZER = json -> new RiteEffectSummonCreature((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(json.get("entity").getAsString())), JsonUtils.func_151209_a((JsonObject)json, (String)"tame", (boolean)false), JsonUtils.func_151209_a((JsonObject)json, (String)"persistent", (boolean)false), JsonUtils.func_151208_a((JsonObject)json, (String)"coven_size", (int)0));
    private final EntityEntry creatureToSummon;
    private final boolean tame;
    private final boolean persistent;
    private final int covenSize;

    public RiteEffectSummonCreature(EntityEntry creatureToSummon, boolean tame, boolean persistent, int covenSize) {
        this.creatureToSummon = creatureToSummon;
        this.tame = tame;
        this.persistent = persistent;
        this.covenSize = covenSize;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.field_72995_K) {
            int[][] pattern = new int[][]{{0, 0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 2, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 0}};
            int obstructions = 0;
            BlockPos y = pos.func_177984_a();
            while (y.func_177956_o() <= pos.func_177956_o() + 3) {
                int offsetZ = (pattern.length - 1) / 2;
                for (int z = 0; z < pattern.length - 1; ++z) {
                    int offsetX = (pattern[z].length - 1) / 2;
                    for (int x = 0; x < pattern[z].length; ++x) {
                        Material material;
                        int val = pattern[pattern.length - 1 - z][x];
                        BlockPos p = y.func_177982_a(x - offsetX, 0, z - offsetZ);
                        if (val == 1) {
                            material = world.func_180495_p(p).func_185904_a();
                            if (!material.func_76220_a()) continue;
                            ++obstructions;
                            continue;
                        }
                        if (val != 2 || !(material = world.func_180495_p(p).func_185904_a()).func_76220_a()) continue;
                        obstructions += 100;
                    }
                }
                y = y.func_177984_a();
            }
            if (obstructions > 1) {
                world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.5f, 2.0f, EnumParticleTypes.SMOKE_LARGE), world, pos);
                RiteEffect.error("circle_center_unclear", ritual.getInitiatingPlayer(world));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            Entity entity = this.creatureToSummon.newInstance(world);
            if (ritual.covenSize < this.covenSize) {
                EntityPlayer player = ritual.getInitiatingPlayer(world);
                world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                if (player != null) {
                    player.func_145747_a(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (this.tame) {
                EntityTameable tameable = (EntityTameable)entity;
                tameable.func_184754_b(ritual.getInitiatingPlayerId());
                tameable.func_70903_f(true);
            }
            if (this.persistent) {
                ((EntityLiving)entity).func_110163_bv();
            }
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 1.0f, 0.0f);
            world.func_72838_d(entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
            }
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.5f, 1.0f, EnumParticleTypes.PORTAL), entity);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

