/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockAreaMarker;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.effect.RiteEffectTeleportation;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;
import net.msrandom.witchery.util.TeleportationUtil;

public class RiteEffectTeleportEntity
extends RiteEffectTeleportation {
    public static final Function1<JsonObject, RiteEffectTeleportEntity> DESERIALIZER = json -> new RiteEffectTeleportEntity(ItemRiteSacrifice.parseIdentifier(json.get("target").getAsString()), JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)3));
    private final long target;

    public RiteEffectTeleportEntity(long target, int radius) {
        super(radius);
        this.target = target;
    }

    @Override
    protected boolean teleport(World world, BlockPos pos, TileEntityCircle.ActivatedRitual ritual) {
        EntityLivingBase entity;
        RiteEffect.SacrificedItem sacrificedItem;
        if (!(world.field_72995_K || (sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.target)) == null || (entity = ItemTaglockKit.getBoundEntity(world, sacrificedItem.getStack(), 0)) == null || WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)entity) || WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world))) {
            EntityPlayer player = ritual.getInitiatingPlayer(world);
            boolean isImmune = ItemHunterClothes.isCurseProtectionActive(entity);
            if (!isImmune) {
                isImmune = BlockAreaMarker.AreaMarkerRegistry.instance().isProtectionActive(entity, this);
            }
            if (!isImmune && !WitcheryPoppetItems.voodooProtectionActivated(player, null, entity, true, true) && PotionEnderInhibition.canTeleport((Entity)entity, 3)) {
                TeleportationUtil.teleportToLocation(pos, world.field_73011_w.getDimension(), (Entity)entity, true);
                return true;
            }
            if (player != null) {
                if (isImmune) {
                    player.func_145747_a(new TextComponentTranslation("rite.witchery.magic_dissipating", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                } else {
                    player.func_145747_a(new TextComponentTranslation("rite.witchery.voodoo_protection_present", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
            return false;
        }
        return false;
    }
}

