/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectWeatherCallStorm
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectWeatherCallStorm> DESERIALIZER = json -> new RiteEffectWeatherCallStorm(JsonUtils.func_151203_m((JsonObject)json, (String)"min_radius"), JsonUtils.func_151203_m((JsonObject)json, (String)"max_radius"), JsonUtils.func_151203_m((JsonObject)json, (String)"bolts"));
    private final int minRadius;
    private final int maxRadius;
    private final int bolts;

    public RiteEffectWeatherCallStorm(int minRadius, int maxRadius, int bolts) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.bolts = bolts;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        switch (stage.incrementAndGet()) {
            case 1: 
            case 2: {
                this.spawnBolt(world, pos);
                break;
            }
            case 3: {
                this.spawnBolt(world, pos);
                this.spawnBolt(world, pos);
                break;
            }
            case 4: {
                if (world instanceof WorldServer && !world.func_72911_I()) {
                    WorldInfo worldinfo = world.func_72912_H();
                    int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                    worldinfo.func_76080_g(i);
                    worldinfo.func_76090_f(i);
                    worldinfo.func_76084_b(true);
                    worldinfo.func_76069_a(true);
                }
                this.spawnBolt(world, pos);
                break;
            }
            default: {
                for (int j = 0; j < world.field_73012_v.nextInt(4); ++j) {
                    this.spawnBolt(world, pos);
                    if (j <= 0) continue;
                    stage.incrementAndGet();
                }
            }
        }
        return stage.get() < this.bolts ? RiteHandler.Result.STARTING : RiteHandler.Result.COMPLETED;
    }

    private void spawnBolt(World world, BlockPos pos) {
        int activeRadius = this.maxRadius - this.minRadius;
        int ax = world.field_73012_v.nextInt(activeRadius * 2 + 1);
        if (ax > activeRadius) {
            ax += this.minRadius * 2;
        }
        int x = pos.func_177958_n() - this.maxRadius + ax;
        int az = world.field_73012_v.nextInt(activeRadius * 2 + 1);
        if (az > activeRadius) {
            az += this.minRadius * 2;
        }
        int z = pos.func_177952_p() - this.maxRadius + az;
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)pos.func_177956_o(), (double)z, false);
        world.func_72942_c((Entity)bolt);
    }

    @Override
    public int getRunTime() {
        return 30;
    }
}

