/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.sacrifice;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.sacrifice.RiteSacrifice;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRiteSacrifice
extends RiteSacrifice {
    public static final RiteSacrifice.SacrificeSerializer<EntityRiteSacrifice> SERIALIZER = new Serializer();
    public final Set<Class<? extends Entity>> entities;

    public EntityRiteSacrifice(RiteSacrifice.SacrificeSerializer<?> serializer, Set<Class<? extends Entity>> entities) {
        super(serializer);
        this.entities = entities;
    }

    @Override
    @Nullable
    public RiteSacrifice.RiteSacrificeFailure prepareIfMatches(World world, BlockPos pos, int maxDistance, List<Runnable> matchActions, Set<Entity> entities, Set<ItemStack> grassperStacks) {
        int required = this.entities.size();
        for (Entity entity : entities) {
            if (!this.entities.contains(entity.getClass()) || !(entity.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= (double)(maxDistance + 1)) || --required != 0) continue;
            return null;
        }
        return new RiteSacrifice.RiteSacrificeFailure("missing_creature_sacrifice");
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos position, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        for (EntityLiving entity : world.func_72872_a(EntityLiving.class, ritual.bounds)) {
            if (!this.entities.contains(entity.getClass())) continue;
            entity.func_70106_y();
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)entity);
        }
        return RiteHandler.Result.COMPLETED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(StringBuilder builder, float time) {
        for (Class<? extends Entity> entity : this.entities) {
            ResourceLocation id = EntityList.func_191306_a(entity);
            String s = id == null ? "generic" : EntityList.func_191302_a((ResourceLocation)id);
            builder.append(TextFormatting.DARK_GRAY).append(">").append(TextFormatting.BLACK).append(" ");
            builder.append(I18n.func_135052_a((String)("entity." + s + ".name"), (Object[])new Object[0]));
            builder.append("\n");
        }
    }

    public static class Serializer
    extends RiteSacrifice.SacrificeSerializer<EntityRiteSacrifice> {
        @Override
        public EntityRiteSacrifice read(JsonObject json) {
            JsonArray entitiesElement = json.getAsJsonArray("entities");
            if (entitiesElement != null) {
                HashSet<Class<? extends Entity>> entities = new HashSet<Class<? extends Entity>>();
                for (JsonElement entity : entitiesElement) {
                    entities.add(RegistryWrappers.ENTITIES.get(new ResourceLocation(entity.getAsString())).getEntityClass());
                }
                return new EntityRiteSacrifice(this, entities);
            }
            return null;
        }

        @Override
        @NotNull
        public EntityRiteSacrifice read(PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            HashSet<Class<? extends Entity>> entities = new HashSet<Class<? extends Entity>>(size);
            for (int i = 0; i < size; ++i) {
                entities.add(EntityList.func_90035_a((int)buffer.func_150792_a()));
            }
            return new EntityRiteSacrifice(this, entities);
        }

        @Override
        public void write(PacketBuffer buffer, EntityRiteSacrifice sacrifice) {
            buffer.func_150787_b(sacrifice.entities.size());
            for (Class<? extends Entity> entity : sacrifice.entities) {
                buffer.func_150787_b(EntityList.getID(entity));
            }
        }
    }
}

