/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.sacrifice;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.sacrifice.RiteSacrifice;
import org.jetbrains.annotations.NotNull;

public class PowerRiteSacrifice
extends RiteSacrifice {
    public static final RiteSacrifice.SacrificeSerializer<PowerRiteSacrifice> SERIALIZER = new Serializer();
    public final float powerRequired;

    public PowerRiteSacrifice(RiteSacrifice.SacrificeSerializer<?> serializer, float powerRequired) {
        super(serializer);
        this.powerRequired = powerRequired;
    }

    @Override
    public RiteSacrifice.RiteSacrificeFailure prepareIfMatches(World world, BlockPos position, int maxDistance, List<Runnable> matchActions, Set<Entity> entities, Set<ItemStack> grassperStacks) {
        IPowerSource powerSource = this.findNewPowerSource(world, position);
        if (powerSource == null) {
            return new RiteSacrifice.RiteSacrificeFailure("no_altar");
        }
        if (powerSource.getCurrentPower() >= this.powerRequired) {
            return null;
        }
        return new RiteSacrifice.RiteSacrificeFailure("insufficient_altar_power");
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos position, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        IPowerSource powerSource = this.findNewPowerSource(world, position);
        if (powerSource == null) {
            return RiteHandler.Result.ABORTED_REFUND;
        }
        if (powerSource.consumePower(this.powerRequired)) {
            return RiteHandler.Result.COMPLETED;
        }
        return RiteHandler.Result.ABORTED_REFUND;
    }

    private IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDescription(StringBuilder builder, float time) {
        builder.append(String.format("\n" + TextFormatting.DARK_GRAY + "%s" + TextFormatting.BLACK + " %s\n", I18n.func_135052_a((String)"witchery.book.altar_power", (Object[])new Object[0]), MathHelper.func_76141_d((float)this.powerRequired)));
    }

    public static class Serializer
    extends RiteSacrifice.SacrificeSerializer<PowerRiteSacrifice> {
        @Override
        public PowerRiteSacrifice read(JsonObject json) {
            JsonElement power = json.get("power");
            if (power != null) {
                return new PowerRiteSacrifice(this, power.getAsFloat());
            }
            return null;
        }

        @Override
        @NotNull
        public PowerRiteSacrifice read(PacketBuffer buffer) {
            return new PowerRiteSacrifice(this, buffer.readFloat());
        }

        @Override
        public void write(PacketBuffer buffer, PowerRiteSacrifice sacrifice) {
            buffer.writeFloat(sacrifice.powerRequired);
        }
    }
}

