/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.transformation;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.Village;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.monster.EntityAttackBat;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.extensions.VillagerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.item.ItemVampireClothes;
import net.msrandom.witchery.network.PacketSelectPlayerAbility;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.CreatureTrait;
import net.msrandom.witchery.transformation.VampireCreatureTrait$WhenMappings;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\\]B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020305H\u0082\bJ\u0018\u00106\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0016\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0010J\u0010\u0010>\u001a\u0002032\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020\u0006H\u0002J\u000e\u0010C\u001a\u0002032\u0006\u0010<\u001a\u00020\u0006J\u000e\u0010D\u001a\u0002032\u0006\u0010<\u001a\u00020\u0006J\u0018\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020\u0010H\u0016J\u0010\u0010K\u001a\u0002032\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010L\u001a\u0002032\u0006\u0010?\u001a\u00020@H\u0016J&\u0010M\u001a\u00020\u00102\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0010J\b\u0010T\u001a\u000203H\u0016J\b\u0010U\u001a\u000203H\u0002J\u0010\u0010V\u001a\u0002032\b\u0010W\u001a\u0004\u0018\u00010RJ\u0006\u0010X\u001a\u000203J\u0010\u0010Y\u001a\u00020\u00102\u0006\u0010W\u001a\u00020ZH\u0002J\u0010\u0010[\u001a\u0002032\u0006\u0010?\u001a\u00020@H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\t\"\u0004\b\u0015\u0010\u000bR\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\t\"\u0004\b\u0019\u0010\u000bR$\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000bR\u001a\u0010\u001d\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\t\"\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\tR\u001a\u0010\"\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010%R$\u0010'\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020&@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006^"}, d2={"Lnet/msrandom/witchery/transformation/VampireCreatureTrait;", "Lnet/msrandom/witchery/transformation/CreatureTrait;", "playerEx", "Lnet/msrandom/witchery/extensions/PlayerExtendedData;", "(Lnet/msrandom/witchery/extensions/PlayerExtendedData;)V", "value", "", "bloodPower", "getBloodPower", "()I", "setBloodPower", "(I)V", "bloodReserve", "getBloodReserve", "setBloodReserve", "canLevelUp", "", "getCanLevelUp", "()Z", "charges", "getCharges", "setCharges", "cooldown", "highlightTicks", "getHighlightTicks", "setHighlightTicks", "level", "getLevel", "setLevel", "levelCap", "getLevelCap", "setLevelCap", "maxBloodPower", "getMaxBloodPower", "nightVision", "getNightVision", "setNightVision", "(Z)V", "Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power;", "selectedPower", "getSelectedPower", "()Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power;", "setSelectedPower", "(Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power;)V", "ultimatePower", "Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Ultimate;", "getUltimatePower", "()Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Ultimate;", "setUltimatePower", "(Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Ultimate;)V", "checkCooldown", "", "action", "Lkotlin/Function0;", "checkWitnesses", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "victim", "Lnet/minecraft/entity/EntityLivingBase;", "decreaseBlood", "quantity", "exact", "deserialize", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "drinkAnimalBlood", "maxIncrease", "drinkHumanBlood", "fillBloodReserve", "isCaged", "world", "Lnet/minecraft/world/World;", "mutable", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "levelUp", "read", "serialize", "teleport", "position", "Lnet/minecraft/util/math/BlockPos;", "dimension", "entity", "Lnet/minecraft/entity/Entity;", "presetPosition", "tick", "toggleNightVision", "triggerSelectedPower", "target", "useBloodReserve", "villagerInCage", "Lnet/minecraft/entity/passive/EntityVillager;", "write", "Power", "Ultimate", "WitcheryResurrected"})
public final class VampireCreatureTrait
extends CreatureTrait {
    private int highlightTicks;
    private int bloodReserve;
    @NotNull
    private Ultimate ultimatePower;
    private int charges;
    @NotNull
    private Power selectedPower;
    private int cooldown;
    private boolean nightVision;
    private int levelCap;
    private int bloodPower;

    @Override
    public int getLevel() {
        return super.getLevel();
    }

    @Override
    public void setLevel(int value) {
        if (super.getLevel() != value) {
            super.setLevel(value);
            this.setQuestCount(0);
            this.getVisitedChunks().clear();
            if (value == 0 && !((EntityPlayer)this.getPlayerEx().getEntity()).field_70170_p.field_72995_K) {
                if (Intrinsics.areEqual(this.getPlayerEx().getCurrentForm(), WitcheryAlternateForms.BAT)) {
                    this.getPlayerEx().setCurrentForm(null);
                } else {
                    ShapeShift.INSTANCE.initCurrentShift((EntityPlayer)this.getPlayerEx().getEntity());
                }
                this.setBloodPower(0);
                this.getPlayerEx().setHumanBlood(50);
                this.ultimatePower = Ultimate.NONE;
                this.charges = 0;
            } else {
                ShapeShift.INSTANCE.initCurrentShift((EntityPlayer)this.getPlayerEx().getEntity());
            }
            this.setSelectedPower(Power.NONE);
            if (value == 1) {
                this.setBloodPower(125);
            }
            if (value > 0) {
                this.getPlayerEx().setHumanBlood(0);
            }
        }
    }

    public final int getHighlightTicks() {
        return this.highlightTicks;
    }

    public final void setHighlightTicks(int n) {
        this.highlightTicks = n;
    }

    public final int getBloodReserve() {
        return this.bloodReserve;
    }

    public final void setBloodReserve(int n) {
        this.bloodReserve = n;
    }

    @NotNull
    public final Ultimate getUltimatePower() {
        return this.ultimatePower;
    }

    public final void setUltimatePower(@NotNull Ultimate ultimate) {
        Intrinsics.checkParameterIsNotNull((Object)ultimate, "<set-?>");
        this.ultimatePower = ultimate;
    }

    public final int getCharges() {
        return this.charges;
    }

    public final void setCharges(int n) {
        this.charges = n;
    }

    @NotNull
    public final Power getSelectedPower() {
        return this.selectedPower;
    }

    public final void setSelectedPower(@NotNull Power value) {
        Intrinsics.checkParameterIsNotNull((Object)value, "value");
        if (this.selectedPower != value) {
            this.selectedPower = value;
            int n = this.highlightTicks = value != Power.NONE ? 100 : 0;
            if (((EntityPlayer)this.getPlayerEx().getEntity()).field_70170_p.field_72995_K) {
                WitcheryNetworkChannel.sendToServer(new PacketSelectPlayerAbility(this, false));
            }
        }
    }

    public final boolean getNightVision() {
        return this.nightVision;
    }

    public final void setNightVision(boolean bl) {
        this.nightVision = bl;
    }

    public final int getLevelCap() {
        return this.levelCap;
    }

    public final void setLevelCap(int n) {
        this.levelCap = n;
    }

    public final int getBloodPower() {
        return this.bloodPower;
    }

    public final void setBloodPower(int value) {
        this.bloodPower = RangesKt.coerceIn(value, 0, this.getMaxBloodPower());
    }

    public final int getMaxBloodPower() {
        return 500 + (this.getPlayerEx().getTransformation(WitcheryCreatureTraits.WEREWOLF).getLevel() >= 2 ? this.getLevel() / 2 : this.getLevel()) * 250;
    }

    @Override
    public boolean getCanLevelUp() {
        return WitcheryConfigOptions.allowVampireQuests && this.getLevel() < this.levelCap;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.cooldown > 0) {
            VampireCreatureTrait vampireCreatureTrait = this;
            vampireCreatureTrait.cooldown += -1;
            int cfr_ignored_0 = vampireCreatureTrait.cooldown;
        }
    }

    @Override
    public boolean levelUp() {
        if (super.levelUp()) {
            ((EntityPlayer)this.getPlayerEx().getEntity()).func_145747_a(new TextComponentTranslation("entity.witchery.vampire.level_up", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            Object e = this.getPlayerEx().getEntity();
            Intrinsics.checkExpressionValueIsNotNull(e, "playerEx.entity");
            EntityPlayer entityPlayer = (EntityPlayer)e;
            SoundEvent soundEvent = SoundEvents.field_187802_ec;
            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.ENTITY_PLAYER_LEVELUP");
            Object e2 = this.getPlayerEx().getEntity();
            Intrinsics.checkExpressionValueIsNotNull(e2, "playerEx.entity");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (((EntityPlayer)e2).func_70681_au().nextFloat() * 0.4f + 0.8f));
            return true;
        }
        return false;
    }

    @Override
    public void serialize(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        super.serialize(tag);
        tag.func_74757_a("VampireVision", this.nightVision);
        tag.func_74768_a("LevelCap", this.levelCap);
    }

    @Override
    public void deserialize(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        super.deserialize(tag);
        this.nightVision = tag.func_74767_n("VampireVision");
        this.levelCap = tag.func_74762_e("LevelCap");
    }

    @Override
    public void write(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        super.write(tag);
        tag.func_74768_a("BloodPower", this.bloodPower);
        tag.func_74768_a("BloodReserve", this.bloodReserve);
        tag.func_74768_a("UltimatePower", this.ultimatePower.ordinal());
        tag.func_74768_a("UltimatePowerCharges", this.charges);
        tag.func_74768_a("Power", this.selectedPower.ordinal());
    }

    @Override
    public void read(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        super.read(tag);
        this.setBloodPower(tag.func_74762_e("BloodPower"));
        this.bloodReserve = tag.func_74762_e("BloodReserve");
        this.ultimatePower = Ultimate.VALUES[tag.func_74762_e("UltimatePower")];
        this.charges = tag.func_74762_e("UltimatePowerCharges");
        this.setSelectedPower(Power.VALUES[tag.func_74762_e("Power")]);
    }

    public final boolean decreaseBlood(int quantity, boolean exact) {
        if (((EntityPlayer)this.getPlayerEx().getEntity()).field_71075_bZ.field_75098_d) {
            return true;
        }
        if (this.bloodPower >= (exact ? quantity : 1)) {
            VampireCreatureTrait vampireCreatureTrait = this;
            vampireCreatureTrait.setBloodPower(vampireCreatureTrait.bloodPower - quantity);
            return true;
        }
        return false;
    }

    public final void drinkHumanBlood(int quantity) {
        if (this.bloodPower < this.getMaxBloodPower()) {
            VampireCreatureTrait vampireCreatureTrait = this;
            vampireCreatureTrait.setBloodPower(vampireCreatureTrait.bloodPower + quantity);
            if (WitcheryConfigOptions.allowVampireQuests && this.getLevel() == 1 && this.bloodPower == this.getMaxBloodPower()) {
                this.levelUp();
            }
        }
    }

    private final void drinkAnimalBlood(int maxIncrease) {
        if (this.bloodPower < this.getMaxBloodPower() && this.bloodPower < maxIncrease) {
            VampireCreatureTrait vampireCreatureTrait = this;
            vampireCreatureTrait.setBloodPower(vampireCreatureTrait.bloodPower + 2);
            if (this.bloodPower > maxIncrease) {
                this.setBloodPower(maxIncrease);
            }
        }
    }

    public final void fillBloodReserve(int quantity) {
        this.bloodReserve += quantity;
        this.bloodReserve = RangesKt.coerceAtMost(this.bloodReserve, 250);
    }

    public final void useBloodReserve() {
        int temp = this.bloodReserve;
        if (this.bloodPower < this.getMaxBloodPower()) {
            this.bloodReserve = 0;
            this.drinkHumanBlood(temp);
        }
    }

    private final void toggleNightVision() {
        boolean bl = this.nightVision = !this.nightVision;
        if (!((EntityPlayer)this.getPlayerEx().getEntity()).field_70170_p.field_72995_K) {
            if (this.nightVision) {
                ((EntityPlayer)this.getPlayerEx().getEntity()).func_70690_d(new PotionEffect(MobEffects.field_76439_r, 400, 0, true, true));
            } else {
                ((EntityPlayer)this.getPlayerEx().getEntity()).func_184589_d(MobEffects.field_76439_r);
            }
        }
    }

    public final void triggerSelectedPower(@Nullable Entity target) {
        if (this.selectedPower != Power.NONE) {
            EntityPlayer entity = (EntityPlayer)this.getPlayerEx().getEntity();
            block0 : switch (VampireCreatureTrait$WhenMappings.$EnumSwitchMapping$1[this.selectedPower.ordinal()]) {
                case 1: {
                    int drinkAmount;
                    float r;
                    if (!(target instanceof EntityLivingBase)) break;
                    float f = r = ((EntityLivingBase)target).func_70644_a(WitcheryPotionEffects.PARALYSED) ? 2.1f : 1.3f;
                    if (!(target.func_70092_e(entity.field_70165_t, target.field_70163_u, entity.field_70161_v) <= (double)(r * r))) break;
                    int n = drinkAmount = ItemVampireClothes.isDrinkBoostActive((EntityLivingBase)entity) ? 15 : 10;
                    if (CreatureUtil.isWerewolf(target, true)) {
                        entity.func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)entity), 4.0f);
                        World world = entity.field_70170_p;
                        double d = target.field_70165_t;
                        double d2 = target.field_70163_u + (double)target.field_70131_O * 0.8;
                        double d3 = target.field_70161_v;
                        EntityPlayer entityPlayer = entity;
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                        world.func_184148_a(null, d, d2, d3, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, entityPlayer.func_184176_by(), 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        World world2 = entity.field_70170_p;
                        Intrinsics.checkExpressionValueIsNotNull(world2, "entity.world");
                        WitcheryUtils.addNewParticles(world2, EnumParticleTypes.FLAME, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 0.8, target.field_70161_v, 0.0, 20, 0.5, 0.2);
                        break;
                    }
                    if (target instanceof EntityVillageGuard) {
                        this.drinkHumanBlood(((EntityVillageGuard)target).takeBlood(this.getPlayerEx().getCurrentForm() == null ? drinkAmount : 2, (EntityLivingBase)entity));
                        this.getPlayerEx().markChanged();
                        World world = entity.field_70170_p;
                        double d = target.field_70165_t;
                        double d4 = target.field_70163_u + (double)target.field_70131_O * 0.8;
                        double d5 = target.field_70161_v;
                        EntityPlayer entityPlayer = entity;
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                        world.func_184148_a(null, d, d4, d5, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, entityPlayer.func_184176_by(), 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        World world3 = entity.field_70170_p;
                        Intrinsics.checkExpressionValueIsNotNull(world3, "entity.world");
                        WitcheryUtils.addNewParticles(world3, EnumParticleTypes.REDSTONE, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 0.8, target.field_70161_v, 0.0, 20, 0.5, 0.2);
                        this.checkWitnesses(entity, (EntityLivingBase)target);
                        break;
                    }
                    if (target instanceof EntityVillager) {
                        VillagerExtendedData villagerEx = WitcheryDataExtensions.VILLAGER.get((EntityVillager)target);
                        this.drinkHumanBlood(villagerEx.takeBlood(this.getPlayerEx().getCurrentForm() == null ? drinkAmount : 2, (EntityLivingBase)entity));
                        this.getPlayerEx().markChanged();
                        World world = entity.field_70170_p;
                        double d = target.field_70165_t;
                        double d6 = target.field_70163_u + (double)target.field_70131_O * 0.8;
                        double d7 = target.field_70161_v;
                        EntityPlayer entityPlayer = entity;
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                        world.func_184148_a(null, d, d6, d7, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, entityPlayer.func_184176_by(), 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        World world4 = entity.field_70170_p;
                        Intrinsics.checkExpressionValueIsNotNull(world4, "entity.world");
                        WitcheryUtils.addNewParticles(world4, EnumParticleTypes.REDSTONE, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 0.8, target.field_70161_v, 0.0, 20, 0.5, 0.2);
                        this.checkWitnesses(entity, (EntityLivingBase)target);
                        if (this.getLevel() == 2) {
                            if (WitcheryConfigOptions.allowVampireQuests && villagerEx.getBlood() >= 250 && villagerEx.getBlood() <= 280) {
                                if (this.getQuestCount() >= 5) {
                                    if (!this.levelUp()) break;
                                    this.getPlayerEx().markChanged();
                                    break;
                                }
                                SoundEvent soundEvent = SoundEvents.field_189107_dL;
                                Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_PLING");
                                WitcheryUtils.playSoundAt(entity, soundEvent, 1.0f, 1.0f);
                                VampireCreatureTrait vampireCreatureTrait = this;
                                vampireCreatureTrait.setQuestCount(vampireCreatureTrait.getQuestCount() + 1);
                                vampireCreatureTrait.getQuestCount();
                                break;
                            }
                            if (villagerEx.getBlood() >= 240) break;
                            this.setQuestCount(0);
                            break;
                        }
                        if (this.getLevel() != 8 || !this.getCanLevelUp() || !this.villagerInCage((EntityVillager)target)) break;
                        int n2 = villagerEx.getBlood();
                        if (250 <= n2 && 280 >= n2) {
                            if (this.getQuestCount() >= 5) {
                                if (!this.levelUp()) break;
                                this.getPlayerEx().markChanged();
                                break;
                            }
                            SoundEvent soundEvent = SoundEvents.field_189107_dL;
                            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_PLING");
                            WitcheryUtils.playSoundAt(entity, soundEvent, 1.0f, 1.0f);
                            VampireCreatureTrait vampireCreatureTrait = this;
                            vampireCreatureTrait.setQuestCount(vampireCreatureTrait.getQuestCount() + 1);
                            vampireCreatureTrait.getQuestCount();
                            break;
                        }
                        if (villagerEx.getBlood() >= 240) break;
                        this.setQuestCount(0);
                        break;
                    }
                    if (target instanceof EntityPlayer) {
                        this.drinkHumanBlood(WitcheryUtils.getExtension((EntityPlayer)target).takeHumanBlood(this.getPlayerEx().getCurrentForm() == null ? drinkAmount : 2, (EntityLivingBase)entity));
                        this.getPlayerEx().markChanged();
                        World world = entity.field_70170_p;
                        double d = target.field_70165_t;
                        double d8 = target.field_70163_u + (double)target.field_70131_O * 0.8;
                        double d9 = target.field_70161_v;
                        EntityPlayer entityPlayer = entity;
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                        world.func_184148_a(null, d, d8, d9, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, entityPlayer.func_184176_by(), 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        World world5 = entity.field_70170_p;
                        Intrinsics.checkExpressionValueIsNotNull(world5, "entity.world");
                        WitcheryUtils.addNewParticles(world5, EnumParticleTypes.REDSTONE, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 0.8, target.field_70161_v, 0.0, 20, 0.5, 0.2);
                        break;
                    }
                    if (!(target instanceof EntityAnimal)) break;
                    target.func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.func_76355_l(), (Entity)entity), 1.0f);
                    double villagerEx = (double)this.getMaxBloodPower() * 0.25;
                    VampireCreatureTrait vampireCreatureTrait = this;
                    boolean bl = false;
                    double d = Math.ceil(villagerEx);
                    vampireCreatureTrait.drinkAnimalBlood((int)d);
                    this.getPlayerEx().markChanged();
                    World world = entity.field_70170_p;
                    double d10 = target.field_70165_t;
                    double d11 = target.field_70163_u + (double)target.field_70131_O * 0.8;
                    double d12 = target.field_70161_v;
                    EntityPlayer entityPlayer = entity;
                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                    world.func_184148_a(null, d10, d11, d12, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, entityPlayer.func_184176_by(), 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    World world6 = entity.field_70170_p;
                    Intrinsics.checkExpressionValueIsNotNull(world6, "entity.world");
                    WitcheryUtils.addNewParticles(world6, EnumParticleTypes.REDSTONE, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 0.8, target.field_70161_v, 0.0, 20, 0.5, 0.2);
                    break;
                }
                case 2: {
                    EntityPlayer entityPlayer = entity;
                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                    if (entityPlayer.func_70093_af() && this.getLevel() >= 2) {
                        this.toggleNightVision();
                        break;
                    }
                    if (target instanceof EntityLivingBase && this.getPlayerEx().getCurrentForm() == null && this.getLevel() >= 2) {
                        if (target instanceof EntityVillager && !(target instanceof EntityWereVillager) || target instanceof EntityPlayer || target instanceof EntityVillageGuard) {
                            if (!((EntityLivingBase)target).func_70644_a(WitcheryPotionEffects.PARALYSED)) {
                                if (this.decreaseBlood(Power.MESMERIZE.getInitialCost(), true)) {
                                    this.getPlayerEx().markChanged();
                                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(WitcheryPotionEffects.PARALYSED, (5 + this.getLevel() / 2 + RangesKt.coerceAtLeast((this.getLevel() - 4) / 2, 0) + (ItemVampireClothes.isMesmeriseBoostActive((EntityLivingBase)entity) ? 3 : 0)) * 20, this.getLevel() >= 8 ? 5 : 4));
                                    entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), WitcherySounds.ENTITY_VAMPIRE_HYPNOSIS, entity.func_184176_by(), 0.5f, 1.0f);
                                    break;
                                }
                                SoundEvent soundEvent = SoundEvents.field_187688_dI;
                                Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                                WitcheryUtils.playSoundAt(entity, soundEvent, 1.0f, 0.5f);
                                break;
                            }
                            SoundEvent soundEvent = SoundEvents.field_187688_dI;
                            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                            WitcheryUtils.playSoundAt(entity, soundEvent, 1.0f, 0.5f);
                            break;
                        }
                        SoundEvent soundEvent = SoundEvents.field_187688_dI;
                        Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                        WitcheryUtils.playSoundAt(entity, soundEvent, 1.0f, 0.5f);
                        break;
                    }
                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                    WitcheryUtils.playSoundAt(entity, soundEvent, 1.0f, 0.5f);
                    break;
                }
                case 3: {
                    VampireCreatureTrait this_$iv = this;
                    boolean $i$f$checkCooldown = false;
                    if (this_$iv.cooldown <= 0) {
                        this_$iv.cooldown = 10;
                        boolean bl = false;
                        if (this.getPlayerEx().getCurrentForm() == null) {
                            int currentLevel;
                            double d;
                            double d13;
                            boolean bl2;
                            double d14;
                            int n;
                            PotionEffect effect = entity.func_70660_b(MobEffects.field_76424_c);
                            if (effect == null) {
                                n = 0;
                            } else {
                                d14 = (double)effect.func_76458_c() + 1.0;
                                bl2 = false;
                                double d15 = Math.log(d14);
                                d14 = 2.0;
                                d13 = d15;
                                bl2 = false;
                                d = Math.log(d14);
                                d14 = d13 / d;
                                bl2 = false;
                                n = currentLevel = (int)Math.ceil(d14);
                            }
                            if (this.getLevel() >= 4) {
                                d14 = (double)(this.getLevel() - 3) / 2.0;
                                d13 = currentLevel;
                                bl2 = false;
                                d = Math.ceil(d14);
                                if (d13 <= d) {
                                    if (this.decreaseBlood(Power.SPEED.getInitialCost(), true)) {
                                        this.getPlayerEx().markChanged();
                                        EntityPlayer entityPlayer = entity;
                                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                        SoundEvent soundEvent = SoundEvents.field_187646_bt;
                                        Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_FIRE_EXTINGUISH");
                                        WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                                        int level = effect == null ? 2 : (effect.func_76458_c() + 1) * 2;
                                        int duration = effect == null ? 200 : effect.func_76459_b() + 60;
                                        entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration, level - 1, true, true));
                                        entity.func_70690_d(new PotionEffect(MobEffects.field_76430_j, duration, currentLevel + 1, true, true));
                                        break;
                                    }
                                    EntityPlayer entityPlayer = entity;
                                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                                    break;
                                }
                            }
                            EntityPlayer entityPlayer = entity;
                            Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                            SoundEvent soundEvent = SoundEvents.field_187688_dI;
                            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                            break;
                        }
                        EntityPlayer entityPlayer = entity;
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                        SoundEvent soundEvent = SoundEvents.field_187688_dI;
                        Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                        WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        break;
                    }
                    Object e = this_$iv.getPlayerEx().getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(e, "playerEx.entity");
                    EntityPlayer entityPlayer = (EntityPlayer)e;
                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                    Object e2 = this_$iv.getPlayerEx().getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(e2, "playerEx.entity");
                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (((EntityPlayer)e2).func_70681_au().nextFloat() * 0.4f + 0.8f));
                    break;
                }
                case 4: {
                    VampireCreatureTrait this_$iv = this;
                    boolean $i$f$checkCooldown = false;
                    if (this_$iv.cooldown <= 0) {
                        this_$iv.cooldown = 10;
                        boolean bl = false;
                        if (this.getLevel() < 7) {
                            EntityPlayer entityPlayer = entity;
                            Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                            SoundEvent soundEvent = SoundEvents.field_187688_dI;
                            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                            break;
                        }
                        if (this.getPlayerEx().getCurrentForm() == null && this.decreaseBlood(Power.BAT.getInitialCost(), true)) {
                            this.getPlayerEx().markChanged();
                            EntityPlayer entityPlayer = entity;
                            Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                            SoundEvent soundEvent = SoundEvents.field_187646_bt;
                            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_FIRE_EXTINGUISH");
                            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                            this.getPlayerEx().setCurrentForm(WitcheryAlternateForms.BAT);
                            break;
                        }
                        if (Intrinsics.areEqual(this.getPlayerEx().getCurrentForm(), WitcheryAlternateForms.BAT)) {
                            EntityPlayer entityPlayer = entity;
                            Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                            SoundEvent soundEvent = SoundEvents.field_187646_bt;
                            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_FIRE_EXTINGUISH");
                            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                            this.getPlayerEx().setCurrentForm(null);
                            break;
                        }
                        EntityPlayer entityPlayer = entity;
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                        SoundEvent soundEvent = SoundEvents.field_187688_dI;
                        Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                        WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        break;
                    }
                    Object e = this_$iv.getPlayerEx().getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(e, "playerEx.entity");
                    EntityPlayer entityPlayer = (EntityPlayer)e;
                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                    Object e3 = this_$iv.getPlayerEx().getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(e3, "playerEx.entity");
                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (((EntityPlayer)e3).func_70681_au().nextFloat() * 0.4f + 0.8f));
                    break;
                }
                default: {
                    VampireCreatureTrait this_$iv = this;
                    boolean $i$f$checkCooldown = false;
                    if (this_$iv.cooldown <= 0) {
                        this_$iv.cooldown = 10;
                        boolean bl = false;
                        if (this.getLevel() >= 10 && this.charges > 0 && this.getPlayerEx().getCurrentForm() == null) {
                            switch (VampireCreatureTrait$WhenMappings.$EnumSwitchMapping$0[this.ultimatePower.ordinal()]) {
                                case 1: {
                                    WorldInfo worldInfo;
                                    World world = entity.field_70170_p;
                                    Intrinsics.checkExpressionValueIsNotNull(world, "entity.world");
                                    WorldInfo worldInfo2 = worldInfo = world.func_72912_H();
                                    Intrinsics.checkExpressionValueIsNotNull(worldInfo2, "worldInfo");
                                    if (!worldInfo2.func_76059_o()) {
                                        int i = (300 + entity.field_70170_p.field_73012_v.nextInt(600)) * 20;
                                        worldInfo.func_76090_f(i);
                                        worldInfo.func_76069_a(true);
                                        worldInfo.func_76080_g(i);
                                        worldInfo.func_76084_b(true);
                                        EntityPlayer entityPlayer = entity;
                                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                        SoundEvent soundEvent = SoundEvents.field_187646_bt;
                                        Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_FIRE_EXTINGUISH");
                                        WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                                        if (entity.field_71075_bZ.field_75098_d) break block0;
                                        VampireCreatureTrait vampireCreatureTrait = this;
                                        vampireCreatureTrait.charges += -1;
                                        int cfr_ignored_0 = vampireCreatureTrait.charges;
                                        this.getPlayerEx().markChanged();
                                        break;
                                    }
                                    EntityPlayer entityPlayer = entity;
                                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                                    break;
                                }
                                case 2: {
                                    for (int i = 0; i < 15; ++i) {
                                        World world = entity.field_70170_p;
                                        Intrinsics.checkExpressionValueIsNotNull(world, "entity.world");
                                        EntityPlayer entityPlayer = entity;
                                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                        BlockPos blockPos = entityPlayer.func_180425_c().func_177981_b(3);
                                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "entity.position.up(3)");
                                        WitcheryUtils.summonEntity(world, WitcheryEntities.ATTACK_BAT, blockPos, 1, 4, (Function1)new Function1<EntityAttackBat, Unit>(this, entity){
                                            final /* synthetic */ VampireCreatureTrait this$0;
                                            final /* synthetic */ EntityPlayer $entity$inlined;
                                            {
                                                this.this$0 = vampireCreatureTrait;
                                                this.$entity$inlined = entityPlayer;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull EntityAttackBat $this$summonEntity) {
                                                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$summonEntity), "$receiver");
                                                $this$summonEntity.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / ($this$summonEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                                World world = $this$summonEntity.field_70170_p;
                                                Intrinsics.checkExpressionValueIsNotNull(world, "world");
                                                WitcheryUtils.addNewParticles$default(world, EnumParticleTypes.SMOKE_NORMAL, $this$summonEntity.field_70165_t, $this$summonEntity.field_70163_u, $this$summonEntity.field_70161_v, 0.0, 0, 0.0, $this$summonEntity.field_70131_O, 112, null);
                                                EntityPlayer entityPlayer = this.$entity$inlined;
                                                Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                                $this$summonEntity.setOwner(entityPlayer);
                                                $this$summonEntity.func_82236_f(false);
                                                $this$summonEntity.getEntityData().func_74757_a("WitcheryNoDrops", true);
                                            }
                                        });
                                    }
                                    if (entity.field_71075_bZ.field_75098_d) break block0;
                                    VampireCreatureTrait vampireCreatureTrait = this;
                                    vampireCreatureTrait.charges += -1;
                                    int cfr_ignored_1 = vampireCreatureTrait.charges;
                                    this.getPlayerEx().markChanged();
                                    break;
                                }
                                case 3: {
                                    boolean done = false;
                                    EntityPlayer entityPlayer = entity;
                                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                    if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)entityPlayer)) {
                                        BlockPos blockPos;
                                        BlockPos coords = entity.getBedLocation(entity.field_71093_bK);
                                        int dimension = entity.field_71093_bK;
                                        World world = entity.field_70170_p;
                                        Intrinsics.checkExpressionValueIsNotNull(world, "entity.world");
                                        World world7 = world;
                                        BlockPos blockPos2 = coords;
                                        if (blockPos2 != null) {
                                            BlockPos blockPos3 = blockPos2;
                                            boolean bl3 = false;
                                            boolean bl4 = false;
                                            BlockPos it = blockPos3;
                                            boolean bl5 = false;
                                            blockPos = Blocks.field_150324_C.getBedSpawnPosition(world7.func_180495_p(it), (IBlockAccess)world7, it, null);
                                        } else {
                                            blockPos = coords = null;
                                        }
                                        if (coords != null) {
                                            if (dimension == entity.field_71093_bK && entity.func_70092_e((double)coords.func_177958_n(), entity.field_70163_u, (double)coords.func_177952_p()) <= 36.0) {
                                                Village village = world7.field_72982_D.func_176056_a(entity.func_180425_c(), 512);
                                                if (village != null) {
                                                    BlockPos townPos;
                                                    BlockPos blockPos4 = townPos = village.func_180608_a();
                                                    Intrinsics.checkExpressionValueIsNotNull(blockPos4, "townPos");
                                                    if (this.teleport(blockPos4, dimension, (Entity)entity, true)) {
                                                        done = true;
                                                    }
                                                }
                                            } else if (this.teleport(coords, dimension, (Entity)entity, true)) {
                                                done = true;
                                            }
                                        }
                                    }
                                    if (!done) {
                                        SoundEvent soundEvent = SoundEvents.field_187688_dI;
                                        Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                                        WitcheryUtils.playSoundAt(entity, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                                        break;
                                    }
                                    if (entity.field_71075_bZ.field_75098_d) break block0;
                                    VampireCreatureTrait vampireCreatureTrait = this;
                                    vampireCreatureTrait.charges += -1;
                                    int cfr_ignored_2 = vampireCreatureTrait.charges;
                                    this.getPlayerEx().markChanged();
                                    break;
                                }
                                default: {
                                    EntityPlayer entityPlayer = entity;
                                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                                    break;
                                }
                            }
                            break;
                        }
                        EntityPlayer entityPlayer = entity;
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "entity");
                        SoundEvent soundEvent = SoundEvents.field_187688_dI;
                        Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                        WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (entity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        break;
                    }
                    Object e = this_$iv.getPlayerEx().getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(e, "playerEx.entity");
                    EntityPlayer entityPlayer = (EntityPlayer)e;
                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                    Object e4 = this_$iv.getPlayerEx().getEntity();
                    Intrinsics.checkExpressionValueIsNotNull(e4, "playerEx.entity");
                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (((EntityPlayer)e4).func_70681_au().nextFloat() * 0.4f + 0.8f));
                }
            }
        }
    }

    private final void checkCooldown(Function0<Unit> action) {
        int $i$f$checkCooldown = 0;
        if (this.cooldown <= 0) {
            this.cooldown = 10;
            action.invoke();
        } else {
            Object e = this.getPlayerEx().getEntity();
            Intrinsics.checkExpressionValueIsNotNull(e, "playerEx.entity");
            EntityPlayer entityPlayer = (EntityPlayer)e;
            SoundEvent soundEvent = SoundEvents.field_187688_dI;
            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
            Object e2 = this.getPlayerEx().getEntity();
            Intrinsics.checkExpressionValueIsNotNull(e2, "playerEx.entity");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (((EntityPlayer)e2).func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    private final void checkWitnesses(EntityPlayer player, EntityLivingBase victim) {
        for (EntityVillageGuard guard : victim.field_70170_p.func_72872_a(EntityVillageGuard.class, victim.func_174813_aQ().func_72321_a(16.0, 8.0, 16.0))) {
            if (guard.func_70644_a(WitcheryPotionEffects.PARALYSED)) continue;
            EntityVillageGuard entityVillageGuard = guard;
            Intrinsics.checkExpressionValueIsNotNull(entityVillageGuard, "guard");
            if (!entityVillageGuard.func_70635_at().func_75522_a((Entity)victim)) continue;
            guard.func_70624_b((EntityLivingBase)player);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean villagerInCage(EntityVillager target) {
        BlockPos pos = target.func_190671_u_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
        int n = -1;
        int n2 = 1;
        while (n <= n2) {
            void x;
            int n3 = -1;
            int n4 = 1;
            while (n3 <= n4) {
                void z;
                World world = target.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull(world, "target.world");
                BlockPos.MutableBlockPos mutableBlockPos = mutable.func_189534_c(EnumFacing.EAST, (int)x).func_189534_c(EnumFacing.SOUTH, (int)z);
                Intrinsics.checkExpressionValueIsNotNull(mutableBlockPos, "mutable.move(EnumFacing.\u2026move(EnumFacing.SOUTH, z)");
                if (this.isCaged(world, mutableBlockPos)) {
                    return true;
                }
                mutable.func_189533_g((Vec3i)pos);
                ++z;
            }
            ++x;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCaged(World world, BlockPos.MutableBlockPos mutable) {
        int n;
        int n2;
        int n3;
        int barCount = 0;
        BlockPos pos = mutable.func_185334_h();
        int n4 = 0;
        int n5 = 1;
        while (n4 <= n5) {
            void y;
            n3 = -1;
            n2 = 1;
            while (n3 <= n2) {
                void x;
                n = -1;
                int n6 = 1;
                while (n <= n6) {
                    void z;
                    if (x != false || z != false) {
                        IBlockState iBlockState = world.func_180495_p((BlockPos)mutable.func_189534_c(EnumFacing.EAST, (int)x).func_189534_c(EnumFacing.SOUTH, (int)z).func_189534_c(EnumFacing.UP, (int)y));
                        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(muta\u2026).move(EnumFacing.UP, y))");
                        Block block = Blocks.field_150411_aY;
                        Intrinsics.checkExpressionValueIsNotNull(block, "Blocks.IRON_BARS");
                        if (WitcheryUtils.isOf(iBlockState, block)) {
                            ++barCount;
                        }
                        mutable.func_189533_g((Vec3i)pos);
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        if (barCount < 15) {
            return false;
        }
        int woodCount = 0;
        mutable.func_189534_c(EnumFacing.UP, 2);
        n5 = -1;
        n3 = 1;
        while (n5 <= n3) {
            void x;
            n2 = -1;
            n = 1;
            while (n2 <= n) {
                void z;
                if (!BlockUtil.isReplaceableBlock(world, (BlockPos)mutable.func_189534_c(EnumFacing.EAST, (int)x).func_189534_c(EnumFacing.SOUTH, (int)z))) {
                    ++woodCount;
                }
                mutable.func_189533_g((Vec3i)pos);
                mutable.func_189534_c(EnumFacing.UP, 2);
                ++z;
            }
            ++x;
        }
        return woodCount >= 9;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean teleport(@NotNull BlockPos position, int dimension, @NotNull Entity entity, boolean presetPosition) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        MinecraftServer minecraftServer = entity.func_184102_h();
        if (minecraftServer == null) {
            Intrinsics.throwNpe();
        }
        WorldServer targetWorld = minecraftServer.func_71218_a(dimension);
        BlockPos original = position.func_177984_a();
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos(original);
        if (current.func_177956_o() < 250 && !BlockUtil.isReplaceableBlock((World)targetWorld, (BlockPos)current) && BlockUtil.isReplaceableBlock((World)targetWorld, (BlockPos)current.func_189536_c(EnumFacing.UP)) && BlockUtil.isReplaceableBlock((World)targetWorld, (BlockPos)current.func_189536_c(EnumFacing.UP))) {
            TeleportationUtil.teleportToLocation((BlockPos)current.func_189536_c(EnumFacing.DOWN), dimension, entity, presetPosition);
            return true;
        }
        int n = 0;
        int n2 = 15;
        while (n <= n2) {
            void i;
            current.func_189533_g((Vec3i)original);
            current.func_189534_c(EnumFacing.DOWN, (int)i);
            if (i > 0 && current.func_177956_o() > 1 && !BlockUtil.isReplaceableBlock((World)targetWorld, (BlockPos)current) && BlockUtil.isReplaceableBlock((World)targetWorld, (BlockPos)current.func_189536_c(EnumFacing.UP)) && BlockUtil.isReplaceableBlock((World)targetWorld, (BlockPos)current.func_189536_c(EnumFacing.UP))) {
                TeleportationUtil.teleportToLocation((BlockPos)current.func_189536_c(EnumFacing.DOWN), dimension, entity, presetPosition);
                return true;
            }
            ++i;
        }
        return false;
    }

    public VampireCreatureTrait(@NotNull PlayerExtendedData playerEx) {
        Intrinsics.checkParameterIsNotNull(playerEx, "playerEx");
        super(playerEx, WitcheryCreatureTraits.VAMPIRE);
        this.ultimatePower = Ultimate.NONE;
        this.selectedPower = Power.NONE;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0001\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power;", "", "initialCost", "", "upkeepCost", "levelCap", "(Ljava/lang/String;IIII)V", "getInitialCost", "()I", "getLevelCap", "getUpkeepCost", "cycle", "max", "reverse", "", "NONE", "DRINK", "MESMERIZE", "SPEED", "BAT", "ULTIMATE", "Companion", "WitcheryResurrected"})
    public static final class Power
    extends Enum<Power> {
        public static final /* enum */ Power NONE;
        public static final /* enum */ Power DRINK;
        public static final /* enum */ Power MESMERIZE;
        public static final /* enum */ Power SPEED;
        public static final /* enum */ Power BAT;
        public static final /* enum */ Power ULTIMATE;
        private static final /* synthetic */ Power[] $VALUES;
        private final int initialCost;
        private final int upkeepCost;
        private final int levelCap;
        @JvmField
        @NotNull
        public static final Power[] VALUES;
        public static final Companion Companion;

        static {
            Power[] powerArray = new Power[6];
            Power[] powerArray2 = powerArray;
            powerArray[0] = NONE = new Power(0, 0, 0);
            powerArray[1] = DRINK = new Power(0, 0, 1);
            powerArray[2] = MESMERIZE = new Power(50, 0, 2);
            powerArray[3] = SPEED = new Power(10, 0, 4);
            powerArray[4] = BAT = new Power(50, 1, 7);
            powerArray[5] = ULTIMATE = new Power(50, 0, 10);
            $VALUES = powerArray;
            Companion = new Companion(null);
            VALUES = Power.values();
        }

        @NotNull
        public final Power cycle(@NotNull Power max, boolean reverse) {
            Intrinsics.checkParameterIsNotNull((Object)max, "max");
            if (reverse) {
                return this == NONE ? max : VALUES[this.ordinal() - 1];
            }
            return this == max ? NONE : VALUES[this.ordinal() + 1];
        }

        public static /* synthetic */ Power cycle$default(Power power, Power power2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return power.cycle(power2, bl);
        }

        public final int getInitialCost() {
            return this.initialCost;
        }

        public final int getUpkeepCost() {
            return this.upkeepCost;
        }

        public final int getLevelCap() {
            return this.levelCap;
        }

        private Power(int initialCost, int upkeepCost, int levelCap) {
            this.initialCost = initialCost;
            this.upkeepCost = upkeepCost;
            this.levelCap = levelCap;
        }

        public static Power[] values() {
            return (Power[])$VALUES.clone();
        }

        public static Power valueOf(String string) {
            return Enum.valueOf(Power.class, string);
        }

        @JvmStatic
        @NotNull
        public static final Power getMax(int level) {
            return Companion.getMax(level);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power$Companion;", "", "()V", "VALUES", "", "Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power;", "[Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power;", "getMax", "level", "", "WitcheryResurrected"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Power getMax(int level) {
                for (Power value : VALUES) {
                    if (value.getLevelCap() <= level) continue;
                    return VALUES[value.ordinal() - 1];
                }
                return ULTIMATE;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Ultimate;", "", "(Ljava/lang/String;I)V", "NONE", "STORM", "SWARM", "FARM", "Companion", "WitcheryResurrected"})
    public static final class Ultimate
    extends Enum<Ultimate> {
        public static final /* enum */ Ultimate NONE;
        public static final /* enum */ Ultimate STORM;
        public static final /* enum */ Ultimate SWARM;
        public static final /* enum */ Ultimate FARM;
        private static final /* synthetic */ Ultimate[] $VALUES;
        @JvmField
        @NotNull
        public static final Ultimate[] VALUES;
        public static final Companion Companion;

        static {
            Ultimate[] ultimateArray = new Ultimate[4];
            Ultimate[] ultimateArray2 = ultimateArray;
            ultimateArray[0] = NONE = new Ultimate();
            ultimateArray[1] = STORM = new Ultimate();
            ultimateArray[2] = SWARM = new Ultimate();
            ultimateArray[3] = FARM = new Ultimate();
            $VALUES = ultimateArray;
            Companion = new Companion(null);
            VALUES = Ultimate.values();
        }

        public static Ultimate[] values() {
            return (Ultimate[])$VALUES.clone();
        }

        public static Ultimate valueOf(String string) {
            return Enum.valueOf(Ultimate.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Ultimate$Companion;", "", "()V", "VALUES", "", "Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Ultimate;", "[Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Ultimate;", "WitcheryResurrected"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

