/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;

public abstract class BlockActionSphere {
    protected abstract void onBlock(World var1, BlockPos var2);

    protected void onComplete() {
    }

    public void drawHollowSphere(World world, BlockPos pos, int radius) {
        if (radius == 1) {
            this.drawPixel(world, pos);
        } else {
            int x = --radius;
            int radiusError = 1 - x;
            for (int y = 0; x >= y; ++y) {
                this.drawCircle(world, pos, y, x, radiusError);
                if (radiusError < 0) {
                    radiusError += 2 * y + 1;
                    continue;
                }
                radiusError += 2 * (y - --x + 1);
            }
        }
        this.onComplete();
    }

    private void drawCircle(World world, BlockPos pos, int y, int radius, int error0) {
        int x = radius;
        int radiusError = error0;
        for (int z = 0; x >= z; ++z) {
            this.drawPixel(world, pos.func_177982_a(x, y, z));
            this.drawPixel(world, pos.func_177982_a(-x, y, z));
            this.drawPixel(world, pos.func_177982_a(x, -y, z));
            this.drawPixel(world, pos.func_177982_a(-x, -y, z));
            this.drawPixel(world, pos.func_177982_a(x, y, -z));
            this.drawPixel(world, pos.func_177982_a(-x, y, -z));
            this.drawPixel(world, pos.func_177982_a(x, -y, -z));
            this.drawPixel(world, pos.func_177982_a(-x, -y, -z));
            this.drawPixel(world, pos.func_177982_a(z, y, x));
            this.drawPixel(world, pos.func_177982_a(-z, y, x));
            this.drawPixel(world, pos.func_177982_a(z, -y, x));
            this.drawPixel(world, pos.func_177982_a(-z, -y, x));
            this.drawPixel(world, pos.func_177982_a(z, y, -x));
            this.drawPixel(world, pos.func_177982_a(-z, y, -x));
            this.drawPixel(world, pos.func_177982_a(z, -y, -x));
            this.drawPixel(world, pos.func_177982_a(-z, -y, -x));
            this.drawPixel(world, pos.func_177982_a(y, x, z));
            this.drawPixel(world, pos.func_177982_a(-y, x, z));
            this.drawPixel(world, pos.func_177982_a(y, -x, z));
            this.drawPixel(world, pos.func_177982_a(-y, -x, z));
            this.drawPixel(world, pos.func_177982_a(y, x, -z));
            this.drawPixel(world, pos.func_177982_a(-y, x, -z));
            this.drawPixel(world, pos.func_177982_a(y, -x, -z));
            this.drawPixel(world, pos.func_177982_a(-y, -x, -z));
            this.drawPixel(world, pos.func_177982_a(z, x, y));
            this.drawPixel(world, pos.func_177982_a(-z, x, y));
            this.drawPixel(world, pos.func_177982_a(z, -x, y));
            this.drawPixel(world, pos.func_177982_a(-z, -x, y));
            this.drawPixel(world, pos.func_177982_a(z, x, -y));
            this.drawPixel(world, pos.func_177982_a(-z, x, -y));
            this.drawPixel(world, pos.func_177982_a(z, -x, -y));
            this.drawPixel(world, pos.func_177982_a(-z, -x, -y));
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    public void drawFilledSphere(World world, BlockPos pos, int radius) {
        if (radius == 1) {
            this.drawPixel(world, pos);
        } else {
            int radiusSq = radius * radius;
            for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius))) {
                if (!(pos.func_177951_i((Vec3i)p) < (double)(radiusSq - 1))) continue;
                this.drawPixel(world, p);
            }
        }
        this.onComplete();
    }

    private void drawPixel(World world, BlockPos pos) {
        this.onBlock(world, pos);
    }

    protected void fillWith(World world, BlockPos pos, int radius, Block edgeBlock) {
        this.fillHalfWithAirY(world, pos, 1, radius, edgeBlock);
        this.fillHalfWithAirY(world, pos.func_177977_b(), -1, radius, edgeBlock);
    }

    private void fillHalfWithAirY(World world, BlockPos pos, int dy, int radius, Block edgeBlock) {
        for (int y = 0; y <= radius; ++y) {
            BlockPos real = pos.func_177981_b(y * dy);
            if (world.func_180495_p(pos).func_177230_c() == edgeBlock) break;
            this.fillSliceWithAir(world, real, radius, Blocks.field_150350_a, edgeBlock);
        }
    }

    private void fillSliceWithAir(World world, BlockPos pos, int radius, Block fillBlock, Block edgeBlock) {
        this.fillHalfWithAirX(world, pos, 1, radius, fillBlock, edgeBlock);
        this.fillHalfWithAirX(world, pos.func_177976_e(), -1, radius, fillBlock, edgeBlock);
    }

    private void fillHalfWithAirX(World world, BlockPos pos, int dx, int radius, Block fillBlock, Block edgeBlock) {
        BlockPos real;
        for (int x = 0; x <= radius && world.func_180495_p(real = pos.func_177965_g(x * dx)).func_177230_c() != edgeBlock; ++x) {
            this.fillLineWithAir(world, real, radius, fillBlock, edgeBlock);
        }
    }

    private void fillLineWithAir(World world, BlockPos pos, int radius, Block fillBlock, Block edgeBlock) {
        this.fillHalfWithAirZ(world, pos, 1, radius, fillBlock, edgeBlock);
        this.fillHalfWithAirZ(world, pos.func_177978_c(), -1, radius, fillBlock, edgeBlock);
    }

    private void fillHalfWithAirZ(World world, BlockPos pos, int dz, int radius, Block fillBlock, Block edgeBlock) {
        BlockPos real;
        Block foundBlock;
        for (int z = 0; z <= radius && (foundBlock = world.func_180495_p(real = pos.func_177970_e(z * dz)).func_177230_c()) != edgeBlock; ++z) {
            if (foundBlock == fillBlock || foundBlock != Blocks.field_150355_j && foundBlock != Blocks.field_150358_i && foundBlock != WitcheryBlocks.BREW_GAS && foundBlock != WitcheryBlocks.BREW_LIQUID) continue;
            world.func_175656_a(real, fillBlock.func_176223_P());
        }
    }
}

