/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.WitcheryUtils;

@Deprecated
public class BlockUtil {
    public static void notifyBlockUpdate(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 0);
    }

    public static IBlockState getBlock(World world, int posX, int posY, int posZ) {
        return world.func_180495_p(new BlockPos(posX, posY, posZ));
    }

    public static IBlockState getBlock(World world, double posX, double posY, double posZ) {
        int x = MathHelper.func_76128_c((double)posX);
        int y = MathHelper.func_76128_c((double)posY);
        int z = MathHelper.func_76128_c((double)posZ);
        return BlockUtil.getBlock(world, x, y, z);
    }

    public static IBlockState getBlock(World world, RayTraceResult mop) {
        return BlockUtil.getBlock(world, mop, false);
    }

    public static boolean isReplaceableBlock(World world, int posX, int posY, int posZ) {
        return BlockUtil.isReplaceableBlock(world, posX, posY, posZ, null);
    }

    public static boolean isReplaceableBlock(World world, int posX, int posY, int posZ, EntityLivingBase player) {
        return BlockUtil.isReplaceableBlock(world, new BlockPos(posX, posY, posZ), player);
    }

    public static boolean isReplaceableBlock(World world, BlockPos pos) {
        return BlockUtil.isReplaceableBlock(world, pos, null);
    }

    public static boolean isReplaceableBlock(World world, BlockPos pos, EntityLivingBase player) {
        IBlockState state = world.func_180495_p(pos);
        if (player != null && !WitcheryUtils.isBlockBreakable(world, pos, state)) {
            return false;
        }
        return state.func_185904_a().func_76222_j();
    }

    public static Material getBlockMaterial(EntityPlayer player) {
        return BlockUtil.getBlockMaterial(player, 0);
    }

    public static Material getBlockMaterial(EntityPlayer player, int yOffset) {
        int posX = MathHelper.func_76128_c((double)player.field_70165_t);
        int posY = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b) + yOffset;
        int posZ = MathHelper.func_76128_c((double)player.field_70161_v);
        return BlockUtil.getBlockMaterial(player.field_70170_p, posX, posY, posZ);
    }

    public static Material getBlockMaterial(World world, int posX, int posY, int posZ) {
        return world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185904_a();
    }

    public static IBlockState getBlock(World world, RayTraceResult mop, boolean before) {
        if (mop == null) {
            return null;
        }
        if (mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            int posX = MathHelper.func_76128_c((double)mop.field_72308_g.field_70165_t);
            int posY = MathHelper.func_76128_c((double)mop.field_72308_g.field_70163_u) - 1;
            int posZ = MathHelper.func_76128_c((double)mop.field_72308_g.field_70161_v);
            return BlockUtil.getBlock(world, posX, posY, posZ);
        }
        if (before) {
            int x = mop.func_178782_a().func_177958_n() + (mop.field_178784_b == EnumFacing.NORTH ? -1 : (mop.field_178784_b == EnumFacing.SOUTH ? 1 : 0));
            int y = mop.func_178782_a().func_177956_o() + (mop.field_178784_b == EnumFacing.DOWN ? -1 : (mop.field_178784_b == EnumFacing.UP ? 1 : 0));
            int z = mop.func_178782_a().func_177952_p() + (mop.field_178784_b == EnumFacing.EAST ? -1 : (mop.field_178784_b == EnumFacing.WEST ? 1 : 0));
            if (mop.field_178784_b == EnumFacing.UP && !world.func_180495_p(new BlockPos(x, mop.func_178782_a().func_177956_o(), z)).func_185904_a().func_76220_a()) {
                --y;
            }
            return BlockUtil.getBlock(world, x, y, z);
        }
        return BlockUtil.getBlock(world, mop.func_178782_a().func_177958_n(), mop.func_178782_a().func_177956_o(), mop.func_178782_a().func_177952_p());
    }

    public static BlockPos getBlockCoords(World world, RayTraceResult mop, boolean before) {
        if (mop == null) {
            return null;
        }
        if (mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return mop.field_72308_g.func_180425_c().func_177977_b();
        }
        if (before) {
            BlockPos pos = mop.func_178782_a();
            if (mop.field_178784_b == EnumFacing.UP && !world.func_180495_p(new BlockPos(pos.func_177958_n(), mop.func_178782_a().func_177956_o(), pos.func_177952_p())).func_185904_a().func_76220_a()) {
                pos = pos.func_177977_b();
            }
            return pos;
        }
        return mop.func_178782_a();
    }

    public static void setBlock(World world, int posX, int posY, int posZ, IBlockState state, int updateFlags) {
        world.func_180501_a(new BlockPos(posX, posY, posZ), state, updateFlags);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, Block newBlock) {
        world.func_175656_a(new BlockPos(posX, posY, posZ), newBlock != null ? newBlock.func_176223_P() : Blocks.field_150350_a.func_176223_P());
    }

    public static void setBlock(World world, double posX, double posY, double posZ, Block block) {
        int x = MathHelper.func_76128_c((double)posX);
        int y = MathHelper.func_76128_c((double)posY);
        int z = MathHelper.func_76128_c((double)posZ);
        BlockUtil.setBlock(world, x, y, z, block);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, ItemBlock item, int damage, int updateFlags) {
        world.func_180501_a(new BlockPos(posX, posY, posZ), item.func_179223_d().func_176203_a(damage), updateFlags);
    }

    public static void setBlockState(World world, int posX, int posY, int posZ, IBlockState state) {
        BlockUtil.setBlockState(world, posX, posY, posZ, state, 3);
    }

    public static void setBlockState(World world, int posX, int posY, int posZ, IBlockState state, int updateFlags) {
        world.func_180501_a(new BlockPos(posX, posY, posZ), state, updateFlags);
    }

    public static void setAirBlock(World world, int x, int y, int z, int updateFlags) {
        world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), updateFlags);
    }

    public static void notifyNeighborsOfBlockChange(World world, BlockPos pos, Block blockType) {
        world.func_175722_b(pos, blockType, true);
    }

    public static boolean isMovableBlock(Block block) {
        return block != WitcheryBlocks.ALTAR && block != WitcheryBlocks.VOID_BRAMBLE && block != Blocks.field_150357_h;
    }

    public static boolean isSolid(World world, int posX, int posY, int posZ) {
        IBlockState block = BlockUtil.getBlock(world, posX, posY, posZ);
        return !block.func_185904_a().func_76222_j();
    }

    public static boolean isNormalCube(IBlockState block) {
        return block.func_185904_a().func_76230_c() && block.func_185917_h();
    }

    public static BlockPos getClosestPlantableBlock(World world, BlockPos pos, EnumFacing side, EntityLivingBase entity) {
        return BlockUtil.getClosestPlantableBlock(world, pos, side, entity, false);
    }

    public static BlockPos getClosestPlantableBlock(World world, BlockPos pos, EnumFacing side, EntityLivingBase entity, boolean allowAir) {
        boolean foundBase = false;
        if (!(!BlockUtil.isReplaceableBlock(world, pos) || allowAir && world.func_175623_d(pos))) {
            while (BlockUtil.isReplaceableBlock(world, pos = pos.func_177977_b())) {
            }
            foundBase = true;
        } else if (side == EnumFacing.UP) {
            foundBase = true;
        } else if (side != EnumFacing.DOWN && BlockUtil.isReplaceableBlock(world, pos = pos.func_177972_a(side))) {
            boolean bl = foundBase = !BlockUtil.isReplaceableBlock(world, pos = pos.func_177977_b());
        }
        if (foundBase) {
            IBlockState replaceBlock = world.func_180495_p(pos.func_177984_a());
            if (WitcheryUtils.isBlockBreakable(world, pos.func_177984_a(), replaceBlock)) {
                return pos.func_177984_a();
            }
        }
        return null;
    }

    public static void setBlockIfReplaceable(World world, BlockPos pos, Block block) {
        BlockUtil.setBlockIfReplaceable(world, pos, block.func_176223_P());
    }

    public static boolean setBlockIfReplaceable(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos, state, 3);
            return true;
        }
        return false;
    }
}

