/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityBabaYaga;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityImp;
import net.msrandom.witchery.entity.EntityLeonard;
import net.msrandom.witchery.entity.EntityLordOfTorment;
import net.msrandom.witchery.entity.EntityReflection;
import net.msrandom.witchery.entity.EntityVampire;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.entity.item.EntityCrossbowBolt;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.entity.monster.EntityLilith;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.brew.InfusedBrewEffect;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.infusions.WitcheryInfusedBrews;
import net.msrandom.witchery.init.items.WitcheryBoltItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.item.ItemVampireClothes;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.item.bolts.ItemCrossbowBolt;
import net.msrandom.witchery.resources.CreatureFormStatManager;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.util.damage.EntityDamageSourceIndirectSilver;

@Deprecated
public class CreatureUtil {
    private CreatureUtil() {
    }

    public static boolean isDemonic(Entity entity) {
        if (entity != null) {
            if (entity instanceof EntityDemon || entity instanceof EntityGhast || entity instanceof EntityBlaze || entity instanceof EntityMagmaCube || entity instanceof EntityLeonard || entity instanceof EntityLordOfTorment || entity instanceof EntityImp || entity instanceof EntityLilith || entity instanceof EntityWither) {
                return true;
            }
            if (entity instanceof EntityPlayer) {
                return false;
            }
            return IntegrationManager.isDemon(entity);
        }
        return false;
    }

    public static boolean isUndead(Entity entity) {
        if (entity != null) {
            if (entity instanceof EntityLiving) {
                EntityLiving living2 = (EntityLiving)entity;
                return living2.func_70662_br();
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                return playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE) || InfusedBrewEffect.getActiveBrew(player) == WitcheryInfusedBrews.GRAVE;
            }
        }
        return false;
    }

    public static boolean isWitch(Entity entity) {
        if (entity != null) {
            if (entity instanceof EntityWitch || entity instanceof EntityBabaYaga) {
                return true;
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    Item item = stack.func_77973_b();
                    if (item != WitcheryPoppetItems.VOODOO && item != WitcheryPoppetItems.VAMPIRIC) continue;
                    return true;
                }
                return Infusion.getInfusion(player).isValidForSpells();
            }
        }
        return false;
    }

    public static boolean isWoodenDamage(DamageSource source) {
        EntityCrossbowBolt bolt;
        if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityLivingBase) {
            ItemSword sword;
            EntityLivingBase living2 = (EntityLivingBase)source.func_76364_f();
            if (living2 instanceof EntityHornedHuntsman && !source.func_76352_a()) {
                return true;
            }
            ItemStack stack = living2.func_184614_ca();
            if (stack.func_77973_b() instanceof ItemSword ? (sword = (ItemSword)stack.func_77973_b()).func_150932_j().equalsIgnoreCase(Item.ToolMaterial.WOOD.toString()) : stack.func_77973_b() == WitcheryIngredientItems.STAKE || living2.func_184592_cb().func_77973_b() == WitcheryIngredientItems.STAKE) {
                return true;
            }
        }
        if ((bolt = EntityCrossbowBolt.getSourceBolt(source)) != null) {
            Item item = bolt.func_184550_j().func_77973_b();
            return ((ItemCrossbowBolt)item).isWooden();
        }
        return false;
    }

    public static boolean isSilverDamage(DamageSource source) {
        EntityLivingBase entity;
        ItemStack stack;
        if (source instanceof EntityDamageSourceIndirectSilver) {
            return true;
        }
        if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityCrossbowBolt) {
            EntityCrossbowBolt bolt = (EntityCrossbowBolt)source.func_76364_f();
            return bolt.func_184550_j().func_77973_b() == WitcheryBoltItems.SILVER_BOLT;
        }
        if (!source.func_76352_a() && source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && !(stack = (entity = (EntityLivingBase)source.func_76346_g()).func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemSword) {
            return ((ItemSword)stack.func_77973_b()).func_150932_j().contains("SILVER");
        }
        return false;
    }

    public static boolean isWerewolf(Entity entity) {
        return CreatureUtil.isWerewolf(entity, false);
    }

    public static boolean isWerewolf(Entity entity, boolean includeUnshifted) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityWerewolf) {
            return true;
        }
        if (entity instanceof EntityReflection) {
            return CreatureUtil.isWerewolf((Entity)((EntityReflection)entity).getReflected(), includeUnshifted);
        }
        if (entity instanceof EntityWereVillager) {
            return includeUnshifted;
        }
        if (entity instanceof EntityPlayer) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)entity);
            return includeUnshifted && playerEx.isTransformation(WitcheryCreatureTraits.WEREWOLF) || playerEx.getCurrentForm() != null && CreatureFormStatManager.INSTANCE.getStats(playerEx.getCurrentForm()).canHowl();
        }
        return WitcheryConfigOptions.werewolfEntities.contains(entity.getClass());
    }

    public static boolean isVampire(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityVampire) {
            return true;
        }
        if (entity instanceof EntityPlayer) {
            return WitcheryUtils.getExtension((EntityPlayer)entity).isTransformation(WitcheryCreatureTraits.VAMPIRE);
        }
        if (entity instanceof EntityLiving) {
            String name2 = entity.getClass().getSimpleName();
            return name2.toUpperCase().contains("VAMPIRE");
        }
        return false;
    }

    public static boolean isImmuneToDisease(EntityLivingBase livingEntity) {
        return CreatureUtil.isUndead((Entity)livingEntity) || CreatureUtil.isDemonic((Entity)livingEntity) || CreatureUtil.isWerewolf((Entity)livingEntity, true) || !livingEntity.func_184222_aU() || livingEntity instanceof EntityGolem;
    }

    public static boolean checkForVampireDeath(EntityLivingBase creature2, DamageSource source) {
        boolean dead = false;
        if (source == DamageSource.field_76380_i || source.func_180136_u()) {
            dead = true;
        } else if (source.func_76347_k() || source instanceof EntityUtil.DamageSourceVampireFire) {
            dead = ItemVampireClothes.isExtendedFlameProtectionActive(creature2) ? creature2.field_70170_p.field_73012_v.nextInt(4) == 0 : !ItemVampireClothes.isFlameProtectionActive(creature2) || creature2.field_70170_p.field_73012_v.nextInt(4) != 0;
        } else if (source instanceof EntityUtil.DamageSourceSunlight || source.field_76373_n.equals("boil") || source.field_76373_n.equals("stake")) {
            dead = true;
        } else if (creature2 instanceof EntityPlayer && IntegrationManager.canVampireBeKilled((EntityPlayer)creature2)) {
            dead = true;
        } else if (source == DamageSource.field_76368_d) {
            dead = true;
        } else if (source.func_76346_g() != null && (CreatureUtil.isWerewolf(source.func_76346_g()) || CreatureUtil.isVampire(source.func_76346_g()) || !source.func_76346_g().func_184222_aU())) {
            dead = true;
        } else if (CreatureUtil.isWerewolf((Entity)creature2, true) && CreatureUtil.isSilverDamage(source)) {
            dead = true;
        }
        if (!dead) {
            creature2.func_70606_j(1.0f);
            if (creature2 instanceof EntityPlayer) {
                ((EntityPlayer)creature2).func_71024_bL().func_75113_a(5.0f);
            }
            if (source.func_94541_c() && creature2.field_70170_p.field_73012_v.nextInt(4) == 0) {
                creature2.func_70015_d(2);
            }
            return true;
        }
        return false;
    }

    public static boolean isInSunlight(EntityLivingBase entity) {
        int z;
        int y;
        World world = entity.field_70170_p;
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)entity) || WitcheryDimensions.TORMENT.isInDimension((Entity)entity) || !world.field_73011_w.func_191066_m() || !world.field_73011_w.func_76569_d() || !world.func_72935_r()) {
            return false;
        }
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)entity.field_70163_u), z = MathHelper.func_76128_c((double)entity.field_70161_v));
        Biome biome = world.getBiomeForCoordsBody(pos);
        return !WitcheryConfigOptions.nightBiomes.contains(biome) && (!world.func_72896_J() || !biome.func_76738_d()) && world.func_175678_i(pos.func_177982_a(0, MathHelper.func_76123_f((float)entity.field_70131_O), 0));
    }
}

