/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.entity.ai.EntityAIAttackOnCollide;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.IHandleDeathTouch;

@Deprecated
public class EntityUtil {
    private EntityUtil() {
    }

    public static EntityPlayer playerOrFake(World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return (EntityPlayer)entity;
        }
        if (!(world instanceof WorldServer)) {
            return null;
        }
        return FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
    }

    public static void pullTowards(Entity entity, Vec3d target, double dy, double yy) {
        if (entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman || entity.func_174791_d().equals((Object)target)) {
            return;
        }
        double d = target.field_72450_a - entity.field_70165_t;
        double d2 = target.field_72448_b - entity.field_70163_u;
        double d3 = target.field_72449_c - entity.field_70161_v;
        float distance = MathHelper.func_76133_a((double)(d * d + d2 * d2 + d3 * d3));
        if ((double)distance < 0.01) {
            return;
        }
        float f2 = 0.1f + (float)dy;
        double mx = d / (double)distance * (double)f2 * (double)distance;
        double my = yy == 0.0 ? 0.4 : d2 / (double)distance * (double)distance * 0.2 + 0.2 + yy;
        double mz = d3 / (double)distance * (double)f2 * (double)distance;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 20, 1));
        }
        if (entity instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(mx, my, mz), (EntityPlayerMP)entity);
        } else {
            entity.field_70159_w = mx;
            entity.field_70181_x = my;
            entity.field_70179_y = mz;
        }
    }

    public static void pushback(Entity entity, Vec3d hit, double xyScale, double ySpeed) {
        double d = hit.field_72450_a - entity.field_70165_t;
        double d2 = hit.field_72448_b - entity.field_70163_u;
        double d3 = hit.field_72449_c - entity.field_70161_v;
        Vec3d vec = new Vec3d(d, d2, d3).func_72432_b();
        double dx = -vec.field_72450_a * xyScale;
        double dy = Math.max(-vec.field_72448_b, ySpeed);
        double dz = -vec.field_72449_c * xyScale;
        if (entity instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(dx, dy, dz), (EntityPlayerMP)entity);
        } else {
            entity.field_70159_w = dx;
            entity.field_70181_x = dy;
            entity.field_70179_y = dz;
        }
    }

    public static <T extends Entity> List<T> getEntitiesInRadius(Class<T> clazz, TileEntity tile, double radius) {
        return EntityUtil.getEntitiesInRadius(clazz, tile.func_145831_w(), 0.5 + (double)tile.func_174877_v().func_177958_n(), 0.5 + (double)tile.func_174877_v().func_177956_o(), 0.5 + (double)tile.func_174877_v().func_177952_p(), radius);
    }

    public static <T extends Entity> List<T> getEntitiesInRadius(Class<T> clazz, World world, double x, double y, double z, double radius) {
        AxisAlignedBB bounds = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entities = world.func_72872_a(clazz, bounds);
        ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
        double radiusSq = radius * radius;
        for (Entity entity : entities) {
            if (!(entity.func_70092_e(x, entity.field_70163_u, z) <= radiusSq)) continue;
            nearbyEntities.add(entity);
        }
        return nearbyEntities;
    }

    public static void setTarget(EntityLiving attacker, EntityLivingBase victim) {
        attacker.func_70624_b(victim);
        if (attacker instanceof EntityCreature) {
            EntityCreature attackerCreature = (EntityCreature)attacker;
            attackerCreature.func_70604_c(victim);
            if (attackerCreature instanceof EntityZombie || attackerCreature instanceof EntityCreeper) {
                boolean found = false;
                Class<?> victimClass = victim.getClass();
                for (EntityAITasks.EntityAITaskEntry task : attackerCreature.field_70715_bh.field_75782_a) {
                    if (!(task.field_75733_a instanceof EntityAIAttackOnCollide)) continue;
                    EntityAIAttackOnCollide ai = (EntityAIAttackOnCollide)task.field_75733_a;
                    if (!ai.appliesToClass(victimClass)) break;
                    found = true;
                    break;
                }
                if (!found) {
                    attacker.field_70714_bg.func_75776_a(2, new EntityAIAttackOnCollide(attackerCreature, victimClass, false));
                }
            }
        }
    }

    public static void dropAttackTarget(EntityLiving entity) {
        entity.func_70624_b(null);
        if (entity instanceof EntityCreature) {
            EntityCreature creatureEntity = (EntityCreature)entity;
            creatureEntity.func_70604_c(null);
        }
    }

    public static float getHealthAfterDamage(LivingHurtEvent event, float currentHealth, EntityLivingBase entity) {
        float j;
        if (event.getSource().func_76363_c()) {
            return currentHealth - event.getAmount();
        }
        float damage = event.getAmount();
        int i = 25 - entity.func_70658_aO();
        float f1 = damage * (float)i;
        damage = f1 / 25.0f;
        if (entity.func_70644_a(MobEffects.field_76429_m) && event.getSource() != DamageSource.field_76380_i) {
            i = (entity.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            j = 25 - i;
            f1 = damage * j;
            damage = f1 / 25.0f;
        }
        if (damage <= 0.0f) {
            damage = 0.0f;
        } else {
            i = EnchantmentHelper.func_77508_a(Collections.singleton(entity.func_184607_cu()), (DamageSource)event.getSource());
            if (i > 20) {
                i = 20;
            }
            if (i > 0) {
                j = 25 - i;
                f1 = damage * j;
                damage = f1 / 25.0f;
            }
        }
        return currentHealth - damage;
    }

    public static void sunDeath(EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            if (player.func_70608_bn()) {
                player.func_70999_a(true, true, false);
            }
            player.func_70097_a((DamageSource)DamageSourceSunlight.SUN, Float.MAX_VALUE);
            player.func_70606_j(0.0f);
        }
    }

    public static void instantDeath(EntityLivingBase entity, EntityLivingBase attacker, Entity directDamage) {
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            DamageSource magic = attacker == null ? DamageSource.field_76376_m : (directDamage == null ? DamageSource.func_76354_b((Entity)attacker, null) : DamageSource.func_76354_b((Entity)directDamage, (Entity)attacker));
            if (entity instanceof EntityLiving) {
                entity.func_70097_a(magic, Float.MAX_VALUE);
                entity.func_70606_j(0.0f);
            } else if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!player.field_71075_bZ.field_75098_d) {
                    if (player.func_70608_bn()) {
                        player.func_70999_a(true, true, false);
                    }
                    entity.func_70097_a(magic, Float.MAX_VALUE);
                    entity.func_70606_j(0.0f);
                }
            }
        }
    }

    public static boolean touchOfDeath(Entity victim, EntityLivingBase attacker, float damage) {
        if (victim != null && victim.func_190530_aW()) {
            return false;
        }
        if (victim != null && victim.field_70170_p != null && !victim.field_70170_p.field_72995_K) {
            DamageSource magic;
            DamageSource damageSource = magic = attacker == null ? DamageSource.field_76376_m : DamageSource.func_76354_b((Entity)attacker, null);
            if (victim instanceof EntityLiving) {
                EntityLiving creature2 = (EntityLiving)victim;
                float cap = 10000.0f;
                if (victim instanceof IHandleDeathTouch) {
                    cap = ((IHandleDeathTouch)victim).getCapDT(magic);
                    if (cap <= 0.0f) {
                        return false;
                    }
                    if (attacker instanceof EntityLiving) {
                        cap = Math.min(6.0f, cap);
                    }
                }
                float newHealth = creature2.func_110143_aJ() - Math.min(damage, cap);
                creature2.func_70606_j(Math.max(newHealth, 0.0f));
                creature2.func_70097_a(magic, newHealth <= 0.0f ? Float.MAX_VALUE : 0.0f);
            } else if (victim instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)victim;
                if (player.field_71075_bZ.field_75098_d) {
                    return false;
                }
                float newHealth = player.func_110143_aJ() - damage;
                player.func_70097_a(magic, newHealth <= 0.0f ? Float.MAX_VALUE : 0.0f);
                player.func_70606_j(Math.max(newHealth, 0.0f));
            }
        }
        return true;
    }

    public static void moveToBlockPositionAndUpdate(EntityLiving entity, BlockPos pos, int maxDY) {
        World world = entity.field_70170_p;
        boolean done = false;
        int mod = 0;
        int sign = -1;
        while (!done && mod <= 2 * maxDY && pos.func_177956_o() < 250 && pos.func_177956_o() > 2) {
            if (BlockUtil.isNormalCube(world.func_180495_p(pos)) && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2))) {
                done = true;
                continue;
            }
            pos = pos.func_177981_b(++mod * (sign *= -1));
        }
        if (done) {
            entity.func_70634_a(0.5 + (double)pos.func_177958_n(), 1.05 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p());
        }
    }

    public static class DamageSourceVampireFire
    extends DamageSource {
        public static final DamageSourceVampireFire SOURCE = new DamageSourceVampireFire();

        public DamageSourceVampireFire() {
            super("onFire");
            this.func_76348_h();
            this.func_82726_p();
        }
    }

    public static class DamageSourceSunlight
    extends DamageSource {
        public static final DamageSourceSunlight SUN = new DamageSourceSunlight();

        public DamageSourceSunlight() {
            super("sun");
            this.func_76348_h();
            this.func_82726_p();
        }
    }
}

