/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import java.util.Random;

public class NoiseUtil {
    private static final Random random = new Random();

    public static float getNoise(long seed, int x, int y) {
        random.setSeed(NoiseUtil.hash(new int[]{(int)seed, (int)(seed << 32), (int)Math.signum(y) * 512 + 512, (int)Math.signum(x) * 512 + 512, x, y}));
        return random.nextFloat();
    }

    private static int hash(int[] is) {
        int hash = 80238287;
        for (int i : is) {
            hash = hash << 4 ^ hash >> 28 ^ i * 5449 % 130651;
        }
        return hash % 75327403;
    }

    public static float fastSin(float x) {
        if ((double)x < -3.14159265) {
            x = (float)((double)x + 6.28318531);
        } else if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        if (x < 0.0f) {
            return (float)(1.27323954 * (double)x + 0.405284735 * (double)x * (double)x);
        }
        return (float)(1.27323954 * (double)x - 0.405284735 * (double)x * (double)x);
    }

    public static float fastCos(float x) {
        if ((double)x < -3.14159265) {
            x = (float)((double)x + 6.28318531);
        } else if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        x = (float)((double)x + 1.57079632);
        if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        if (x < 0.0f) {
            return (float)(1.27323954 * (double)x + 0.405284735 * (double)x * (double)x);
        }
        return (float)(1.27323954 * (double)x - 0.405284735 * (double)x * (double)x);
    }

    public static float interpolate(float s, float e, float t) {
        float t2 = (1.0f - NoiseUtil.fastCos(t * (float)Math.PI)) / 2.0f;
        return s * (1.0f - t2) + e * t2;
    }

    public static float bilinear(float ul, float ur, float dr, float dl, float t1, float t2) {
        return NoiseUtil.interpolate(NoiseUtil.interpolate(ul, ur, t1), NoiseUtil.interpolate(dl, dr, t1), t2);
    }

    public static float getOctave(long seed, int x, int y, int dimen) {
        return NoiseUtil.bilinear(NoiseUtil.getNoise(seed, (int)Math.floor((float)x / (float)dimen) * dimen, (int)Math.floor((float)y / (float)dimen) * dimen), NoiseUtil.getNoise(seed, (int)Math.floor((float)x / (float)dimen) * dimen + dimen, (int)Math.floor((float)y / (float)dimen) * dimen), NoiseUtil.getNoise(seed, (int)Math.floor((float)x / (float)dimen) * dimen + dimen, (int)Math.floor((float)y / (float)dimen) * dimen + dimen), NoiseUtil.getNoise(seed, (int)Math.floor((float)x / (float)dimen) * dimen, (int)Math.floor((float)y / (float)dimen) * dimen + dimen), Math.abs((float)((double)x - Math.floor((float)x / (float)dimen) * (double)dimen) / (float)dimen), Math.abs((float)((double)y - Math.floor((float)y / (float)dimen) * (double)dimen) / (float)dimen));
    }

    public static float getDensity(long seed, int x, int z) {
        return (NoiseUtil.getStability(seed, x, z) + (float)Math.pow((80.0f * NoiseUtil.getOctave(seed, x, z, 112) + 20.0f * NoiseUtil.getOctave(seed, x, z, 68) + 6.0f * NoiseUtil.getOctave(seed, x, z, 34) + 4.0f * NoiseUtil.getOctave(seed, x, z, 21) + 2.0f * NoiseUtil.getOctave(seed, x, z, 11) + NoiseUtil.getOctave(seed, x, z, 4)) / 93.0f, 1.6f)) * 0.5f;
    }

    public static float getStability(long seed, int x, int z) {
        return 1.0f - (float)Math.pow((32.0f * NoiseUtil.getOctave(seed, x, z, 120) + 16.0f * NoiseUtil.getOctave(seed, x, z, 76) + 6.0f * NoiseUtil.getOctave(seed, x, z, 45) + 3.0f * NoiseUtil.getOctave(seed, x, z, 21) + NoiseUtil.getOctave(seed, x, z, 5)) / 58.0f, 3.0);
    }
}

