/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.CreatureUtil;

@Deprecated
public class TeleportationUtil {
    public static void teleportToLocation(double posX, double posY, double posZ, int dimension, Entity entity, boolean presetPosition) {
        TeleportationUtil.teleportToLocation(new BlockPos(posX, posY, posZ), dimension, entity, presetPosition);
    }

    public static void teleportToLocation(BlockPos pos, int dimension, Entity entity, boolean presetPosition) {
        TeleportationUtil.teleportToLocation(pos, dimension, entity, presetPosition, EnumParticleTypes.PORTAL, SoundEvents.field_187534_aX);
    }

    public static void teleportToLocation(double posX, double posY, double posZ, int dimension, Entity entity, boolean presetPosition, EnumParticleTypes particle, SoundEvent sound) {
        TeleportationUtil.teleportToLocation(new BlockPos(posX, posY, posZ), dimension, entity, presetPosition, particle, sound);
    }

    public static void teleportToLocation(BlockPos pos, int dimension, Entity entity, boolean presetPosition, EnumParticleTypes particle, SoundEvent sound) {
        boolean isVampire = CreatureUtil.isVampire(entity);
        if (isVampire) {
            entity.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), entity);
        } else {
            if (sound != null) {
                entity.func_184185_a(sound, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, particle), entity);
        }
        double posX = (double)pos.func_177958_n() + 0.5;
        double posY = pos.func_177956_o();
        double posZ = (double)pos.func_177952_p() + 0.5;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (entity.field_71093_bK != dimension) {
                if (presetPosition) {
                    player.func_70107_b(posX, posY, posZ);
                }
                TeleportationUtil.travelToDimension(player, dimension);
            }
            player.func_70634_a(posX, posY, posZ);
        } else if (entity instanceof EntityLiving) {
            if (entity.field_71093_bK != dimension) {
                TeleportationUtil.travelToDimension(entity, dimension, pos);
            } else {
                entity.func_70012_b(posX, posY, posZ, entity.field_70177_z, entity.field_70125_A);
            }
        } else if (entity.field_71093_bK != dimension) {
            TeleportationUtil.travelToDimension(entity, dimension, pos);
        } else {
            entity.func_70012_b(posX, posY, posZ, entity.field_70177_z, entity.field_70125_A);
        }
        if (isVampire) {
            entity.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), entity);
        } else {
            if (sound != null) {
                entity.func_184185_a(sound, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity, 0.5f, 2.0f, particle), entity);
        }
    }

    public static Entity travelToDimension(EntityPlayer player, int dimension) {
        return player.changeDimension(dimension, (ITeleporter)new WitcheryTeleporter());
    }

    private static void travelToDimension(Entity entity, int dimension, BlockPos pos) {
        entity.changeDimension(dimension, (ITeleporter)new WitcheryTeleporter(pos));
    }

    public static boolean isBrew(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemKettleBrew && ((ItemKettleBrew)stack.func_77973_b()).isPotion();
    }

    public static void bindToLocation(BlockPos pos, int dimension, ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("X", pos.func_177958_n());
        itemstack.func_77978_p().func_74768_a("Y", pos.func_177956_o());
        itemstack.func_77978_p().func_74768_a("Z", pos.func_177952_p());
        itemstack.func_77978_p().func_74768_a("Dimension", dimension);
    }

    public static boolean hasLocationBinding(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            NBTTagCompound nbtTag = itemstack.func_77978_p();
            return nbtTag.func_74764_b("X") && nbtTag.func_74764_b("Y") && nbtTag.func_74764_b("Z") && nbtTag.func_74764_b("Dimension");
        }
        return false;
    }

    public static void copyLocationBinding(ItemStack from, ItemStack to) {
        if (TeleportationUtil.hasLocationBinding(from)) {
            NBTTagCompound nbtTagFrom = from.func_77978_p();
            if (!to.func_77942_o()) {
                to.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbtTagTo = to.func_77978_p();
            nbtTagTo.func_74768_a("X", nbtTagFrom.func_74762_e("X"));
            nbtTagTo.func_74768_a("Y", nbtTagFrom.func_74762_e("Y"));
            nbtTagTo.func_74768_a("Z", nbtTagFrom.func_74762_e("Z"));
            nbtTagTo.func_74768_a("Dimension", nbtTagFrom.func_74762_e("Dimension"));
            if (from.func_82837_s()) {
                to.func_151001_c(from.func_82833_r());
            }
        }
    }

    private static boolean isRestrictedTeleportTarget(int source, int target) {
        int dream = WitcheryDimensions.SPIRIT_WORLD.getType().func_186068_a();
        int mirror = WitcheryDimensions.MIRROR.getType().func_186068_a();
        return source == target || source != dream && source != mirror && target != dream && target != mirror;
    }

    public static boolean teleportToLocation(World world, ItemStack itemstack, Entity entity, int radius, boolean presetPosition) {
        NBTTagCompound tag = itemstack.func_77978_p();
        if (tag != null && tag.func_74764_b("X") && tag.func_74764_b("Y") && tag.func_74764_b("Z") && tag.func_74764_b("Dimension")) {
            int newX = tag.func_74762_e("X") - radius + world.field_73012_v.nextInt(radius * 2 + 1);
            int newY = tag.func_74762_e("Y");
            int newZ = tag.func_74762_e("Z") - radius + world.field_73012_v.nextInt(radius * 2 + 1);
            int newD = tag.func_74762_e("Dimension");
            if (TeleportationUtil.isRestrictedTeleportTarget(entity.field_71093_bK, newD)) {
                TeleportationUtil.teleportToLocation(newX, (double)newY, newZ, newD, entity, presetPosition);
                return true;
            }
        } else if (tag != null) {
            EntityLivingBase target = ItemTaglockKit.getBoundEntity(world, itemstack, 0);
            if (entity != null && target != null && TeleportationUtil.isRestrictedTeleportTarget(entity.field_71093_bK, target.field_71093_bK)) {
                TeleportationUtil.teleportToLocation(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_71093_bK, entity, presetPosition);
                return true;
            }
        }
        return false;
    }

    private static class WitcheryTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        public WitcheryTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public WitcheryTeleporter() {
            this.targetPos = null;
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            if (this.targetPos != null) {
                entity.func_174828_a(this.targetPos, yaw, entity.field_70125_A);
            }
        }
    }
}

