/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;

public class Waypoint {
    public final boolean valid;
    public final double x;
    public final double y;
    public final double z;
    public final double d;

    public Waypoint(World world, ItemStack stack, double homeX, double homeY, double homeZ) {
        if (stack.func_77973_b() == WitcheryIngredientItems.BOUND_WAYSTONE) {
            int z;
            NBTTagCompound nbtWaystone = stack.func_77978_p();
            int x = nbtWaystone.func_74762_e("X");
            if (world.func_175726_f(new BlockPos(x, 0, z = nbtWaystone.func_74762_e("Z"))).func_177410_o()) {
                this.x = (double)x + 0.5;
                this.y = (double)nbtWaystone.func_74762_e("Y") + 1.5;
                this.z = (double)z + 0.5;
                this.d = nbtWaystone.func_74762_e("Dimension");
                this.valid = true;
            } else {
                this.x = homeX;
                this.y = homeY;
                this.z = homeZ;
                this.d = world.field_73011_w.getDimension();
                this.valid = false;
            }
        } else if (stack.func_77973_b() == WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE) {
            EntityLivingBase entity = ItemTaglockKit.getBoundEntity(world, stack, 0);
            if (entity != null) {
                this.x = entity.field_70165_t;
                this.y = entity.field_70163_u + 1.0;
                this.z = entity.field_70161_v;
                this.d = entity.field_71093_bK;
                this.valid = true;
            } else {
                this.x = homeX;
                this.y = homeY;
                this.z = homeZ;
                this.d = world.field_73011_w.getDimension();
                this.valid = false;
            }
        } else if (stack.func_77973_b() == WitcheryGeneralItems.BOUND_TAGLOCK_KIT) {
            EntityLivingBase entity = ItemTaglockKit.getBoundEntity(world, stack, 0);
            if (entity != null) {
                this.x = entity.field_70165_t;
                this.y = entity.field_70163_u + 1.0;
                this.z = entity.field_70161_v;
                this.d = entity.field_71093_bK;
                this.valid = true;
            } else {
                this.x = homeX;
                this.y = homeY;
                this.z = homeZ;
                this.d = world.field_73011_w.getDimension();
                this.valid = false;
            }
        } else {
            this.x = homeX;
            this.y = homeY;
            this.z = homeZ;
            this.d = world.field_73011_w.getDimension();
            this.valid = false;
        }
    }
}

