/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world;

import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.world.gen.structure.ComponentVillageWall;
import net.msrandom.witchery.world.gen.structure.VillageTowerVillagePiece;
import net.msrandom.witchery.world.gen.structure.WitcheryVillagePiece;

public class WorldHandlerVillageDistrict
implements VillagerRegistry.IVillageCreationHandler {
    private final Class<? extends StructureVillagePieces.Village> pieceClazz;
    private final int weight;
    private final int quantityMin;
    private final int quantityMax;

    public WorldHandlerVillageDistrict(Class<? extends StructureVillagePieces.Village> clazz, int weight, int min, int max) {
        this.pieceClazz = clazz;
        this.weight = weight;
        this.quantityMin = min;
        this.quantityMax = max;
    }

    public static void registerComponent(Class<? extends StructureVillagePieces.Village> clazz, int weight, int min, int max) {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new WorldHandlerVillageDistrict(clazz, weight, min, max));
    }

    public static void init() {
        MapGenStructureIO.func_143031_a(ComponentVillageWall.class, (String)"witchery:villagewall");
        if (WitcheryConfigOptions.townWallChance > 0) {
            WorldHandlerVillageDistrict.registerComponent(ComponentVillageWall.class, WitcheryConfigOptions.townWallWeight, WitcheryConfigOptions.townWallChance == 2 ? 1 : 0, 1);
        }
        VillagerRegistry register2 = VillagerRegistry.instance();
        for (WitcheryConfigOptions.Building building : WitcheryConfigOptions.townParts) {
            for (int i = 0; i < building.getGroups(); ++i) {
                register2.registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new WorldHandlerVillageDistrict(building.clazz, building.getWeight(), building.getMin(), building.getMax()));
            }
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            boolean disallowed;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || (disallowed = !WitcheryConfigOptions.townAllowSandy && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || !WitcheryConfigOptions.townAllowPlains && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || !WitcheryConfigOptions.townAllowMountain && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || !WitcheryConfigOptions.townAllowHills && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || !WitcheryConfigOptions.townAllowForest && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || !WitcheryConfigOptions.townAllowSnowy && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || !WitcheryConfigOptions.townAllowJungle && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || !WitcheryConfigOptions.townAllowMesa && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA))) continue;
            BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
        }
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random rand, int size) {
        return new StructureVillagePieces.PieceWeight(this.pieceClazz, this.weight, this.quantityMax <= this.quantityMin ? this.quantityMin : this.quantityMin + rand.nextInt(this.quantityMax - this.quantityMin + 1));
    }

    public Class<? extends StructureComponent> getComponentClass() {
        return this.pieceClazz;
    }

    public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight weight, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random rand, int x, int y, int z, EnumFacing facing, int type2) {
        StructureBoundingBox box;
        Object object = null;
        if (this.pieceClazz == StructureVillagePieces.House4Garden.class) {
            object = StructureVillagePieces.House4Garden.func_175858_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.Church.class) {
            object = StructureVillagePieces.Church.func_175854_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.House1.class) {
            object = StructureVillagePieces.House1.func_175850_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.WoodHut.class) {
            object = StructureVillagePieces.WoodHut.func_175853_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.Hall.class) {
            object = StructureVillagePieces.Hall.func_175857_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.Field1.class) {
            object = StructureVillagePieces.Field1.func_175851_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.Field2.class) {
            object = StructureVillagePieces.Field2.func_175852_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.House2.class) {
            object = StructureVillagePieces.House2.func_175855_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == StructureVillagePieces.House3.class) {
            object = StructureVillagePieces.House3.func_175849_a((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing, (int)type2);
        } else if (this.pieceClazz == ComponentVillageWall.class) {
            object = ComponentVillageWall.createPiece(startPiece, pieces, x, y, z, facing, type2);
        } else if (this.pieceClazz == VillageTowerVillagePiece.class && WitcheryVillagePiece.canPlace(box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)16, (int)(256 - y), (int)16, (EnumFacing)facing), pieces)) {
            object = new VillageTowerVillagePiece(startPiece, box, facing, type2);
        }
        return object;
    }
}

