/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.dimension.spirit;

import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.BlockDreamWeaver;
import net.msrandom.witchery.block.BlockFetish;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityNightmare;
import net.msrandom.witchery.entity.EntitySleepingBody;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.network.PacketPlayerStyle;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;

public class WorldProviderSpiritWorld
extends WorldProvider {
    public WorldProviderSpiritWorld() {
        if (WitcheryResurrected.isClient()) {
            this.setCloudRenderer(new IRenderHandler(){

                public void render(float partialTicks, WorldClient world, Minecraft mc) {
                }
            });
        }
    }

    private static void addItemToInventory(EntityPlayer player, ItemStack protoStack, int totalQuantity) {
        if (totalQuantity > 0) {
            int quantity;
            int maxStack = protoStack.func_77976_d();
            for (int itemsRemaining = totalQuantity; itemsRemaining > 0; itemsRemaining -= quantity) {
                quantity = Math.min(itemsRemaining, maxStack);
                ItemStack newStack = new ItemStack(protoStack.func_77973_b(), quantity, protoStack.func_77952_i());
                player.field_71071_by.func_70441_a(newStack);
            }
        }
    }

    private static void addItemToInventory(EntityPlayer player, ArrayList<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (player.field_71071_by.func_70441_a(stack)) continue;
            player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, 0.5 + player.field_70163_u, player.field_70161_v, stack));
        }
    }

    public static void sendPlayerToSpiritWorld(EntityPlayer player, double nightmareChance) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            boolean demonic;
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            spiritData2.setBodyPosition(player.func_180425_c());
            int fireFound = 0;
            int heartsFound = 0;
            int spiritPoolFound = 0;
            int cottonFound = 0;
            boolean nightmareCatcherFound = false;
            double modifiedNightmareChance = nightmareChance;
            if (nightmareChance > 0.0 && nightmareChance < 1.0) {
                int R = 8;
                int posX = MathHelper.func_76128_c((double)player.field_70165_t);
                int posY = MathHelper.func_76128_c((double)player.field_70163_u);
                int posZ = MathHelper.func_76128_c((double)player.field_70161_v);
                for (int x = posX - R; x <= posX + R; ++x) {
                    for (int z = posZ - R; z <= posZ + R; ++z) {
                        for (int y = posY - R; y <= posY + R; ++y) {
                            BlockPos pos = new BlockPos(x, y, z);
                            IBlockState state = player.field_70170_p.func_180495_p(pos);
                            Block block = state.func_177230_c();
                            if (!nightmareCatcherFound && block instanceof BlockDreamWeaver && ((BlockDreamWeaver)block).getModifier() == BlockDreamWeaver.Modifier.CAUSES_NIGHTMARES) {
                                modifiedNightmareChance -= 0.5;
                                nightmareCatcherFound = true;
                            }
                            if (spiritPoolFound < 3 && block == WitcheryBlocks.FLOWING_SPIRIT && (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0) {
                                ++spiritPoolFound;
                                modifiedNightmareChance -= 0.1;
                            }
                            if (cottonFound < 2 && block == WitcheryBlocks.WISPY_COTTON) {
                                ++cottonFound;
                                modifiedNightmareChance -= 0.1;
                            }
                            if (heartsFound < 2 && block == WitcheryBlocks.DEMON_HEART) {
                                ++heartsFound;
                                modifiedNightmareChance += 0.35;
                            }
                            if (fireFound >= 3 || block != Blocks.field_150480_ab) continue;
                            ++fireFound;
                            modifiedNightmareChance += 0.1;
                        }
                    }
                }
                modifiedNightmareChance = nightmareCatcherFound ? Math.min(Math.max(modifiedNightmareChance, 0.0), 1.0) : nightmareChance;
            }
            boolean nightmare = modifiedNightmareChance != 0.0 && (modifiedNightmareChance == 1.0 || player.field_70170_p.field_73012_v.nextDouble() < modifiedNightmareChance);
            boolean bl = demonic = nightmare && nightmareCatcherFound && spiritPoolFound > 0 && heartsFound > 0 && player.field_70170_p.field_73012_v.nextDouble() < (double)heartsFound * 0.35 + (double)fireFound * 0.1;
            SpiritWorldData.NightmareLevel level = nightmare ? (demonic ? SpiritWorldData.NightmareLevel.DEMONIC : SpiritWorldData.NightmareLevel.NIGHTMARE) : SpiritWorldData.NightmareLevel.DREAM;
            spiritData2.setNightmareLevel(level);
            spiritData2.setSpiritWalking(true);
            EntitySleepingBody corpse = new EntitySleepingBody(player.field_70170_p);
            corpse.func_70606_j(player.func_110143_aJ());
            corpse.func_96094_a(player.func_70005_c_());
            corpse.setOwner(player);
            corpse.func_70012_b(0.5 + (double)MathHelper.func_76128_c((double)player.field_70165_t), player.field_70163_u, 0.5 + (double)MathHelper.func_76128_c((double)player.field_70161_v), player.field_70125_A, 0.0f);
            player.field_70170_p.func_72838_d((Entity)corpse);
            spiritData2.setOriginalDimension(player.field_70170_p.field_73011_w.func_186058_p());
            int boneNeedles = player.field_71071_by.func_174925_a(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            int mutandis = player.field_71071_by.func_174925_a(WitcheryIngredientItems.MUTANDIS, 0, -1, null);
            IntegrationManager.dropPlayerBackpack(player);
            NBTTagList originalInventory = new NBTTagList();
            player.field_71071_by.func_70442_a(originalInventory);
            spiritData2.getOriginalData().setInventory(originalInventory);
            boolean hasSpiritData2 = spiritData2.getHasSpiritData();
            if (hasSpiritData2) {
                player.field_71071_by.func_70443_b(spiritData2.getSpiritData().getInventory());
            } else {
                player.field_71071_by.func_174925_a(null, -1, -1, null);
            }
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.MUTANDIS), mutandis);
            spiritData2.getOriginalData().setHealth(Math.max(player.func_110143_aJ(), 1.0f));
            if (hasSpiritData2) {
                player.func_70606_j(Math.max(spiritData2.getSpiritData().getHealth(), 10.0f));
            } else {
                player.func_70606_j(player.func_110138_aP());
            }
            NBTTagCompound originalHunger = new NBTTagCompound();
            player.func_71024_bL().func_75117_b(originalHunger);
            spiritData2.getOriginalData().setHunger(originalHunger);
            if (hasSpiritData2) {
                player.func_71024_bL().func_75112_a(spiritData2.getSpiritData().getHunger());
                player.func_71024_bL().func_75122_a(16, 0.8f);
            } else {
                player.func_71024_bL().func_75122_a(20 - player.func_71024_bL().func_75116_a(), 5.0f - player.func_71024_bL().func_75115_e());
                player.func_71024_bL().field_75124_e = 20;
            }
            WorldProviderSpiritWorld.changeDimension(player, WitcheryDimensions.SPIRIT_WORLD.getType());
            WorldProviderSpiritWorld.findTopAndSetPosition(player.field_70170_p, player);
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(0.0, 0.1, 0.0), (EntityPlayerMP)player);
        }
    }

    public static void changeDimension(EntityPlayer player, DimensionType dimension) {
        WorldProviderSpiritWorld.dismount(player);
        TeleportationUtil.travelToDimension(player, dimension.func_186068_a());
    }

    private static void dismount(EntityPlayer player) {
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
    }

    public static void findTopAndSetPosition(World world, EntityPlayer player) {
        WorldProviderSpiritWorld.findTopAndSetPosition(world, player, player.func_180425_c());
    }

    private static void findTopAndSetPosition(World world, EntityPlayer player, BlockPos pos) {
        if (!WorldProviderSpiritWorld.isValidSpawnPoint(world, pos)) {
            for (int i = 1; i <= 256; ++i) {
                if (pos.func_177956_o() + i < 256 && WorldProviderSpiritWorld.isValidSpawnPoint(world, pos.func_177981_b(i))) {
                    pos = pos.func_177981_b(i);
                    break;
                }
                if (pos.func_177956_o() - i > 2 && WorldProviderSpiritWorld.isValidSpawnPoint(world, pos.func_177979_c(i))) {
                    pos = pos.func_177979_c(i);
                    break;
                }
                if (pos.func_177956_o() - i <= 2 && pos.func_177956_o() + i >= 255) break;
            }
        }
        player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
    }

    private static boolean isValidSpawnPoint(World world, BlockPos pos) {
        Material materialBelow = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        return !world.func_175623_d(pos.func_177977_b()) && materialBelow != Material.field_151587_i && world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a());
    }

    public static void returnPlayerToOverworld(EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            boolean isSpiritWorld = WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player);
            int cottonRemoved = isSpiritWorld ? player.field_71071_by.func_174925_a(Item.func_150898_a((Block)WitcheryBlocks.WISPY_COTTON), 0, -1, null) : 0;
            int disturbed_cottonRemoved = isSpiritWorld ? player.field_71071_by.func_174925_a(WitcheryIngredientItems.DISTURBED_COTTON, 0, -1, null) : 0;
            int hunger = isSpiritWorld ? player.field_71071_by.func_174925_a(WitcheryFumeItems.MELLIFLUOUS_HUNGER, 0, -1, null) : 0;
            int spirit2 = isSpiritWorld ? player.field_71071_by.func_174925_a((Item)WitcheryBrewItems.FLOWING_SPIRIT_BREW, 0, -1, null) : 0;
            int subduedSpirits = player.field_71071_by.func_174925_a(WitcheryIngredientItems.SUBDUED_SPIRIT, 0, -1, null);
            int boneNeedles = player.field_71071_by.func_174925_a(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            IntegrationManager.dropPlayerBackpack(player);
            if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player)) {
                NBTTagList spiritInventory = new NBTTagList();
                player.field_71071_by.func_70442_a(spiritInventory);
                spiritData2.getSpiritData().setInventory(spiritInventory);
            }
            player.field_71071_by.func_70443_b(spiritData2.getOriginalData().getInventory());
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack((Block)WitcheryBlocks.WISPY_COTTON), cottonRemoved);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.DISTURBED_COTTON), disturbed_cottonRemoved);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryFumeItems.MELLIFLUOUS_HUNGER), hunger);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack((Item)WitcheryBrewItems.FLOWING_SPIRIT_BREW), spirit2);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.SUBDUED_SPIRIT), subduedSpirits);
            spiritData2.getSpiritData().setHealth(Math.max(player.func_110143_aJ(), 10.0f));
            player.func_70606_j(spiritData2.getOriginalData().getHealth());
            NBTTagCompound spiritHunger = new NBTTagCompound();
            player.func_71024_bL().func_75117_b(spiritHunger);
            spiritData2.getSpiritData().setHunger(spiritHunger);
            player.func_71024_bL().func_75112_a(spiritData2.getOriginalData().getHunger());
            spiritData2.setNightmareLevel(SpiritWorldData.NightmareLevel.DREAM);
            spiritData2.setGhost(false);
            spiritData2.setSpiritWalking(false);
            player.func_70066_B();
            BlockPos posBody = spiritData2.getBodyPosition();
            if (player.field_71093_bK != spiritData2.getOriginalDimension().func_186068_a()) {
                WorldProviderSpiritWorld.dismount(player);
                if (posBody != null) {
                    player.func_70634_a((double)posBody.func_177958_n(), (double)posBody.func_177956_o(), (double)posBody.func_177952_p());
                }
                player = (EntityPlayer)TeleportationUtil.travelToDimension(player, spiritData2.getOriginalDimension().func_186068_a());
            }
            if (posBody != null) {
                WorldProviderSpiritWorld.findTopAndSetPosition(player.field_70170_p, player, posBody);
                spiritData2.setBodyPosition(null);
            } else {
                WorldProviderSpiritWorld.findTopAndSetPosition(player.field_70170_p, player);
            }
            for (Entity entity : player.field_70170_p.field_72996_f) {
                if (!(entity instanceof EntitySleepingBody)) continue;
                EntitySleepingBody corpse = (EntitySleepingBody)entity;
                if (!player.func_110124_au().equals(corpse.getOwnerId())) continue;
                player.field_70170_p.func_72900_e((Entity)corpse);
            }
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(0.0, 0.1, 0.0), (EntityPlayerMP)player);
        }
    }

    public static void manifestPlayerInOverworldAsGhost(EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            int boneNeedles = player.field_71071_by.func_174925_a(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            IntegrationManager.dropPlayerBackpack(player);
            NBTTagList spiritInventory = new NBTTagList();
            player.field_71071_by.func_70442_a(spiritInventory);
            spiritData2.getSpiritData().setInventory(spiritInventory);
            player.field_71071_by.func_174925_a(null, -1, -1, null);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            spiritData2.getSpiritData().setHealth(Math.max(player.func_110143_aJ(), 1.0f));
            spiritData2.setGhost(true);
            WorldProviderSpiritWorld.dismount(player);
            TeleportationUtil.travelToDimension(player, spiritData2.getOriginalDimension().func_186068_a());
            WorldProviderSpiritWorld.findTopAndSetPosition(player.field_70170_p, player);
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
        }
    }

    public static void returnGhostPlayerToSpiritWorld(EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            int boneNeedles = player.field_71071_by.func_174925_a(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            ArrayList<ItemStack> fetishes = WorldProviderSpiritWorld.getBoundFetishes(player.field_71071_by);
            player.field_71071_by.func_70436_m();
            IntegrationManager.dropPlayerBackpack(player);
            player.field_71071_by.func_70443_b(spiritData2.getSpiritData().getInventory());
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            WorldProviderSpiritWorld.addItemToInventory(player, fetishes);
            spiritData2.setGhost(false);
            WorldProviderSpiritWorld.changeDimension(player, WitcheryDimensions.SPIRIT_WORLD.getType());
            WorldProviderSpiritWorld.findTopAndSetPosition(player.field_70170_p, player);
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
        }
    }

    private static ArrayList<ItemStack> getBoundFetishes(InventoryPlayer inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockFetish) || !stack.func_77942_o() || !WitcheryUtils.getOrCreateTag(stack).func_74764_b("SpiritEffect")) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static void updatePlayerEffects(World world, EntityPlayer player, long counter) {
        if (!world.field_72995_K) {
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            if (counter % 20L == 0L && spiritData2.getMustWakeUp()) {
                spiritData2.setMustWakeUp(false);
                if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && spiritData2.isSpiritWalking() && !spiritData2.isGhost()) {
                    WorldProviderSpiritWorld.returnPlayerToOverworld(player);
                } else if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player)) {
                    WorldProviderSpiritWorld.returnPlayerToOverworld(player);
                }
            }
            if (counter % 100L == 0L) {
                SpiritWorldData.NightmareLevel nightmareLevel = spiritData2.getNightmareLevel();
                if (!player.field_71075_bZ.field_75098_d && world.func_175659_aa() != EnumDifficulty.PEACEFUL && WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && nightmareLevel != SpiritWorldData.NightmareLevel.DREAM) {
                    double R = 18.0;
                    double H = 18.0;
                    AxisAlignedBB bounds = new AxisAlignedBB(player.field_70165_t - R, player.field_70163_u - H, player.field_70161_v - R, player.field_70165_t + R, player.field_70163_u + H, player.field_70161_v + R);
                    if (nightmareLevel == SpiritWorldData.NightmareLevel.DEMONIC) {
                        List entities;
                        double chance = world.field_73012_v.nextDouble();
                        if (chance < 0.5) {
                            EntitySmallFireball fireball = new EntitySmallFireball(world, player.field_70165_t - 2.0 + (double)world.field_73012_v.nextInt(5), player.field_70163_u + 15.0, player.field_70161_v - 2.0 + (double)world.field_73012_v.nextInt(5), 0.0, -0.2, 0.0);
                            world.func_72838_d((Entity)fireball);
                        } else if (chance < 0.65) {
                            EntityLargeFireball fireball2 = new EntityLargeFireball(world);
                            double par2 = player.field_70165_t - 2.0 + (double)world.field_73012_v.nextInt(5);
                            double par3 = player.field_70163_u + 15.0;
                            double par4 = player.field_70161_v - 2.0 + (double)world.field_73012_v.nextInt(5);
                            double par5 = 0.0;
                            double par6 = -0.2;
                            double par7 = 0.0;
                            fireball2.func_70012_b(par2, par3, par4, fireball2.field_70177_z, fireball2.field_70125_A);
                            fireball2.func_70107_b(par2, par3, par4);
                            double d6 = MathHelper.func_76133_a((double)(par5 * par5 + par6 * par6 + par7 * par7));
                            fireball2.field_70232_b = par5 / d6 * 0.1;
                            fireball2.field_70233_c = par6 / d6 * 0.1;
                            fireball2.field_70230_d = par7 / d6 * 0.1;
                            world.func_72838_d((Entity)fireball2);
                        } else if (chance < 0.75 && (entities = world.func_72872_a(EntityMob.class, bounds)).size() < 10 && !WorldProviderSpiritWorld.containsDemons(entities)) {
                            WitcheryUtils.summonEntity(world, WitcheryEntities.DEMON, player.func_180425_c(), 4, 8, entity -> {
                                entity.func_70624_b((EntityLivingBase)player);
                                WitcheryUtils.addNewParticles(world, EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 20);
                                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187849_gA, entity.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                return Unit.INSTANCE;
                            });
                        }
                    }
                    List entities2 = world.func_72872_a(EntityNightmare.class, bounds);
                    for (EntityNightmare nightmare : entities2) {
                        if (!player.func_110124_au().equals(nightmare.getVictimId())) continue;
                        return;
                    }
                    long currentTime = world.func_82737_E();
                    long lastKillTime = spiritData2.getLastNightmareKill();
                    if (lastKillTime < currentTime - 600L) {
                        WitcheryUtils.summonEntity(world, WitcheryEntities.NIGHTMARE, player.func_180425_c(), 2, 6, entity -> {
                            entity.setVictimId(entity.func_110124_au());
                            entity.func_70624_b((EntityLivingBase)player);
                            return Unit.INSTANCE;
                        });
                    }
                } else if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && spiritData2.isGhost()) {
                    boolean skipNext = spiritData2.getSkipManifestation();
                    int timeRemaining = spiritData2.getManifestationDuration();
                    if (timeRemaining > 0 && ((timeRemaining = Math.max(0, timeRemaining - 5)) >= 60 && timeRemaining <= 64 || timeRemaining >= 30 && timeRemaining <= 34 || timeRemaining >= 15 && timeRemaining <= 19) && !skipNext) {
                        player.func_145747_a(new TextComponentTranslation("rite.witchery.manifestation.countdown", new Object[]{timeRemaining}).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)));
                    }
                    if (timeRemaining == 0) {
                        WorldProviderSpiritWorld.returnGhostPlayerToSpiritWorld(player);
                    } else if (!skipNext) {
                        spiritData2.setManifestationDuration(timeRemaining);
                    } else {
                        spiritData2.setSkipManifestation(false);
                    }
                }
            }
        }
    }

    private static boolean containsDemons(List<EntityMob> entities) {
        int count = 0;
        for (EntityCreature entityCreature : entities) {
            if (!(entityCreature instanceof EntityDemon) || ++count < 2) continue;
            return true;
        }
        return false;
    }

    public DimensionType func_186058_p() {
        return WitcheryDimensions.SPIRIT_WORLD.getType();
    }

    public float getStarBrightness(float par1) {
        return 0.0f;
    }

    public boolean func_76567_e() {
        return false;
    }

    public double getMovementFactor() {
        return 1.0;
    }

    public float func_76563_a(long par1, float par3) {
        return WitcheryUtils.getNightmareLevel(this.field_76579_a) == SpiritWorldData.NightmareLevel.DREAM ? 1.0f : 0.5f;
    }

    public float func_76571_f() {
        return 0.0f;
    }

    public boolean func_76566_a(int par1, int par2) {
        int var3 = this.field_76579_a.func_175672_r(new BlockPos(par1, 0, par2)).func_177956_o();
        return var3 != -1;
    }

    public BlockPos func_177496_h() {
        return new BlockPos(100, 50, 0);
    }

    public int func_76557_i() {
        return 64;
    }

    public double getHorizon() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    public double func_76565_k() {
        return 1.0;
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float angle = MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (angle < 0.0f) {
            angle = 0.0f;
        }
        if (angle > 1.0f) {
            angle = 1.0f;
        }
        switch (WitcheryUtils.getNightmareLevel(this.field_76579_a)) {
            case DREAM: {
                float red = 0.8f;
                float green = 0.2f;
                float blue = 0.6f;
                break;
            }
            case NIGHTMARE: {
                float red = 0.0f;
                float green = 1.0f;
                float blue = 0.0f;
                break;
            }
            default: {
                float red = 1.0f;
                float green = 0.0f;
                float blue = 0.0f;
            }
        }
        return new Vec3d((double)(red *= angle * 0.94f + 0.06f), (double)(green *= angle * 0.94f + 0.06f), (double)(blue *= angle * 0.91f + 0.09f));
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
    }
}

