/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.dimension.torment;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.msrandom.witchery.entity.EntityLordOfTorment;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import net.msrandom.witchery.world.gen.ChunkGeneratorTorment;

public class WorldProviderTorment
extends WorldProvider {
    public static void setPlayerMustTorment(EntityPlayer player, TormentWorldData.TormentType tormentType, int presetLevel) {
        TormentWorldData tormentData = WitcheryUtils.getExtension(player).getTormentData();
        tormentData.setTormentType(tormentType);
        tormentData.setTormentLevel(presetLevel);
    }

    public static int getRandomTormentLevel(World world) {
        return world.field_73012_v.nextInt(6);
    }

    public static void updatePlayerEffects(World world, EntityPlayer player, long counter) {
        if (!world.field_72995_K && counter % 20L == 0L) {
            TormentWorldData tormentData = WitcheryUtils.getExtension(player).getTormentData();
            TormentWorldData.TormentType mustTorment = tormentData.getTormentType();
            if (mustTorment.isBeginning()) {
                int level = mustTorment == TormentWorldData.TormentType.BOSS ? tormentData.getTormentLevel() - 2 : WorldProviderTorment.getRandomTormentLevel(world);
                tormentData.setTormentType(TormentWorldData.TormentType.NONE);
                tormentData.setTormentLevel(1);
                if (player.func_184218_aH()) {
                    player.func_184210_p();
                }
                player.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
                int yPos = 12 + level * 15;
                player.func_70634_a(8.0, (double)yPos, 8.0);
                TeleportationUtil.travelToDimension(player, WitcheryDimensions.TORMENT.getType().func_186068_a());
                player.func_70634_a(8.0, (double)yPos, 8.0);
                player.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
                WorldServer tormentWorld = world.func_73046_m().func_71218_a(WitcheryDimensions.TORMENT.getType().func_186068_a());
                int midX = 8;
                int midZ = 8;
                for (int x = midX - 1; x <= midX + 1; ++x) {
                    for (int z = midZ - 1; z <= midZ + 1; ++z) {
                        BlockPos pos = new BlockPos(x, yPos, z);
                        if (!tormentWorld.func_175623_d(pos)) {
                            tormentWorld.func_175698_g(pos);
                        }
                        if (tormentWorld.func_175623_d(pos.func_177984_a())) continue;
                        tormentWorld.func_175698_g(pos.func_177984_a());
                    }
                }
                if (mustTorment == TormentWorldData.TormentType.BOSS) {
                    boolean found = false;
                    if (WitcheryDimensions.TORMENT.isInDimension((Entity)player)) {
                        for (Entity obj : player.field_70170_p.field_72996_f) {
                            if (!(obj instanceof EntityLordOfTorment)) continue;
                            EntityLordOfTorment lot = (EntityLordOfTorment)obj;
                            if (!(lot.field_70163_u >= (double)(yPos - 2)) || !(lot.field_70163_u <= (double)(yPos + 6 - 2))) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        EntityLordOfTorment lot2 = new EntityLordOfTorment((World)tormentWorld);
                        lot2.func_70080_a(9.0, yPos - 1, 36.0, 0.0f, 0.0f);
                        lot2.func_110163_bv();
                        lot2.func_70606_j(lot2.func_110138_aP() * 0.5f);
                        tormentWorld.func_72838_d((Entity)lot2);
                    }
                }
            } else if (mustTorment == TormentWorldData.TormentType.END) {
                tormentData.setTormentType(TormentWorldData.TormentType.NONE);
                tormentData.setTormentLevel(0);
                if (player.func_184218_aH()) {
                    player.func_184210_p();
                }
                WorldServer overworld = player.func_184102_h().field_71305_c[0];
                BlockPos coords = player.getBedLocation(0);
                int dimension = 0;
                if (coords == null) {
                    coords = overworld.func_175694_M();
                }
                int mod = 0;
                int origY = coords.func_177956_o();
                while (!WorldProviderTorment.isSafeBlock((World)overworld, coords) && coords.func_177956_o() > 1 && coords.func_177956_o() < 255) {
                    coords = new BlockPos(coords.func_177958_n(), mod + origY, coords.func_177952_p());
                    if (origY - mod > 1) {
                        mod = -mod;
                    }
                    if (mod < 0) continue;
                    ++mod;
                }
                player.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
                TeleportationUtil.teleportToLocation(coords.func_177984_a(), dimension, (Entity)player, true);
                player.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
            }
        }
    }

    private static boolean isSafeBlock(World world, BlockPos pos) {
        boolean base = !world.func_180495_p(pos).func_185904_a().func_76222_j();
        boolean air1 = world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j();
        boolean air2 = world.func_180495_p(pos.func_177981_b(2)).func_185904_a().func_76222_j();
        return base && air1 && air2;
    }

    public DimensionType func_186058_p() {
        return WitcheryDimensions.TORMENT.getType();
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorTorment(this.field_76579_a);
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76569_d() {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return false;
    }

    public boolean isDaytime() {
        return false;
    }

    public BlockPos getSpawnPoint() {
        return new BlockPos(8, 14, 8);
    }

    public boolean func_76561_g() {
        return true;
    }

    public float func_76563_a(long par1, float par3) {
        return 1.0f;
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return new Vec3d(1.0, 0.0, 0.0);
    }
}

