/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;

public class MazeGenerator {
    public static final int WALL_HEIGHT = 6;
    private final int width;
    private final int depth;
    private final int[][] maze;

    private MazeGenerator(int width, int depth) {
        this.width = width;
        this.depth = depth;
        this.maze = new int[width][depth];
    }

    public static MazeGenerator generateMaze(int width, int depth, Random rand) {
        MazeGenerator generator = new MazeGenerator(width, depth);
        generator.generate(0, 0, rand);
        return generator;
    }

    private static void drawChest(World world, int x, int y, int z) {
        MazeGenerator.setBlock(world, x, y, z, (Block)WitcheryBlocks.REFILLING_CHEST);
    }

    private static boolean between(int v, int upper) {
        return v >= 0 && v < upper;
    }

    private static void setBlock(World world, int x, int y, int z, Block block) {
        world.func_175656_a(new BlockPos(x, y, z), block.func_176223_P());
    }

    public void display(World world, int origX, int origY, int origZ, Block walls, Block floor) {
        int y2;
        int x2;
        int y;
        int x;
        int j;
        int i;
        for (i = 0; i < this.depth; ++i) {
            for (j = 0; j < this.width; ++j) {
                if ((this.maze[j][i] & 1) == 0) {
                    this.drawWall(world, origX + j * 2, origY, origZ + 2 * i, walls);
                    this.drawWall(world, origX + j * 2 + 1, origY, origZ + 2 * i, walls);
                    continue;
                }
                this.drawWall(world, origX + j * 2, origY, origZ + 2 * i, walls);
                this.drawPassage(world, origX + j * 2 + 1, origY, origZ + 2 * i, walls, floor);
            }
            this.drawWall(world, origX + j * 2, origY, origZ + 2 * i, walls);
            for (j = 0; j < this.width; ++j) {
                if ((this.maze[j][i] & 8) == 0) {
                    this.drawWall(world, origX + j * 2, origY, origZ + 2 * i + 1, walls);
                } else {
                    this.drawPassage(world, origX + j * 2, origY, origZ + 2 * i + 1, walls, floor);
                }
                this.drawPassage(world, origX + j * 2 + 1, origY, origZ + 2 * i + 1, walls, floor);
            }
            this.drawWall(world, origX + j * 2, origY, origZ + 2 * i + 1, walls);
        }
        for (j = 0; j < this.width; ++j) {
            this.drawWall(world, origX + j * 2, origY, origZ + 2 * i, walls);
            this.drawWall(world, origX + j * 2 + 1, origY, origZ + 2 * i, walls);
        }
        this.drawWall(world, origX + j * 2, origY, origZ + 2 * i, walls);
        int CHAMBER_WIDTH = 7;
        int CHAMBER_WIDTH_HALF = CHAMBER_WIDTH / 2;
        for (x = 0; x < CHAMBER_WIDTH; ++x) {
            for (y = 0; y < CHAMBER_WIDTH; ++y) {
                this.drawPassage(world, origX + this.width + x - CHAMBER_WIDTH_HALF, origY, origZ + y + 1, walls, floor);
            }
        }
        for (x = 0; x < CHAMBER_WIDTH; ++x) {
            for (y = 0; y < CHAMBER_WIDTH + 2; ++y) {
                this.drawPassage(world, origX + this.width + x - CHAMBER_WIDTH_HALF, origY, origZ + 2 * this.depth + y - CHAMBER_WIDTH, walls, floor);
            }
        }
        this.drawPortal(world, origX + this.width, origY, origZ + 2 * this.depth, floor);
        CHAMBER_WIDTH = 5;
        CHAMBER_WIDTH_HALF = CHAMBER_WIDTH / 2;
        int MAX_SHIFT = 5;
        int shift = world.field_73012_v.nextInt(11) - MAX_SHIFT;
        for (x2 = 0; x2 < CHAMBER_WIDTH; ++x2) {
            for (y2 = 0; y2 < CHAMBER_WIDTH; ++y2) {
                this.drawPassage(world, origX + x2 + 1, origY, origZ + y2 + this.depth - CHAMBER_WIDTH_HALF + shift, walls, floor);
            }
        }
        MazeGenerator.drawChest(world, origX + CHAMBER_WIDTH_HALF + 1, origY, origZ + this.depth + shift);
        shift = world.field_73012_v.nextInt(11) - 5;
        for (x2 = 0; x2 < CHAMBER_WIDTH; ++x2) {
            for (y2 = 0; y2 < CHAMBER_WIDTH; ++y2) {
                this.drawPassage(world, origX + 2 * this.width + x2 - CHAMBER_WIDTH, origY, origZ + y2 + this.depth - CHAMBER_WIDTH_HALF + shift, walls, floor);
            }
        }
        MazeGenerator.drawChest(world, origX + 2 * this.width - CHAMBER_WIDTH_HALF - 1, origY, origZ + this.depth + shift);
        int ROOM_WIDTH = 7;
        int ROOM_WIDTH_HALF = 3;
        for (int x3 = 0; x3 < ROOM_WIDTH; ++x3) {
            for (int y3 = 0; y3 < ROOM_WIDTH; ++y3) {
                this.drawPassage(world, origX + this.width + x3 - ROOM_WIDTH_HALF, origY, origZ + this.depth + y3 - ROOM_WIDTH_HALF, walls, floor);
            }
        }
        MazeGenerator.drawChest(world, origX + this.width, origY, origZ + this.depth);
    }

    private void drawPortal(World world, int x, int y, int z, Block floorBlock) {
        MazeGenerator.setBlock(world, x, y + 1, z, (Block)WitcheryBlocks.TORMENT_PORTAL);
        MazeGenerator.setBlock(world, x, y + 2, z, (Block)WitcheryBlocks.TORMENT_PORTAL);
        MazeGenerator.setBlock(world, x, y + 3, z, floorBlock);
        MazeGenerator.setBlock(world, x - 1, y + 1, z, floorBlock);
        MazeGenerator.setBlock(world, x - 1, y + 2, z, floorBlock);
        MazeGenerator.setBlock(world, x - 1, y + 3, z, floorBlock);
        MazeGenerator.setBlock(world, x + 1, y + 1, z, floorBlock);
        MazeGenerator.setBlock(world, x + 1, y + 2, z, floorBlock);
        MazeGenerator.setBlock(world, x + 1, y + 3, z, floorBlock);
    }

    private void drawWall(World world, int x, int y, int z, Block wallBlock) {
        for (int h = 0; h < 6; ++h) {
            MazeGenerator.setBlock(world, x, y + h, z, wallBlock);
        }
    }

    private void drawPassage(World world, int x, int y, int z, Block wallBlock, Block floorBlock) {
        MazeGenerator.setBlock(world, x, y - 1, z, floorBlock);
        if (world.field_73012_v.nextInt(100) == 0) {
            MazeGenerator.setBlock(world, x, y, z, (Block)Blocks.field_150391_bh);
        } else {
            MazeGenerator.setBlock(world, x, y, z, floorBlock);
        }
        for (int h = 1; h < 5; ++h) {
            world.func_175698_g(new BlockPos(x, y + h, z));
        }
        MazeGenerator.setBlock(world, x, y + 6 - 1, z, wallBlock);
    }

    private void generate(int cx, int cy, Random rand) {
        DIR[] dirs = DIR.values();
        Collections.shuffle(Arrays.asList(dirs), rand);
        for (DIR dir : dirs) {
            int nx = cx + dir.dx;
            int ny = cy + dir.dy;
            if (!MazeGenerator.between(nx, this.width) || !MazeGenerator.between(ny, this.depth) || this.maze[nx][ny] != 0) continue;
            int[] nArray = this.maze[cx];
            int n = cy;
            nArray[n] = nArray[n] | dir.bit;
            int[] nArray2 = this.maze[nx];
            int n2 = ny;
            nArray2[n2] = nArray2[n2] | dir.getOpposite().bit;
            this.generate(nx, ny, rand);
        }
    }

    private static enum DIR {
        N(1, 0, -1, 1),
        S(2, 0, 1, 0),
        E(4, 1, 0, 3),
        W(8, -1, 0, 2);

        private final int bit;
        private final int dx;
        private final int dy;
        private final int opposite;

        private DIR(int bit, int dx, int dy, int opposite) {
            this.bit = bit;
            this.dx = dx;
            this.dy = dy;
            this.opposite = opposite;
        }

        private DIR getOpposite() {
            return DIR.values()[this.opposite];
        }
    }
}

