/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.feature;

import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lnet/msrandom/witchery/world/gen/feature/WitcheryFeature;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "()V", "canGenerate", "", "world", "Lnet/minecraft/world/World;", "position", "Lnet/minecraft/util/math/BlockPos;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "Lnet/minecraft/world/WorldServer;", "isBiomeCategoryValid", "category", "Lnet/minecraftforge/common/BiomeDictionary$Type;", "Companion", "WitcheryResurrected"})
public abstract class WitcheryFeature
implements IWorldGenerator {
    @JvmField
    @NotNull
    public static final HashSet<BiomeDictionary.Type> EXCLUDED_BIOME_CATEGORIES;
    private static final Rotation[] ROTATIONS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull(random, "random");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(chunkGenerator, "chunkGenerator");
        Intrinsics.checkParameterIsNotNull(chunkProvider, "chunkProvider");
        BlockPos position = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        if (this.canGenerate(world, position)) {
            boolean bl;
            block5: {
                void $this$all$iv;
                Set set2 = BiomeDictionary.getTypes((Biome)world.func_180494_b(position));
                Intrinsics.checkExpressionValueIsNotNull(set2, "BiomeDictionary.getTypes(world.getBiome(position))");
                Iterable iterable = set2;
                WitcheryFeature witcheryFeature = this;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        BiomeDictionary.Type p1 = (BiomeDictionary.Type)element$iv;
                        boolean bl2 = false;
                        if (witcheryFeature.isBiomeCategoryValid(p1)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.generate((WorldServer)world, position, random, chunkGenerator);
            }
        }
    }

    public abstract boolean canGenerate(@NotNull World var1, @NotNull BlockPos var2);

    public boolean isBiomeCategoryValid(@NotNull BiomeDictionary.Type category) {
        Intrinsics.checkParameterIsNotNull(category, "category");
        return !EXCLUDED_BIOME_CATEGORIES.contains(category);
    }

    public abstract void generate(@NotNull WorldServer var1, @NotNull BlockPos var2, @NotNull Random var3, @NotNull IChunkGenerator var4);

    static {
        Companion = new Companion(null);
        EXCLUDED_BIOME_CATEGORIES = SetsKt.hashSetOf(BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.BEACH);
        ROTATIONS = Rotation.values();
    }

    @JvmStatic
    @NotNull
    public static final Rotation getRotation(@NotNull Random random) {
        return Companion.getRotation(random);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007R0\u0010\u0003\u001a\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004j\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005`\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lnet/msrandom/witchery/world/gen/feature/WitcheryFeature$Companion;", "", "()V", "EXCLUDED_BIOME_CATEGORIES", "Ljava/util/HashSet;", "Lnet/minecraftforge/common/BiomeDictionary$Type;", "kotlin.jvm.PlatformType", "Lkotlin/collections/HashSet;", "ROTATIONS", "", "Lnet/minecraft/util/Rotation;", "[Lnet/minecraft/util/Rotation;", "getRotation", "random", "Ljava/util/Random;", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Rotation getRotation(@NotNull Random random) {
            Intrinsics.checkParameterIsNotNull(random, "random");
            return ROTATIONS[random.nextInt(ROTATIONS.length)];
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

