/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.msrandom.witchery.block.WitcheryBlockLeaves;
import net.msrandom.witchery.block.WitcheryWoodType;

public class WorldGenLargeWitchTree
extends WorldGenAbstractTree {
    private static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    private final Random rand = new Random();
    private final WitcheryWoodType type;
    private World world;
    private BlockPos basePos = BlockPos.field_177992_a;
    private int heightLimit;
    private int height;
    private double branchSlope = 0.381;
    private double scaleWidth = 1.0;
    private double leafDensity = 1.0;
    private int heightLimitLimit = 12;
    private int leafDistanceLimit = 4;
    private int[][] leafNodes;

    public WorldGenLargeWitchTree(WitcheryWoodType type2) {
        this(type2, 0.381);
    }

    public WorldGenLargeWitchTree(WitcheryWoodType type2, double branchSlope) {
        super(true);
        this.type = type2;
        this.branchSlope = branchSlope;
    }

    void generateLeafNodeList() {
        int i;
        this.height = (int)((double)this.heightLimit * 0.618);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] aint = new int[i * this.heightLimit][4];
        int j = this.basePos.func_177956_o() + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos.func_177956_o() + this.height;
        int i2 = j - this.basePos.func_177956_o();
        aint[0][0] = this.basePos.func_177958_n();
        aint[0][1] = j--;
        aint[0][2] = this.basePos.func_177952_p();
        aint[0][3] = l;
        while (i2 >= 0) {
            float f = this.layerSize(i2);
            if (!(f < 0.0f)) {
                double d0 = 0.5;
                for (int j2 = 0; j2 < i; ++j2) {
                    int[] aint3;
                    int l2;
                    double d3;
                    double d2 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                    int k2 = MathHelper.func_76128_c((double)(d2 * Math.sin(d3 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos.func_177958_n() + d0));
                    int[] aint2 = new int[]{k2, j, l2 = MathHelper.func_76128_c((double)(d2 * Math.cos(d3) + (double)this.basePos.func_177952_p() + d0))};
                    if (this.checkBlockLine(aint2, aint3 = new int[]{k2, j + this.leafDistanceLimit, l2}) != -1) continue;
                    int[] aint4 = new int[]{this.basePos.func_177958_n(), this.basePos.func_177956_o(), this.basePos.func_177952_p()};
                    double d4 = Math.sqrt(Math.pow(Math.abs(this.basePos.func_177958_n() - aint2[0]), 2.0) + Math.pow(Math.abs(this.basePos.func_177952_p() - aint2[2]), 2.0));
                    double d5 = d4 * this.branchSlope;
                    aint4[1] = (double)aint2[1] - d5 > (double)l ? l : (int)((double)aint2[1] - d5);
                    if (this.checkBlockLine(aint4, aint2) != -1) continue;
                    aint[k][0] = k2;
                    aint[k][1] = j;
                    aint[k][2] = l2;
                    aint[k][3] = aint4[1];
                    ++k;
                }
            }
            --j;
            --i2;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(aint, 0, this.leafNodes, 0, k);
    }

    void genTreeLayer(int par1, int par2, int par3, float par4, IBlockState state) {
        int i1 = (int)((double)par4 + 0.618);
        byte b1 = otherCoordPairs[1];
        byte b2 = otherCoordPairs[4];
        int[] aint = new int[]{par1, par2, par3};
        int[] aint2 = new int[]{0, 0, 0};
        aint2[1] = aint[1];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            aint2[b1] = aint[b1] + j1;
            for (int k1 = -i1; k1 <= i1; ++k1) {
                double d0 = Math.pow((double)Math.abs(j1) + 0.5, 2.0) + Math.pow((double)Math.abs(k1) + 0.5, 2.0);
                if (!(d0 <= (double)(par4 * par4))) continue;
                aint2[b2] = aint[b2] + k1;
                BlockPos pos = new BlockPos(aint2[0], aint2[1], aint2[2]);
                Block l1 = this.world.func_180495_p(pos).func_177230_c();
                if (l1 != Blocks.field_150350_a && !(l1 instanceof WitcheryBlockLeaves)) continue;
                this.func_175903_a(this.world, pos, state);
            }
        }
    }

    float layerSize(int par1) {
        if ((double)par1 < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f2 = (float)this.heightLimit / 2.0f - (float)par1;
        float f3 = f2 == 0.0f ? f : (Math.abs(f2) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f2), 2.0)));
        return f3 *= 0.5f;
    }

    float leafSize(int par1) {
        return par1 >= 0 && par1 < this.leafDistanceLimit ? (par1 != 0 && par1 != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    void generateLeafNode(int par1, int par2, int par3) {
        int i1 = par2 + this.leafDistanceLimit;
        for (int l = par2; l < i1; ++l) {
            float f = this.leafSize(l - par2);
            this.genTreeLayer(par1, l, par3, f, this.type.getLeaves().func_176223_P());
        }
    }

    void placeBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger, IBlockState state) {
        int[] aint2 = new int[]{0, 0, 0};
        int b2 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = par2ArrayOfInteger[b0] - par1ArrayOfInteger[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b2])) continue;
            b2 = b0;
        }
        if (aint2[b2] != 0) {
            byte b3 = otherCoordPairs[b2];
            byte b4 = otherCoordPairs[b2 + 3];
            int b5 = aint2[b2] > 0 ? 1 : -1;
            double d0 = (double)aint2[b3] / (double)aint2[b2];
            double d2 = (double)aint2[b4] / (double)aint2[b2];
            int[] aint3 = new int[]{0, 0, 0};
            int k = aint2[b2] + b5;
            for (int j = 0; j != k; j += b5) {
                aint3[b2] = MathHelper.func_76128_c((double)((double)(par1ArrayOfInteger[b2] + j) + 0.5));
                aint3[b3] = MathHelper.func_76128_c((double)((double)par1ArrayOfInteger[b3] + (double)j * d0 + 0.5));
                aint3[b4] = MathHelper.func_76128_c((double)((double)par1ArrayOfInteger[b4] + (double)j * d2 + 0.5));
                this.func_175903_a(this.world, new BlockPos(aint3[0], aint3[1], aint3[2]), state);
            }
        }
    }

    void generateLeaves() {
        for (int[] leafNode : this.leafNodes) {
            int k = leafNode[0];
            int l = leafNode[1];
            int i2 = leafNode[2];
            this.generateLeafNode(k, l, i2);
        }
    }

    boolean leafNodeNeedsBase(int par1) {
        return (double)par1 >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        int i = this.basePos.func_177958_n();
        int j = this.basePos.func_177956_o();
        int k = this.basePos.func_177956_o() + this.height;
        int l = this.basePos.func_177952_p();
        int[] aint = new int[]{i, j, l};
        int[] aint2 = new int[]{i, k, l};
        this.placeBlockLine(aint, aint2, this.type.getLog().func_176223_P());
    }

    void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] aint = new int[]{this.basePos.func_177958_n(), this.basePos.func_177956_o(), this.basePos.func_177952_p()};
        for (int i = 0; i < j; ++i) {
            int[] aint2 = this.leafNodes[i];
            int[] aint3 = new int[]{aint2[0], aint2[1], aint2[2]};
            aint[1] = aint2[3];
            int k = aint[1] - this.basePos.func_177956_o();
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(aint, aint3, this.type.getLog().func_176223_P());
        }
    }

    int checkBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger) {
        int i;
        int[] aint2 = new int[]{0, 0, 0};
        int b2 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = par2ArrayOfInteger[b0] - par1ArrayOfInteger[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b2])) continue;
            b2 = b0;
        }
        if (aint2[b2] == 0) {
            return -1;
        }
        byte b3 = otherCoordPairs[b2];
        byte b4 = otherCoordPairs[b2 + 3];
        int b5 = aint2[b2] > 0 ? 1 : -1;
        double d0 = (double)aint2[b3] / (double)aint2[b2];
        double d2 = (double)aint2[b4] / (double)aint2[b2];
        int[] aint3 = new int[]{0, 0, 0};
        int j = aint2[b2] + b5;
        for (i = 0; i != j; i += b5) {
            aint3[b2] = par1ArrayOfInteger[b2] + i;
            aint3[b3] = MathHelper.func_76128_c((double)((double)par1ArrayOfInteger[b3] + (double)i * d0));
            aint3[b4] = MathHelper.func_76128_c((double)((double)par1ArrayOfInteger[b4] + (double)i * d2));
            Block k = this.world.func_180495_p(new BlockPos(aint3[0], aint3[1], aint3[2])).func_177230_c();
            if (k != Blocks.field_150350_a && !(k instanceof WitcheryBlockLeaves)) break;
        }
        return i == j ? -1 : Math.abs(i);
    }

    boolean validTreeLocation() {
        int[] aint = new int[]{this.basePos.func_177958_n(), this.basePos.func_177956_o(), this.basePos.func_177952_p()};
        int[] aint2 = new int[]{this.basePos.func_177958_n(), this.basePos.func_177956_o() + this.heightLimit - 1, this.basePos.func_177952_p()};
        BlockPos pos = new BlockPos(this.basePos.func_177958_n(), this.basePos.func_177956_o() - 1, this.basePos.func_177952_p());
        IBlockState state = this.world.func_180495_p(pos);
        Block soil = state.func_177230_c();
        boolean isValidSoil = soil.canSustainPlant(state, (IBlockAccess)this.world, pos, EnumFacing.UP, (IPlantable)this.type.getSapling());
        if (!isValidSoil) {
            return false;
        }
        int j = this.checkBlockLine(aint, aint2);
        if (j == -1) {
            return true;
        }
        if (j < 6) {
            return false;
        }
        this.heightLimit = j;
        return true;
    }

    public WorldGenAbstractTree setScale(double heightFactor, double widthFactor, double leafDensity) {
        this.heightLimitLimit = (int)(heightFactor * 12.0);
        if ((double)this.height > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = widthFactor;
        this.leafDensity = leafDensity;
        return this;
    }

    public boolean func_180709_b(World par1World, Random par2Random, BlockPos pos) {
        this.world = par1World;
        long l = par2Random.nextLong();
        this.rand.setSeed(l);
        this.basePos = pos;
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        return true;
    }
}

