/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.msrandom.witchery.entity.EntityVillageGuard;

public class ComponentVillageWall
extends StructureVillagePieces.Village {
    private List<StructureComponent> pieces;
    private boolean hasMadeWall;

    public ComponentVillageWall() {
    }

    public ComponentVillageWall(StructureVillagePieces.Start start, int componentType, StructureBoundingBox bounds, EnumFacing baseMode) {
        super(start, componentType);
        this.func_186164_a(baseMode);
        this.field_74887_e = bounds;
    }

    public static ComponentVillageWall createPiece(StructureVillagePieces.Start start, List<StructureComponent> pieces, int p1, int p2, int p3, EnumFacing p4, int p5) {
        StructureBoundingBox bounds = StructureBoundingBox.func_175897_a((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)2, (int)7, (int)2, (EnumFacing)p4);
        return ComponentVillageWall.func_74895_a((StructureBoundingBox)bounds) && StructureComponent.func_74883_a(pieces, (StructureBoundingBox)bounds) == null ? new ComponentVillageWall(start, p5, bounds, p4) : null;
    }

    public void placeWalls(World world, List<StructureBounds> bb, BlockPos coord) {
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (StructureBounds bounds : bb) {
            minX = Math.min(bounds.field_78897_a, minX);
            minZ = Math.min(bounds.field_78896_c, minZ);
            maxX = Math.max(bounds.field_78893_d, maxX);
            maxZ = Math.max(bounds.field_78892_f, maxZ);
        }
        if (maxX != Integer.MIN_VALUE && minX != Integer.MAX_VALUE && maxZ != Integer.MIN_VALUE && minZ != Integer.MAX_VALUE) {
            byte[][] a = new byte[maxX - minX + 3][maxZ - minZ + 3];
            short[][] b = new short[maxX - minX + 3][maxZ - minZ + 3];
            for (StructureBounds structureBounds : bb) {
                int w = structureBounds.field_78893_d - structureBounds.field_78897_a + 1;
                int wMid = w / 2 + structureBounds.field_78897_a - 1;
                int h = structureBounds.field_78892_f - structureBounds.field_78896_c + 1;
                int hMid = h / 2 + structureBounds.field_78896_c - 1;
                for (int x = structureBounds.field_78897_a; x <= structureBounds.field_78893_d; ++x) {
                    for (int z = structureBounds.field_78896_c; z <= structureBounds.field_78892_f; ++z) {
                        int mx = x - minX + 1;
                        int mz = z - minZ + 1;
                        a[mx][mz] = !structureBounds.xAxis && (z == structureBounds.field_78896_c || z == structureBounds.field_78892_f) && x >= wMid - 1 && x <= wMid + 1 ? 3 : (structureBounds.xAxis && (x == structureBounds.field_78897_a || x == structureBounds.field_78893_d) && z >= hMid - 1 && z <= hMid + 1 ? 3 : 2);
                    }
                }
            }
            int range = 7;
            for (int x2 = 1; x2 < a.length - range; ++x2) {
                for (int z2 = 1; z2 < a[x2].length - range; ++z2) {
                    if (a[x2][z2] != 2) continue;
                    for (int p = 1; p < range; ++p) {
                        int p2;
                        if (a[x2 + p][z2] == 2 && a[x2 + p - 1][z2] == 0) {
                            for (p2 = p; p2 > 0; --p2) {
                                a[x2 + p2][z2] = 2;
                            }
                        }
                        if (a[x2][z2 + p] != 2 || a[x2][z2 + p - 1] != 0) continue;
                        for (p2 = p; p2 > 0; --p2) {
                            a[x2][z2 + p2] = 2;
                        }
                    }
                }
            }
            for (int x2 = 1; x2 < a.length - 1; ++x2) {
                for (int z2 = 1; z2 < a[x2].length - 1; ++z2) {
                    boolean nw;
                    boolean n = a[x2][z2 - 1] == 0;
                    boolean s = a[x2][z2 + 1] == 0;
                    boolean e = a[x2 + 1][z2] == 0;
                    boolean w2 = a[x2 - 1][z2] == 0;
                    boolean ne = a[x2 + 1][z2 - 1] == 0;
                    boolean sw = a[x2 - 1][z2 + 1] == 0;
                    boolean se = a[x2 + 1][z2 + 1] == 0;
                    boolean bl = nw = a[x2 - 1][z2 - 1] == 0;
                    if (n || s || e || w2 || ne || se || nw || sw) continue;
                    a[x2][z2] = 1;
                }
            }
            IBlockState stateBase = this.func_175847_a(Blocks.field_150417_aV.func_176223_P());
            IBlockState stateFence = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            IBlockState stairsBlock = this.func_175847_a(Blocks.field_150390_bg.func_176223_P());
            int guardDist = 0;
            for (int x3 = 1; x3 < a.length - 1; ++x3) {
                for (int z3 = 1; z3 < a[x3].length - 1; ++z3) {
                    int lowestY;
                    int dy;
                    boolean nw2;
                    boolean n2 = a[x3][z3 - 1] >= 2;
                    boolean s2 = a[x3][z3 + 1] >= 2;
                    boolean e2 = a[x3 + 1][z3] >= 2;
                    boolean w3 = a[x3 - 1][z3] >= 2;
                    boolean ne2 = a[x3 + 1][z3 - 1] >= 2;
                    boolean sw2 = a[x3 - 1][z3 + 1] >= 2;
                    boolean se2 = a[x3 + 1][z3 + 1] >= 2;
                    boolean bl = nw2 = a[x3 - 1][z3 - 1] >= 2;
                    if (a[x3][z3] < 2) continue;
                    int dx = minX + x3;
                    int dz = minZ + z3;
                    int solidCount = 0;
                    for (dy = coord.func_177956_o(); dy > 1 && solidCount < 9; --dy) {
                        solidCount = 0;
                        for (int ddx = dx - 1; ddx <= dx + 1; ++ddx) {
                            for (int ddz = dz - 1; ddz <= dz + 1; ++ddz) {
                                boolean replaceable;
                                IBlockState block = world.func_180495_p(new BlockPos(ddx, dy, ddz));
                                boolean bl2 = replaceable = block.func_185904_a().func_76222_j() || block.func_185904_a() == Material.field_151584_j || block.func_185904_a() == Material.field_151575_d || block.func_185904_a() == Material.field_151585_k;
                                if (!block.func_185915_l() || replaceable) continue;
                                ++solidCount;
                            }
                        }
                    }
                    int minHeight = 9;
                    int startY = dy + minHeight;
                    int near = Math.max(Math.max(Math.max(b[x3 - 1][z3], b[x3 + 1][z3]), b[x3][z3 + 1]), b[x3][z3 - 1]);
                    if (near > 0) {
                        if (near > startY) {
                            startY = near - 1;
                        } else if (near < startY) {
                            startY = near + 1;
                        }
                    }
                    if (startY - (lowestY = dy) > 0) {
                        b[x3][z3] = (short)Math.min(Math.max(startY, 0), Short.MAX_VALUE);
                    }
                    for (dy = startY; dy > lowestY; --dy) {
                        boolean wg;
                        boolean gate;
                        if (dy == startY) {
                            if (!(ne2 || n2 || e2)) {
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz - 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz - 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy + 1, dz - 2, stateBase);
                            }
                            if (!(nw2 || n2 || w3)) {
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz - 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy + 1, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz - 1, stateBase);
                            }
                            if (!(se2 || s2 || e2)) {
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz + 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz + 1, stateBase);
                            }
                            if (!(sw2 || s2 || w3)) {
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz + 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz + 1, stateBase);
                            }
                            if (!(n2 || ne2 || nw2)) {
                                ComponentVillageWall.setBlock(world, dx, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx, dy + 1, dz - 2, stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT));
                            }
                            if (!(e2 || se2 || ne2)) {
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz, stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
                            }
                            if (!(s2 || se2 || sw2)) {
                                ComponentVillageWall.setBlock(world, dx, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx, dy + 1, dz + 2, stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT));
                            }
                            if (!(w3 || nw2 || sw2)) {
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz, stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
                            }
                            if (++guardDist <= 200) continue;
                            ComponentVillageWall.spawnGuard(world, dx, dy, dz);
                            guardDist = 0;
                            continue;
                        }
                        int distCheck = 4;
                        boolean bl3 = gate = a[x3][z3] == 3 && (x3 > distCheck && x3 < a.length - distCheck && a[x3 - distCheck][z3] == 2 && a[x3 + distCheck][z3] == 2 || z3 > distCheck && z3 < a[x3].length - distCheck && a[x3][z3 - distCheck] == 2 && a[x3][z3 + distCheck] == 2);
                        if (gate && dy == startY - 3) {
                            BlockPos pos = new BlockPos(dx, dy, dz);
                            world.func_175656_a(pos, stateFence);
                            if (a[x3 + 1][z3] != 3 || a[x3 - 1][z3] != 3) {
                                if (a[x3 + 1][z3] == 3) {
                                    world.func_180501_a(pos.func_177978_c(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT), 2);
                                    world.func_180501_a(pos.func_177968_d(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT), 2);
                                } else if (a[x3 - 1][z3] == 3) {
                                    world.func_180501_a(pos.func_177978_c(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                    world.func_180501_a(pos.func_177968_d(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                } else if (a[x3][z3 + 1] != 3 || a[x3][z3 - 1] != 3) {
                                    if (a[x3][z3 - 1] == 3) {
                                        world.func_180501_a(pos.func_177976_e(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                        world.func_180501_a(pos.func_177974_f(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                    } else if (a[x3][z3 + 1] == 3) {
                                        world.func_180501_a(pos.func_177976_e(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                        world.func_180501_a(pos.func_177974_f(), stairsBlock.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                    }
                                }
                            }
                        }
                        if (gate && dy <= startY - 3) continue;
                        ComponentVillageWall.setBlock(world, dx, dy, dz, stateBase);
                        boolean ng = a[x3][z3 - 1] == 3;
                        boolean sg = a[x3][z3 + 1] == 3;
                        boolean eg = a[x3 + 1][z3] == 3;
                        boolean bl4 = wg = a[x3 - 1][z3] == 3;
                        if (!ng) {
                            ComponentVillageWall.setBlock(world, dx, dy, dz - 1, stateBase);
                        }
                        if (!ng && !eg) {
                            ComponentVillageWall.setBlock(world, dx + 1, dy, dz - 1, stateBase);
                        }
                        if (!ng && !wg) {
                            ComponentVillageWall.setBlock(world, dx - 1, dy, dz - 1, stateBase);
                        }
                        if (!eg) {
                            ComponentVillageWall.setBlock(world, dx + 1, dy, dz, stateBase);
                        }
                        if (!sg) {
                            ComponentVillageWall.setBlock(world, dx, dy, dz + 1, stateBase);
                        }
                        if (!sg && !eg) {
                            ComponentVillageWall.setBlock(world, dx + 1, dy, dz + 1, stateBase);
                        }
                        if (!sg && !wg) {
                            ComponentVillageWall.setBlock(world, dx - 1, dy, dz + 1, stateBase);
                        }
                        if (wg) continue;
                        ComponentVillageWall.setBlock(world, dx - 1, dy, dz, stateBase);
                    }
                }
            }
        }
    }

    private static void spawnGuard(World world, int x, int y, int z) {
        EntityVillageGuard guard = new EntityVillageGuard(world);
        guard.func_70012_b((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        guard.func_110163_bv();
        guard.func_180482_a(world.func_175649_E(guard.func_180425_c()), null);
        world.func_72838_d((Entity)guard);
    }

    private static void setBlock(World world, int x, int y, int z, IBlockState state) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState replaceState = world.func_180495_p(pos);
        Material material = replaceState.func_185904_a();
        if (material.func_76222_j() || material == Material.field_151584_j || material == Material.field_151575_d || material == Material.field_151585_k) {
            world.func_180501_a(pos, state, 2);
        }
    }

    public void func_74861_a(StructureComponent component, List<StructureComponent> pieces, Random rand) {
        super.func_74861_a(component, pieces, rand);
        this.pieces = pieces;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox bounds) {
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, bounds);
            if (this.field_143015_k < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
        }
        if (!this.hasMadeWall) {
            int x = 1;
            int z = 1;
            int xCoord = this.func_74865_a(x, z);
            int yCoord = this.func_74862_a(1);
            int zCoord = this.func_74873_b(x, z);
            BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
            if (this.pieces != null && bounds.func_175898_b((Vec3i)pos)) {
                this.hasMadeWall = true;
                ArrayList<StructureBounds> bb = new ArrayList<StructureBounds>();
                for (StructureComponent component : this.pieces) {
                    if (!(component instanceof StructureVillagePieces.Path)) continue;
                    bb.add(new StructureBounds((StructureVillagePieces.Path)component, 20, 7));
                }
                this.placeWalls(world, bb, pos);
            }
        }
        return true;
    }

    protected void func_143012_a(NBTTagCompound nbtRoot) {
        super.func_143012_a(nbtRoot);
        nbtRoot.func_74757_a("ComponentVillageWall", this.hasMadeWall);
    }

    protected void func_143011_b(NBTTagCompound nbtRoot, TemplateManager p_143011_2_) {
        super.func_143011_b(nbtRoot, p_143011_2_);
        this.hasMadeWall = nbtRoot.func_74767_n("ComponentVillageWall");
    }

    public static class StructureBounds
    extends StructureBoundingBox {
        public final boolean xAxis;

        public StructureBounds(StructureVillagePieces.Path path, int expansionX, int expansionZ) {
            this(path.func_74874_b(), expansionX, expansionZ);
        }

        public StructureBounds(StructureBoundingBox bb, int expansionX, int expansionZ) {
            this(bb.field_78897_a, bb.field_78895_b, bb.field_78896_c, bb.field_78893_d, bb.field_78894_e, bb.field_78892_f, expansionX, expansionZ);
        }

        public StructureBounds(int x, int y, int z, int x2, int y2, int z2, int expansionX, int expansionZ) {
            boolean bl = this.xAxis = x2 - x > z2 - z;
            if (this.xAxis) {
                this.field_78897_a = x - expansionZ;
                this.field_78893_d = x2 + expansionZ;
                this.field_78896_c = z - expansionX;
                this.field_78892_f = z2 + expansionX;
            } else {
                this.field_78897_a = x - expansionX;
                this.field_78893_d = x2 + expansionX;
                this.field_78896_c = z - expansionZ;
                this.field_78892_f = z2 + expansionZ;
            }
            this.field_78895_b = y;
            this.field_78894_e = y2;
        }
    }
}

