/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/msrandom/witchery/world/loot/functions/LevelledRandomEnchantment;", "Lnet/minecraft/world/storage/loot/functions/LootFunction;", "conditions", "", "Lnet/minecraft/world/storage/loot/conditions/LootCondition;", "level", "", "enchantments", "", "Lnet/minecraft/enchantment/Enchantment;", "([Lnet/minecraft/world/storage/loot/conditions/LootCondition;ILjava/util/List;)V", "apply", "Lnet/minecraft/item/ItemStack;", "stack", "random", "Ljava/util/Random;", "context", "Lnet/minecraft/world/storage/loot/LootContext;", "Companion", "Serializer", "WitcheryResurrected"})
public final class LevelledRandomEnchantment
extends LootFunction {
    private final List<Enchantment> enchantments;
    private final int level;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    public ItemStack func_186553_a(@NotNull ItemStack stack, @NotNull Random random, @NotNull LootContext context) {
        Enchantment enchantment;
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(random, "random");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ItemStack newStack = stack;
        if (this.enchantments.isEmpty()) {
            boolean bl = false;
            List list2 = new ArrayList();
            for (Enchantment enchantment1 : Enchantment.field_185264_b) {
                if (stack.func_77973_b() != Items.field_151122_aG && !enchantment1.func_92089_a(stack)) continue;
                Enchantment enchantment2 = enchantment1;
                Intrinsics.checkExpressionValueIsNotNull(enchantment2, "enchantment1");
                list2.add(enchantment2);
            }
            if (list2.isEmpty()) {
                LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
                return stack;
            }
            enchantment = (Enchantment)list2.get(random.nextInt(list2.size()));
        } else {
            enchantment = this.enchantments.get(random.nextInt(this.enchantments.size()));
        }
        Enchantment enchantment3 = enchantment;
        int minLevel = RangesKt.coerceAtMost(enchantment3.func_77319_d() + this.level, enchantment3.func_77325_b());
        int i = MathHelper.func_76136_a((Random)random, (int)minLevel, (int)enchantment3.func_77325_b());
        if (newStack.func_77973_b() == Items.field_151122_aG) {
            newStack = new ItemStack(Items.field_151134_bR);
            ItemEnchantedBook.func_92115_a((ItemStack)newStack, (EnchantmentData)new EnchantmentData(enchantment3, i));
        } else {
            newStack.func_77966_a(enchantment3, i);
        }
        return newStack;
    }

    public LevelledRandomEnchantment(@NotNull LootCondition[] conditions, int level, @Nullable List<? extends Enchantment> enchantments) {
        Intrinsics.checkParameterIsNotNull(conditions, "conditions");
        super(conditions);
        this.level = level;
        List<Object> list2 = enchantments;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.enchantments = list2;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LogManager.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lnet/msrandom/witchery/world/loot/functions/LevelledRandomEnchantment$Serializer;", "Lnet/minecraft/world/storage/loot/functions/LootFunction$Serializer;", "Lnet/msrandom/witchery/world/loot/functions/LevelledRandomEnchantment;", "()V", "deserialize", "json", "Lcom/google/gson/JsonObject;", "deserializationContext", "Lcom/google/gson/JsonDeserializationContext;", "conditions", "", "Lnet/minecraft/world/storage/loot/conditions/LootCondition;", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonDeserializationContext;[Lnet/minecraft/world/storage/loot/conditions/LootCondition;)Lnet/msrandom/witchery/world/loot/functions/LevelledRandomEnchantment;", "serialize", "", "function", "serializationContext", "Lcom/google/gson/JsonSerializationContext;", "WitcheryResurrected"})
    public static final class Serializer
    extends LootFunction.Serializer<LevelledRandomEnchantment> {
        public static final Serializer INSTANCE;

        public void serialize(@NotNull JsonObject json, @NotNull LevelledRandomEnchantment function, @NotNull JsonSerializationContext serializationContext) {
            Intrinsics.checkParameterIsNotNull(json, "json");
            Intrinsics.checkParameterIsNotNull((Object)function, "function");
            Intrinsics.checkParameterIsNotNull(serializationContext, "serializationContext");
            if (function.level != 0) {
                json.addProperty("level", (Number)function.level);
            }
            Collection collection = function.enchantments;
            boolean bl = false;
            if (!collection.isEmpty()) {
                JsonArray array = new JsonArray();
                for (Enchantment enchantment : function.enchantments) {
                    ResourceLocation id;
                    if ((ResourceLocation)Enchantment.field_185264_b.func_177774_c((Object)enchantment) == null) {
                        throw (Throwable)new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    Intrinsics.checkExpressionValueIsNotNull(id, "Enchantment.REGISTRY.get\u2026nchantment $enchantment\")");
                    array.add((JsonElement)new JsonPrimitive(id.toString()));
                }
                json.add("enchantments", (JsonElement)array);
            }
        }

        @NotNull
        public LevelledRandomEnchantment deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext deserializationContext, @NotNull LootCondition[] conditions) {
            Intrinsics.checkParameterIsNotNull(json, "json");
            Intrinsics.checkParameterIsNotNull(deserializationContext, "deserializationContext");
            Intrinsics.checkParameterIsNotNull(conditions, "conditions");
            boolean bl = false;
            List list2 = new ArrayList();
            if (json.has("enchantments")) {
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"enchantments")) {
                    Enchantment enchantment;
                    String s = JsonUtils.func_151206_a((JsonElement)element, (String)"enchantment");
                    if ((Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(s)) == null) {
                        throw (Throwable)new JsonSyntaxException("Unknown enchantment '" + s + '\'');
                    }
                    Intrinsics.checkExpressionValueIsNotNull(enchantment, "Enchantment.REGISTRY.get\u2026nknown enchantment '$s'\")");
                    list2.add(enchantment);
                }
            }
            JsonElement jsonElement = json.get("level");
            return new LevelledRandomEnchantment(conditions, jsonElement != null ? jsonElement.getAsInt() : 0, list2);
        }

        private Serializer() {
            super(new ResourceLocation("witchery", "levelled_random_enchantment"), LevelledRandomEnchantment.class);
        }

        static {
            Serializer serializer;
            INSTANCE = serializer = new Serializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/msrandom/witchery/world/loot/functions/LevelledRandomEnchantment$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

