/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.Loader;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.anthonyhilyard.legendarytooltips.util.ItemColor;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Mod(modid="legendarytooltips", name="Legendary Tooltips", version="1.1.9", acceptedMinecraftVersions="[1.12.2]", clientSideOnly=true)
@Mod.EventBusSubscriber(modid="legendarytooltips", value={Side.CLIENT})
public class LegendaryTooltips {
    @Mod.Instance(value="legendarytooltips")
    public LegendaryTooltips instance;
    public static final int STANDARD = -1;
    public static final int NUM_FRAMES = 16;
    private static ItemStack lastTooltipItem = null;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LegendaryTooltipsConfig.loadConfig(event.getSuggestedConfigurationFile());
    }

    private static Integer[] itemFrameColors(ItemStack item, Integer[] defaults) {
        int frameLevel = LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(item);
        if (frameLevel != -1) {
            int startColor = LegendaryTooltipsConfig.INSTANCE.getCustomBorderStartColor(frameLevel);
            int endColor = LegendaryTooltipsConfig.INSTANCE.getCustomBorderEndColor(frameLevel);
            int bgColor = LegendaryTooltipsConfig.INSTANCE.getCustomBackgroundColor(frameLevel);
            if (startColor == -1) {
                startColor = defaults[0];
            }
            if (endColor == -1) {
                endColor = defaults[1];
            }
            if (bgColor == -1) {
                bgColor = defaults[2];
            }
            return new Integer[]{startColor, endColor, bgColor};
        }
        if (LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity) {
            int rarityColor = ItemColor.getColorForItem(item, 0xFFFFFF);
            float[] hsbVals = new float[3];
            Color.RGBtoHSB(rarityColor >> 16 & 0xFF, rarityColor >> 8 & 0xFF, rarityColor >> 0 & 0xFF, hsbVals);
            boolean addHue = false;
            if (hsbVals[0] * 360.0f < 62.0f) {
                addHue = false;
            } else if (hsbVals[0] * 360.0f <= 240.0f) {
                addHue = true;
            }
            int startColor = Color.getHSBColor(addHue ? hsbVals[0] - 0.006f : hsbVals[0] + 0.006f, hsbVals[1], hsbVals[2]).getRGB();
            int endColor = Color.getHSBColor(addHue ? hsbVals[0] + 0.04f : hsbVals[0] - 0.04f, hsbVals[1], hsbVals[2]).getRGB();
            int bgColor = Color.getHSBColor(addHue ? hsbVals[0] - 0.0045f : hsbVals[0] + 0.0045f, hsbVals[1] * 0.85f, 0.0627451f).getRGB();
            return new Integer[]{startColor & 0xDDFFFFFF, endColor & 0xAAFFFFFF, bgColor & 0xF0FFFFFF};
        }
        return defaults;
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TooltipDecor.updateTimers();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && mc.field_71462_r instanceof GuiContainer) {
            if (((GuiContainer)mc.field_71462_r).getSlotUnderMouse() != null && ((GuiContainer)mc.field_71462_r).getSlotUnderMouse().func_75216_d()) {
                if (lastTooltipItem != ((GuiContainer)mc.field_71462_r).getSlotUnderMouse().func_75211_c()) {
                    TooltipDecor.resetTimers();
                    lastTooltipItem = ((GuiContainer)mc.field_71462_r).getSlotUnderMouse().func_75211_c();
                }
            } else {
                TooltipDecor.resetTimers();
            }
        }
        if (net.minecraftforge.fml.common.Loader.isModLoaded((String)"equipmentcompare")) {
            try {
                if (((Boolean)Class.forName("com.anthonyhilyard.legendarytooltips.compat.EquipmentCompareHandler").getMethod("comparisonsJustActivated", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                    for (int i = 1; i < 10; ++i) {
                        TooltipDecor.resetTimer(i);
                    }
                }
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @SubscribeEvent
    public static void onPreTooltipEvent(RenderTooltipEvent.Pre event) {
        int index = 0;
        if (net.minecraftforge.fml.common.Loader.isModLoaded((String)"equipmentcompare")) {
            try {
                index = (Integer)Class.forName("com.anthonyhilyard.legendarytooltips.compat.EquipmentCompareHandler").getMethod("getEventIndex", Event.class).invoke(null, event);
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        TooltipDecor.setCachedLines(event.getLines(), index);
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        Integer[] borderColors = LegendaryTooltips.itemFrameColors(event.getStack(), new Integer[]{event.getBorderStart(), event.getBorderEnd(), event.getBackground()});
        TooltipDecor.setCurrentTooltipBorderStart(borderColors[0]);
        TooltipDecor.setCurrentTooltipBorderEnd(borderColors[1]);
        boolean comparison = false;
        if (net.minecraftforge.fml.common.Loader.isModLoaded((String)"equipmentcompare")) {
            try {
                comparison = (Boolean)Class.forName("com.anthonyhilyard.legendarytooltips.compat.EquipmentCompareHandler").getMethod("isComparisonEvent", Event.class).invoke(null, event);
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (comparison) {
            event.setBorderStart(0);
            event.setBorderEnd(0);
        } else {
            event.setBorderStart(borderColors[0].intValue());
            event.setBorderEnd(borderColors[1].intValue());
        }
        event.setBackground(borderColors[2].intValue());
    }

    @SubscribeEvent
    public static void onPostTooltipEvent(RenderTooltipEvent.PostText event) {
        boolean comparison = false;
        int index = 0;
        if (net.minecraftforge.fml.common.Loader.isModLoaded((String)"equipmentcompare")) {
            try {
                comparison = (Boolean)Class.forName("com.anthonyhilyard.legendarytooltips.compat.EquipmentCompareHandler").getMethod("isComparisonEvent", Event.class).invoke(null, event);
                index = (Integer)Class.forName("com.anthonyhilyard.legendarytooltips.compat.EquipmentCompareHandler").getMethod("getEventIndex", Event.class).invoke(null, event);
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (LegendaryTooltipsConfig.INSTANCE.tooltipShadow) {
            if (comparison) {
                TooltipDecor.drawShadow(event.getX(), event.getY() - 11, event.getWidth(), event.getHeight() + 11);
            } else {
                TooltipDecor.drawShadow(event.getX(), event.getY(), event.getWidth(), event.getHeight());
            }
        }
        if (comparison) {
            TooltipDecor.drawBorder(event.getX(), event.getY() - 11, event.getWidth(), event.getHeight() + 11, event.getStack(), event.getLines(), event.getFontRenderer(), LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(event.getStack()), comparison, index);
        } else {
            TooltipDecor.drawBorder(event.getX(), event.getY(), event.getWidth(), event.getHeight(), event.getStack(), event.getLines(), event.getFontRenderer(), LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(event.getStack()), comparison, index);
        }
    }
}

