/*
 * Decompiled with CFR 0.152.
 */
package ninjabrain.gendustryjei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ninjabrain.gendustryjei.categories.CategoryBase;
import ninjabrain.gendustryjei.categories.CategoryDNA;
import ninjabrain.gendustryjei.categories.CategoryImprinter;
import ninjabrain.gendustryjei.categories.CategoryMutagen;
import ninjabrain.gendustryjei.categories.CategoryMutatron;
import ninjabrain.gendustryjei.categories.CategoryProtein;
import ninjabrain.gendustryjei.categories.CategoryReplicator;
import ninjabrain.gendustryjei.categories.CategorySampler;
import ninjabrain.gendustryjei.categories.CategoryTransposer;
import ninjabrain.gendustryjei.init.RecipeConverterDNA;
import ninjabrain.gendustryjei.init.RecipeConverterImprinter;
import ninjabrain.gendustryjei.init.RecipeConverterMutagen;
import ninjabrain.gendustryjei.init.RecipeConverterMutatron;
import ninjabrain.gendustryjei.init.RecipeConverterProtein;
import ninjabrain.gendustryjei.init.RecipeConverterReplicator;
import ninjabrain.gendustryjei.init.RecipeConverterSampler;
import ninjabrain.gendustryjei.init.RecipeConverterTransposer;
import ninjabrain.gendustryjei.init.RecipeReader;
import ninjabrain.gendustryjei.util.ConfigHelper;
import ninjabrain.gendustryjei.wrappers.WrapperDNA;
import ninjabrain.gendustryjei.wrappers.WrapperImprinter;
import ninjabrain.gendustryjei.wrappers.WrapperMutagen;
import ninjabrain.gendustryjei.wrappers.WrapperMutatron;
import ninjabrain.gendustryjei.wrappers.WrapperProtein;
import ninjabrain.gendustryjei.wrappers.WrapperReplicator;
import ninjabrain.gendustryjei.wrappers.WrapperSampler;
import ninjabrain.gendustryjei.wrappers.WrapperTransposer;

@JEIPlugin
public class GendustryJEIPlugin
implements IModPlugin {
    CategoryBase<?>[] categories;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        ISubtypeRegistry.ISubtypeInterpreter geneSampleInterpreter = new ISubtypeRegistry.ISubtypeInterpreter(){

            public String apply(ItemStack itemStack) {
                if (itemStack.func_77942_o()) {
                    String alleleUID = itemStack.func_77978_p().func_74779_i("allele");
                    return alleleUID;
                }
                return "";
            }
        };
        subtypeRegistry.registerSubtypeInterpreter(Item.func_111206_d((String)"gendustry:gene_sample"), geneSampleInterpreter);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        CategoryBase.loadWidgets(registry);
        this.categories = new CategoryBase[]{new CategoryMutagen(), new CategoryProtein(), new CategoryDNA(), new CategoryMutatron(), new CategorySampler(), new CategoryTransposer(), new CategoryImprinter(), new CategoryReplicator()};
        registry.addRecipeCategories((IRecipeCategory[])this.categories);
    }

    public void register(IModRegistry registry) {
        ArrayList<WrapperMutagen> mutagenWrappers = new ArrayList<WrapperMutagen>();
        ArrayList<WrapperProtein> proteinWrappers = new ArrayList<WrapperProtein>();
        ArrayList<WrapperDNA> dnaWrappers = new ArrayList<WrapperDNA>();
        ArrayList<WrapperMutatron> mutatronWrappers = new ArrayList<WrapperMutatron>();
        ArrayList<WrapperSampler> samplerWrappers = new ArrayList<WrapperSampler>();
        ArrayList<WrapperTransposer> transposerWrappers = new ArrayList<WrapperTransposer>();
        ArrayList<WrapperImprinter> imprinterWrappers = new ArrayList<WrapperImprinter>();
        ArrayList<WrapperReplicator> replicatorWrappers = new ArrayList<WrapperReplicator>();
        ArrayList converters = new ArrayList();
        if (ConfigHelper.machines.showMutagenProducerRecipes) {
            converters.add(new RecipeConverterMutagen(mutagenWrappers));
        }
        if (ConfigHelper.machines.showProteinLiquifierRecipes) {
            converters.add(new RecipeConverterProtein(proteinWrappers));
        }
        if (ConfigHelper.machines.showDNAExtractorRecipes) {
            converters.add(new RecipeConverterDNA(dnaWrappers));
        }
        if (ConfigHelper.machines.showMutatronRecipes) {
            converters.add(new RecipeConverterMutatron(mutatronWrappers));
        }
        if (ConfigHelper.machines.showSamplerRecipes) {
            converters.add(new RecipeConverterSampler(samplerWrappers));
        }
        if (ConfigHelper.machines.showGeneticTransposerRecipes) {
            converters.add(new RecipeConverterTransposer(transposerWrappers));
        }
        if (ConfigHelper.machines.showImprinterRecipes) {
            converters.add(new RecipeConverterImprinter(imprinterWrappers));
        }
        if (ConfigHelper.machines.showReplicatorRecipes) {
            converters.add(new RecipeConverterReplicator(replicatorWrappers));
        }
        RecipeReader.convertGendustryRecipes(converters);
        if (ConfigHelper.machines.showMutagenProducerRecipes) {
            registry.addRecipes(mutagenWrappers, "GENDUSTRY_MUTAGEN_PRODUCER");
        }
        if (ConfigHelper.machines.showProteinLiquifierRecipes) {
            registry.addRecipes(proteinWrappers, "GENDUSTRY_PROTEIN_LIQUIFIER");
        }
        if (ConfigHelper.machines.showDNAExtractorRecipes) {
            registry.addRecipes(dnaWrappers, "GENDUSTRY_DNA_LIQUIFIER");
        }
        if (ConfigHelper.machines.showMutatronRecipes) {
            registry.addRecipes(mutatronWrappers, "GENDUSTRY_MUTATRON");
        }
        if (ConfigHelper.machines.showSamplerRecipes) {
            registry.addRecipes(samplerWrappers, "GENDUSTRY_SAMPLER");
        }
        if (ConfigHelper.machines.showGeneticTransposerRecipes) {
            registry.addRecipes(transposerWrappers, "GENDUSTRY_TRANSPOSER");
        }
        if (ConfigHelper.machines.showImprinterRecipes) {
            registry.addRecipes(imprinterWrappers, "GENDUSTRY_IMPRINTER");
        }
        if (ConfigHelper.machines.showReplicatorRecipes) {
            registry.addRecipes(replicatorWrappers, "GENDUSTRY_REPLICATOR");
        }
        for (CategoryBase<?> category : this.categories) {
            registry.addRecipeCatalyst((Object)new ItemStack(category.getMachine()), new String[]{category.getUid()});
        }
        if (ConfigHelper.machines.showMutatronRecipes) {
            registry.addRecipeCatalyst((Object)new ItemStack(Item.func_111206_d((String)"gendustry:mutatron_advanced")), new String[]{"GENDUSTRY_MUTATRON"});
        }
    }
}

