/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.tile;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.event.HandleWorldGen;

@Mod.EventBusSubscriber(modid="lootr")
public class TileTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static boolean tickingList = false;
    private static final Set<Entry> tileEntries = new ObjectLinkedOpenHashSet();
    private static final Set<Entry> pendingEntries = new ObjectLinkedOpenHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(World world, BlockPos position) {
        if (world.field_72995_K) {
            return;
        }
        if (ConfigManager.isDimensionBlocked(world.field_73011_w.getDimension())) {
            return;
        }
        WorldBorder border = world.func_175723_af();
        if (!border.func_177746_a(position)) {
            return;
        }
        Entry newEntry = new Entry(world.field_73011_w.getDimension(), position);
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                tileEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ObjectLinkedOpenHashSet copy;
            ObjectLinkedOpenHashSet toRemove = new ObjectLinkedOpenHashSet();
            Object object = listLock;
            synchronized (object) {
                tickingList = true;
                copy = new ObjectLinkedOpenHashSet(tileEntries);
                tickingList = false;
            }
            object = worldLock;
            synchronized (object) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server == null) {
                    return;
                }
                for (Entry entry : copy) {
                    WorldServer level = DimensionManager.getWorld((int)entry.getDimension(), (boolean)false);
                    if (level == null || !level.func_175723_af().func_177730_a(entry.getChunkPosition())) {
                        toRemove.add(entry);
                        continue;
                    }
                    ChunkProviderServer provider = level.func_72863_F();
                    ChunkPos pos = entry.getChunkPosition();
                    Chunk chunk = provider.func_186026_b(pos.field_77276_a, pos.field_77275_b);
                    if (chunk == null) continue;
                    TileEntity tile = level.func_175625_s(entry.getPosition());
                    if (!(tile instanceof TileEntityLockableLoot) || tile instanceof ILootTile) {
                        toRemove.add(entry);
                        continue;
                    }
                    TileEntityLockableLoot te = (TileEntityLockableLoot)tile;
                    if (te.field_184284_m == null || ConfigManager.isBlacklisted(te.field_184284_m)) {
                        toRemove.add(entry);
                        continue;
                    }
                    ResourceLocation table = te.field_184284_m;
                    long seed = te.field_184285_n;
                    IBlockState stateAt = level.func_180495_p(entry.getPosition());
                    IBlockState replacement = ConfigManager.replacement(stateAt);
                    if (replacement == null) {
                        toRemove.add(entry);
                        continue;
                    }
                    te.func_174888_l();
                    tile = HandleWorldGen.replaceOldLootBlockAt(chunk, entry.getPosition(), replacement);
                    if (tile instanceof ILootTile) {
                        ((TileEntityLockableLoot)tile).func_189404_a(table, seed);
                    } else {
                        Lootr.LOG.error("replacement TE " + tile + " is not an ILootTile " + entry.getDimension() + " at " + entry.getPosition());
                    }
                    toRemove.add(entry);
                }
            }
            object = listLock;
            synchronized (object) {
                tickingList = true;
                tileEntries.removeAll((Collection<?>)toRemove);
                tileEntries.addAll(pendingEntries);
                tickingList = false;
                pendingEntries.clear();
            }
        }
    }

    public static class Entry {
        private final int dimension;
        private final BlockPos position;
        private final ChunkPos chunkPos;

        public Entry(int dimension, BlockPos position) {
            this.dimension = dimension;
            this.position = position;
            this.chunkPos = new ChunkPos(position);
        }

        public int getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public ChunkPos getChunkPosition() {
            return this.chunkPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.dimension != entry.dimension) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension;
            result = 31 * result + this.position.hashCode();
            return result;
        }
    }
}

