/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.command;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.tile.LootrInventoryTileEntity;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.util.ChestUtil;

public class LootrCommand
implements ICommand {
    private static List<ResourceLocation> tables = null;
    private static List<String> tableNames = null;
    private static final Map<String, UUID> profileMap = new HashMap<String, UUID>();

    @Nonnull
    public String func_71517_b() {
        return "lootr";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender iCommandSender) {
        return "lootr.commands.usage";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return ImmutableList.of();
    }

    @Nullable
    private static String getArgIfExists(String[] args, int i) {
        if (args.length >= i + 1) {
            return args[i];
        }
        return null;
    }

    @Nonnull
    private static String getArgAt(String[] args, int i) throws CommandException {
        if (args.length >= i + 1) {
            return args[i];
        }
        throw new WrongUsageException("lootr.commands.usage", new Object[0]);
    }

    private void clearPlayerProfile(ICommandSender c, String profileName) {
        GameProfile profile = c.func_184102_h().func_152358_ax().func_152655_a(profileName);
        if (profile == null) {
            c.func_145747_a((ITextComponent)new TextComponentString("Invalid player name: " + profileName + ", profile not found in the cache."));
            return;
        }
        c.func_145747_a((ITextComponent)new TextComponentString(DataStorage.clearInventories(profile.getId()) ? "Cleared stored inventories for " + profileName : "No stored inventories for " + profileName + " to clear"));
    }

    private static Block getBlockFromArg(String arg) {
        switch (arg) {
            case "chest": {
                return ModBlocks.CHEST;
            }
            case "cart": {
                return null;
            }
            case "shulker": {
                return ModBlocks.SHULKER;
            }
        }
        throw new IllegalArgumentException(arg);
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        String command;
        switch (command = LootrCommand.getArgAt(args, 0)) {
            case "clear": {
                this.clearPlayerProfile(sender, LootrCommand.getArgAt(args, 1));
                break;
            }
            case "chest": 
            case "cart": 
            case "shulker": {
                String table = LootrCommand.getArgIfExists(args, 1);
                LootrCommand.createBlock(sender, LootrCommand.getBlockFromArg(command), table != null ? new ResourceLocation(table) : null);
                break;
            }
            case "openers": {
                if (args.length < 4) {
                    throw new WrongUsageException("lootr.commands.usage", new Object[0]);
                }
                Vec3d vec3d = sender.func_174791_d();
                int j = 1;
                CommandBase.CoordinateArg argX = CommandBase.func_175770_a((double)vec3d.field_72450_a, (String)args[j++], (boolean)true);
                CommandBase.CoordinateArg argY = CommandBase.func_175767_a((double)vec3d.field_72448_b, (String)args[j++], (int)-4096, (int)4096, (boolean)false);
                CommandBase.CoordinateArg argZ = CommandBase.func_175770_a((double)vec3d.field_72449_c, (String)args[j++], (boolean)true);
                BlockPos position = new BlockPos(argX.func_179628_a(), argY.func_179628_a(), argZ.func_179628_a());
                World world = sender.func_130014_f_();
                TileEntity tile = world.func_175625_s(position);
                if (tile instanceof ILootTile) {
                    Set<UUID> openers = ((ILootTile)tile).getOpeners();
                    sender.func_145747_a((ITextComponent)new TextComponentString("Tile at location " + position + " has " + openers.size() + " openers. UUIDs as follows:"));
                    for (UUID uuid : openers) {
                        GameProfile profile = sender.func_184102_h().func_152358_ax().func_152652_a(uuid);
                        sender.func_145747_a((ITextComponent)new TextComponentString("UUID: " + uuid + ", user profile: " + (profile == null ? "null" : profile.getName())));
                    }
                    break;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("No Lootr tile exists at location: " + position));
                break;
            }
            case "custom": {
                BlockPos pos = sender.func_180425_c();
                World world = sender.func_130014_f_();
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() != Blocks.field_150486_ae) {
                    pos = pos.func_177977_b();
                    state = world.func_180495_p(pos);
                }
                if (state.func_177230_c() != Blocks.field_150486_ae) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Please stand on the chest you wish to convert."));
                    break;
                }
                NonNullList reference = ((TileEntityChest)Objects.requireNonNull(world.func_175625_s((BlockPos)pos))).field_145985_p;
                NonNullList<ItemStack> custom = ChestUtil.copyItemList((NonNullList<ItemStack>)reference);
                world.func_175713_t(pos);
                world.func_175656_a(pos, ModBlocks.INVENTORY.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a))));
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof LootrInventoryTileEntity)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Unable to convert chest, BlockState is not a Lootr Inventory block."));
                    break;
                }
                LootrInventoryTileEntity inventory = (LootrInventoryTileEntity)te;
                inventory.setCustomInventory(custom);
                inventory.func_70296_d();
                break;
            }
            default: {
                throw new WrongUsageException("lootr.commands.usage", new Object[0]);
            }
        }
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, ICommandSender iCommandSender) {
        return iCommandSender.func_70003_b(2, this.func_71517_b());
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, String[] args, @Nullable BlockPos blockPos) {
        if (args.length == 0) {
            return ImmutableList.of((Object)"chest", (Object)"shulker", (Object)"cart", (Object)"clear", (Object)"openers");
        }
        String cmd = args[0];
        if (cmd.equals("chest") || cmd.equals("shulker") || cmd.equals("cart")) {
            return LootrCommand.getTableNames();
        }
        return ImmutableList.of();
    }

    public boolean func_82358_a(String[] args, int i) {
        return args.length >= 1 && args[0].equals("clear") && i == 1;
    }

    public int compareTo(@Nonnull ICommand iCommand) {
        return 0;
    }

    private static List<ResourceLocation> getTables() {
        if (tables == null) {
            tables = new ArrayList<ResourceLocation>(LootTableList.func_186374_a());
            tableNames = tables.stream().map(ResourceLocation::toString).collect(Collectors.toList());
        }
        return tables;
    }

    private static List<String> getTableNames() {
        LootrCommand.getTables();
        return tableNames;
    }

    public static void createBlock(ICommandSender c, @Nullable Block block, @Nullable ResourceLocation table) {
        World world = c.func_130014_f_();
        BlockPos pos = new BlockPos((Vec3i)c.func_180425_c());
        if (table == null) {
            table = LootrCommand.getTables().get(world.field_73012_v.nextInt(LootrCommand.getTables().size()));
        }
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            Entity e = c.func_174793_f();
            if (e != null) {
                cart.field_70177_z = e.field_70177_z;
            }
            cart.func_184289_a(table, world.field_73012_v.nextLong());
            world.func_72838_d((Entity)cart);
            c.func_145747_a((ITextComponent)new TextComponentTranslation("lootr.commands.summon", new Object[]{new TextComponentTranslation("lootr.commands.blockpos", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), table.toString()}));
        } else {
            IBlockState placementState = block.func_176223_P();
            Entity e = c.func_174793_f();
            if (e != null) {
                PropertyDirection prop = null;
                EnumFacing dir = null;
                if (placementState.func_177227_a().contains(LootrChestBlock.field_176459_a)) {
                    prop = LootrChestBlock.field_176459_a;
                    dir = e.func_174811_aO().func_176734_d();
                } else if (placementState.func_177227_a().contains(LootrShulkerBlock.field_190957_a)) {
                    prop = LootrShulkerBlock.field_190957_a;
                }
                if (prop != null && dir != null) {
                    placementState = placementState.func_177226_a((IProperty)prop, (Comparable)dir);
                }
            }
            world.func_180501_a(pos, placementState, 2);
            ((TileEntityLockableLoot)world.func_175625_s(pos)).func_189404_a(table, world.field_73012_v.nextLong());
            c.func_145747_a((ITextComponent)new TextComponentTranslation("lootr.commands.create", new Object[]{new TextComponentString(block.func_149732_F()), new TextComponentTranslation("lootr.commands.blockpos", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), table.toString()}));
        }
    }
}

