/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.data.TickingData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class DataStorage {
    public static final String ID_OLD = "Lootr-AdvancementData";
    public static final String SCORED_OLD = "Lootr-ScoreData";
    public static final String DECAY_OLD = "Lootr-DecayData";
    public static final String REFRESH_OLD = "Lootr-RefreshData";
    public static final String ID = "lootr/Lootr-AdvancementData";
    public static final String SCORED = "lootr/Lootr-ScoreData";
    public static final String DECAY = "lootr/Lootr-DecayData";
    public static final String REFRESH = "lootr/Lootr-RefreshData";

    private static <T extends WorldSavedData> T computeIfAbsentManager(MapStorage manager, Supplier<T> supplier, String key) {
        WorldSavedData newData = (WorldSavedData)supplier.get();
        WorldSavedData value = manager.func_75742_a(newData.getClass(), key);
        if (value == null) {
            manager.func_75745_a(key, newData);
            return (T)newData;
        }
        return (T)value;
    }

    public static int getDecayValue(UUID id) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(DECAY), DECAY);
        return data.getValue(id);
    }

    public static boolean isDecayed(UUID id) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(DECAY), DECAY);
        return data.isDone(id);
    }

    public static void setDecaying(UUID id, int decay) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(DECAY), DECAY);
        data.setValue(id, decay);
        data.func_76185_a();
    }

    public static void removeDecayed(UUID id) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(DECAY), DECAY);
        if (data.removeDone(id) != -1) {
            data.func_76185_a();
        }
    }

    public static void doDecay() {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(DECAY), DECAY);
        if (data.tick()) {
            data.func_76185_a();
        }
    }

    public static int getRefreshValue(UUID id) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(REFRESH), REFRESH);
        return data.getValue(id);
    }

    public static boolean isRefreshed(UUID id) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(REFRESH), REFRESH);
        return data.isDone(id);
    }

    public static void setRefreshing(UUID id, int decay) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(REFRESH), REFRESH);
        data.setValue(id, decay);
        data.func_76185_a();
    }

    public static void removeRefreshed(UUID id) {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(REFRESH), REFRESH);
        if (data.removeDone(id) != -1) {
            data.func_76185_a();
        }
    }

    public static void doRefresh() {
        MapStorage manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        TickingData data = DataStorage.computeIfAbsentManager(manager, () -> new TickingData(REFRESH), REFRESH);
        if (data.tick()) {
            data.func_76185_a();
        }
    }

    public static WorldServer getWorldServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
    }

    public static ChestData getInstanceUuid(WorldServer world, UUID id, BlockPos position) {
        int dimension = world.field_73011_w.getDimension();
        return ChestData.unwrap(DataStorage.computeIfAbsentManager(DataStorage.getWorldServer().func_175693_T(), () -> new ChestData(dimension, id), ChestData.ID(id)), dimension, position);
    }

    public static ChestData getInstance(WorldServer world, UUID id, BlockPos pos) {
        return ChestData.unwrap(DataStorage.computeIfAbsentManager(DataStorage.getWorldServer().func_175693_T(), () -> new ChestData(id), ChestData.ID(id)), world.field_73011_w.getDimension(), pos);
    }

    public static ChestData getInstanceInventory(WorldServer world, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base, BlockPos pos) {
        int dimension = world.field_73011_w.getDimension();
        return ChestData.unwrap(DataStorage.computeIfAbsentManager(DataStorage.getWorldServer().func_175693_T(), () -> new ChestData(dimension, id, customId, base), ChestData.ID(id)), world.field_73011_w.getDimension(), pos);
    }

    public static boolean clearInventories(UUID uuid) {
        WorldServer world = DataStorage.getWorldServer();
        MapStorage data = world.func_175693_T();
        Path dataPath = world.func_72860_G().func_75765_b().toPath().resolve("data").resolve("lootr");
        ArrayList ids = new ArrayList();
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(o -> {
                if (Files.isRegularFile(o, new LinkOption[0])) {
                    String fileName = o.getFileName().toString();
                    if (fileName.startsWith("Lootr-")) {
                        return;
                    }
                    ids.add("lootr/" + fileName.charAt(0) + "/" + fileName.substring(0, 2) + "/" + fileName.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        int cleared = 0;
        for (String id : ids) {
            ChestData chestData = (ChestData)data.func_75742_a(ChestData.class, id);
            if (chestData == null || !chestData.clearInventory(uuid)) continue;
            ++cleared;
            chestData.func_76185_a();
        }
        Lootr.LOG.info("Cleared " + cleared + " inventories for play UUID " + uuid.toString());
        return cleared != 0;
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, UUID uuid, BlockPos pos, EntityPlayerMP player, TileEntityLockableLoot tile, LootFiller filler) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        ChestData data = DataStorage.getInstanceUuid((WorldServer)world, uuid, pos);
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, tile);
        }
        inventory.setBlockPos(pos);
        return inventory;
    }

    public static void refreshInventory(World world, UUID uuid, EntityPlayerMP player, BlockPos pos) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        ChestData data = DataStorage.getInstanceUuid((WorldServer)world, uuid, pos);
        data.clear();
        data.func_76185_a();
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, UUID uuid, NonNullList<ItemStack> base, EntityPlayerMP player, BlockPos pos, TileEntityLockableLoot tile) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        ChestData data = DataStorage.getInstanceInventory((WorldServer)world, uuid, null, base, pos);
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, data.customInventory(), tile);
        }
        inventory.setBlockPos(pos);
        return inventory;
    }

    @Nullable
    public static void refreshInventory(World world, UUID uuid, NonNullList<ItemStack> base, EntityPlayerMP player, BlockPos pos) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        ChestData data = DataStorage.getInstanceInventory((WorldServer)world, uuid, null, base, pos);
        data.clear();
        data.func_76185_a();
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, LootrChestMinecartEntity cart, EntityPlayerMP player, LootFiller filler, BlockPos position) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        ChestData data = DataStorage.getInstance((WorldServer)world, cart.func_110124_au(), position);
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, null);
        }
        inventory.setBlockPos(position);
        return inventory;
    }

    @Nullable
    public static void refreshInventory(World world, LootrChestMinecartEntity cart, EntityPlayerMP player, BlockPos pos) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        ChestData data = DataStorage.getInstance((WorldServer)world, cart.func_110124_au(), pos);
        data.clear();
        data.func_76185_a();
    }
}

