/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noobanidus.mods.lootr.api.inventory.ILootrInventory;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class SpecialChestInventory
implements ILootrInventory {
    private final ChestData chestData;
    private final NonNullList<ItemStack> contents;
    private final ITextComponent name;
    @Nullable
    private BlockPos pos;

    public SpecialChestInventory(ChestData chestData, NonNullList<ItemStack> contents, ITextComponent name, @Nullable BlockPos pos) {
        this.chestData = chestData;
        this.contents = contents;
        this.name = name;
        this.pos = pos;
    }

    public SpecialChestInventory(ChestData chestData, NBTTagCompound items, String componentAsJSON, BlockPos pos) {
        this.chestData = chestData;
        this.name = ITextComponent.Serializer.func_150699_a((String)componentAsJSON);
        this.contents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)items, this.contents);
        this.pos = pos;
    }

    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    @Nullable
    public TileEntityLockableLoot getTile(World world) {
        if (world == null || world.field_72995_K || this.pos == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof ILootTile) {
            return (TileEntityLockableLoot)te;
        }
        return null;
    }

    @Override
    @Nullable
    public LootrChestMinecartEntity getEntity(World world) {
        if (world == null || world.field_72995_K || this.chestData.getEntityId() == null) {
            return null;
        }
        if (!(world instanceof WorldServer)) {
            return null;
        }
        WorldServer serverWorld = (WorldServer)world;
        Entity entity = serverWorld.func_175733_a(this.chestData.getEntityId());
        if (entity instanceof LootrChestMinecartEntity) {
            return (LootrChestMinecartEntity)entity;
        }
        return null;
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.contents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack result = ItemStackHelper.func_188383_a(this.contents, (int)index);
        if (!result.func_190926_b()) {
            this.func_70296_d();
        }
        return result;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.chestData.func_76186_a(true);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174888_l() {
        this.contents.clear();
        this.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        return this.name;
    }

    @Nullable
    public Container func_174876_a(InventoryPlayer inventory, EntityPlayer player) {
        return new ContainerChest((IInventory)inventory, (IInventory)this, player);
    }

    public void func_174889_b(EntityPlayer player) {
        LootrChestMinecartEntity entity;
        World world = player.field_70170_p;
        TileEntityLockableLoot tile = this.getTile(world);
        if (tile != null) {
            tile.func_174889_b(player);
        }
        if (this.chestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        LootrChestMinecartEntity entity;
        TileEntityLockableLoot tile;
        this.func_70296_d();
        World world = player.field_70170_p;
        if (this.pos != null && (tile = this.getTile(world)) != null) {
            tile.func_174886_c(player);
        }
        if (this.chestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.func_174886_c(player);
        }
    }

    public NBTTagCompound writeItems() {
        NBTTagCompound result = new NBTTagCompound();
        return ItemStackHelper.func_191282_a((NBTTagCompound)result, this.contents);
    }

    public String writeName() {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)this.name);
    }

    @Override
    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public NonNullList<ItemStack> getInventoryContents() {
        return this.contents;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public String func_174875_k() {
        return "minecraft:chest";
    }

    public String func_70005_c_() {
        return this.name.func_150254_d();
    }

    public boolean func_145818_k_() {
        return this.name != null;
    }
}

