/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;

public class TickingData
extends WorldSavedData {
    private final Object2IntMap<UUID> tickMap = new Object2IntOpenHashMap();

    public TickingData(String id) {
        super(id);
        this.tickMap.defaultReturnValue(-1);
    }

    public boolean isDone(UUID id) {
        int val = this.tickMap.getInt((Object)id);
        return val == 0 || val == 1;
    }

    public int getValue(UUID id) {
        return this.tickMap.getInt((Object)id);
    }

    public boolean setValue(UUID id, int decayAmount) {
        return this.tickMap.put((Object)id, decayAmount) == -1;
    }

    public int removeDone(UUID id) {
        return this.tickMap.removeInt((Object)id);
    }

    public boolean tick() {
        if (this.tickMap.isEmpty()) {
            return false;
        }
        Object2IntOpenHashMap newMap = new Object2IntOpenHashMap();
        newMap.defaultReturnValue(-1);
        boolean changed = false;
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            int value = entry.getIntValue();
            if (value > 0) {
                --value;
                changed = true;
            }
            newMap.put((Object)((UUID)entry.getKey()), value);
        }
        if (changed) {
            this.tickMap.clear();
            this.tickMap.putAll((Map)newMap);
            return true;
        }
        return false;
    }

    public void func_76184_a(NBTTagCompound pCompound) {
        this.tickMap.clear();
        this.tickMap.defaultReturnValue(-1);
        NBTTagList decayList = pCompound.func_150295_c("result", 10);
        for (int i = 0; i < decayList.func_74745_c(); ++i) {
            NBTTagCompound thisTag = decayList.func_150305_b(i);
            this.tickMap.put((Object)thisTag.func_186857_a("id"), thisTag.func_74762_e("value"));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound pCompound) {
        NBTTagList decayList = new NBTTagList();
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            NBTTagCompound thisTag = new NBTTagCompound();
            thisTag.func_186854_a("id", (UUID)entry.getKey());
            thisTag.func_74768_a("value", entry.getIntValue());
            decayList.func_74742_a((NBTBase)thisTag);
        }
        pCompound.func_74782_a("result", (NBTBase)decayList);
        return pCompound;
    }
}

