/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.entity;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.util.FakePlayer;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.entity.ILootCart;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.networking.OpenCart;
import noobanidus.mods.lootr.networking.PacketHandler;
import noobanidus.mods.lootr.util.ChestUtil;

public class LootrChestMinecartEntity
extends EntityMinecartContainer
implements ILootCart {
    private final Set<UUID> openers = new HashSet<UUID>();
    private boolean opened = false;
    private static final IBlockState cartNormal = ModBlocks.CHEST.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH);

    public LootrChestMinecartEntity(World worldIn) {
        super(worldIn);
    }

    public LootrChestMinecartEntity(World worldIn, double x, double y, double z) {
        super(worldIn);
        this.func_70107_b(x, y, z);
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void addOpener(EntityPlayer player) {
        this.openers.add(player.func_110124_au());
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened() {
        this.opened = true;
    }

    public void setClosed() {
        this.opened = false;
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.func_190530_aW() && source != DamageSource.field_76380_i) {
            return true;
        }
        if (source.func_76346_g() instanceof FakePlayer) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if ((ConfigManager.DISABLE_BREAK && player.func_184812_l_() || !ConfigManager.DISABLE_BREAK) && source.func_76346_g().func_70093_af()) {
                return false;
            }
        } else {
            return true;
        }
        source.func_76346_g().func_145747_a(new TextComponentTranslation("lootr.message.cart_should_sneak", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
        source.func_76346_g().func_145747_a(new TextComponentTranslation("lootr.message.should_sneak2", new Object[]{new TextComponentTranslation("lootr.message.cart_should_sneak3", new Object[0]).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)))}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
        return true;
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack itemstack = new ItemStack(Items.field_151143_au);
            ItemStack itemstack2 = new ItemStack(Item.func_150898_a((Block)Blocks.field_150486_ae));
            if (this.func_145818_k_()) {
                itemstack.func_151001_c(this.func_95999_t());
                itemstack2.func_151001_c(this.func_95999_t());
            }
            this.func_70099_a(itemstack, 0.0f);
            this.func_70099_a(itemstack2, 0.0f);
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public IBlockState func_180457_u() {
        return cartNormal;
    }

    public int func_94085_r() {
        return 8;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.field_184290_c != null) {
            compound.func_74778_a("LootTable", this.field_184290_c.toString());
        }
        compound.func_74772_a("LootTableSeed", this.field_184291_d);
        NBTTagList list = new NBTTagList();
        for (UUID opener : this.openers) {
            list.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)opener));
        }
        compound.func_74782_a("LootrOpeners", (NBTBase)list);
        super.func_70014_b(compound);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_184290_c = new ResourceLocation(compound.func_74779_i("LootTable"));
        this.field_184291_d = compound.func_74763_f("LootTableSeed");
        if (compound.func_150297_b("LootrOpeners", 9)) {
            NBTTagList openers = compound.func_150295_c("LootrOpeners", 10);
            this.openers.clear();
            for (NBTBase item : openers) {
                this.openers.add(NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)item)));
            }
        }
        super.func_70037_a(compound);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (player.func_70093_af()) {
            ChestUtil.handleLootCartSneak(player.field_70170_p, this, player);
            return true;
        }
        ChestUtil.handleLootCart(player.field_70170_p, this, player);
        return true;
    }

    public void addLoot(@Nullable EntityPlayer player, IInventory inventory, @Nullable ResourceLocation overrideTable, long seed) {
        if (this.field_184290_c != null && this.field_70170_p.func_73046_m() != null) {
            LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(overrideTable != null ? overrideTable : this.field_184290_c);
            if (loottable == LootTable.field_186464_a) {
                Lootr.LOG.error("Unable to fill loot cart in " + this.field_70170_p + " at " + this.func_180425_c() + " as the loot table '" + (overrideTable != null ? overrideTable : this.field_184290_c) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
            }
            long theSeed = ConfigManager.RANDOMISE_SEED ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.field_184291_d : seed);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_70170_p);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            Random random = theSeed == 0L ? new Random() : new Random(theSeed);
            loottable.func_186460_a(inventory, random, builder.func_186471_a());
        }
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            OpenCart cart = new OpenCart(this.func_145782_y());
            PacketHandler.sendToInternal(cart, (EntityPlayerMP)player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            this.addOpener(player);
        }
    }

    public String func_174875_k() {
        return "minecraft:chest";
    }

    public void func_184288_f(EntityPlayer player) {
    }
}

