/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.event;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.networking.OpenCart;
import noobanidus.mods.lootr.networking.PacketHandler;

@Mod.EventBusSubscriber(modid="lootr")
public class HandleCart {
    private static Set<Chunk> loadedChunks = Collections.newSetFromMap(new WeakHashMap());

    @SubscribeEvent
    public static void chunkLoad(ChunkEvent.Load event) {
        loadedChunks.add(event.getChunk());
    }

    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload event) {
        loadedChunks.remove(event.getChunk());
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityMinecartChest) {
            EntityMinecartChest chest = (EntityMinecartChest)event.getEntity();
            if (!chest.field_70170_p.field_72995_K && chest.field_184290_c != null && ConfigManager.CONVERT_MINESHAFTS && !ConfigManager.isBlacklisted(chest.field_184290_c)) {
                LootrChestMinecartEntity lootr = new LootrChestMinecartEntity(chest.field_70170_p, chest.field_70165_t, chest.field_70163_u, chest.field_70161_v);
                lootr.func_184289_a(chest.field_184290_c, chest.field_184291_d);
                int chunkX = MathHelper.func_76128_c((double)chest.field_70165_t) >> 4;
                int chunkZ = MathHelper.func_76128_c((double)chest.field_70161_v) >> 4;
                Chunk chunk = chest.field_70170_p.func_72964_e(chunkX, chunkZ);
                if (loadedChunks.contains(chunk)) {
                    chest.field_70170_p.func_72838_d((Entity)lootr);
                } else {
                    chunk.func_76612_a((Entity)lootr);
                }
                event.setCanceled(true);
                chest.field_94112_b = false;
                chest.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTrack(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target instanceof LootrChestMinecartEntity) {
            EntityPlayer player = event.getEntityPlayer();
            if (((LootrChestMinecartEntity)event.getTarget()).getOpeners().contains(player.func_110124_au())) {
                OpenCart cart = new OpenCart(event.getTarget().func_145782_y());
                PacketHandler.sendToInternal(cart, (EntityPlayerMP)player);
            }
        }
    }
}

