/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.mixins;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.event.HandleWorldGen;
import org.dimdev.dimdoors.shared.pockets.PocketTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PocketTemplate.class})
public class MixinPocketTemplate {
    @Redirect(method={"setup"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/loot/LootTable;fillInventory(Lnet/minecraft/inventory/IInventory;Ljava/util/Random;Lnet/minecraft/world/storage/loot/LootContext;)V"))
    private void fillViaLootr(LootTable table, IInventory inventory, Random random, LootContext context) {
        ResourceLocation tableLoc;
        if (inventory instanceof TileEntityChest && !ConfigManager.isBlacklisted(tableLoc = new ResourceLocation("dimdoors:dungeon_chest"))) {
            BlockPos pos = ((TileEntity)inventory).func_174877_v();
            WorldServer world = context.getWorld();
            IBlockState replacement = ConfigManager.replacement(world.func_180495_p(pos));
            if (replacement != null) {
                TileEntity lootrChest = HandleWorldGen.replaceOldLootBlockAt(world.func_175726_f(pos), pos, replacement);
                if (lootrChest instanceof ILootTile) {
                    ((TileEntityLockableLoot)lootrChest).func_189404_a(tableLoc, random.nextLong());
                } else {
                    Lootr.LOG.error("replacement TE " + lootrChest + " is not an ILootTile dim " + world.field_73011_w.getDimension() + " at " + pos);
                }
                return;
            }
        }
        table.func_186460_a(inventory, random, context);
    }
}

