/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ArtefactCondition
implements LootCondition {
    private final String requiredArtefact;
    private final boolean invert;

    public ArtefactCondition(String requiredArtefact, boolean invert) {
        this.requiredArtefact = requiredArtefact;
        this.invert = invert;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        EntityPlayer player = (EntityPlayer)context.func_186495_b();
        Item artefact = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.requiredArtefact));
        if (artefact == null) {
            Wizardry.logger.warn("Couldn't locate required artefact item in loottable condition!");
        } else if (player != null) {
            boolean isActive = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)artefact);
            if (this.invert) {
                return !isActive;
            }
            return isActive;
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ArtefactCondition> {
        public Serializer() {
            super(new ResourceLocation("wizardryutils", "artefact_condition"), ArtefactCondition.class);
        }

        public void serialize(JsonObject json, ArtefactCondition value, JsonSerializationContext context) {
            json.addProperty("required_artefact", value.requiredArtefact);
            json.addProperty("invert", Boolean.valueOf(value.invert));
        }

        public ArtefactCondition deserialize(JsonObject object, JsonDeserializationContext context) {
            String requiredArtefact = JsonUtils.func_151200_h((JsonObject)object, (String)"required_artefact");
            boolean invert = JsonUtils.func_151209_a((JsonObject)object, (String)"invert", (boolean)false);
            return new ArtefactCondition(requiredArtefact, invert);
        }
    }
}

