/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.registry;

import com.windanesz.wizardryutils.WizardryUtils;
import com.windanesz.wizardryutils.item.ItemDustyArtefact;
import com.windanesz.wizardryutils.item.ItemDustyCasket;
import com.windanesz.wizardryutils.item.ItemDustySpellBook;
import com.windanesz.wizardryutils.item.ItemNewArtefact;
import com.windanesz.wizardryutils.registry.LootRegistry;
import electroblob.wizardry.registry.WizardryTabs;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="wizardryutils")
@Mod.EventBusSubscriber
public final class ItemRegistry {
    public static final Item dusty_amulet = (Item)ItemRegistry.placeholder();
    public static final Item dusty_ring = (Item)ItemRegistry.placeholder();
    public static final Item dusty_charm = (Item)ItemRegistry.placeholder();
    public static final Item dusty_headgear = (Item)ItemRegistry.placeholder();
    public static final Item dusty_spell_book = (Item)ItemRegistry.placeholder();
    public static final Item dusty_casket = (Item)ItemRegistry.placeholder();

    private ItemRegistry() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (FMLLaunchHandler.isDeobfuscatedEnvironment()) {
            WizardryUtils.logger.info("Registering debug artefact items...");
            ItemRegistry.registerItemArtefact((IForgeRegistry<Item>)registry, "head_test", "wizardryutils", new ItemNewArtefact(EnumRarity.UNCOMMON, ItemNewArtefact.Type.HEAD));
            ItemRegistry.registerItemArtefact((IForgeRegistry<Item>)registry, "belt_test", "wizardryutils", new ItemNewArtefact(EnumRarity.RARE, ItemNewArtefact.Type.BELT));
            ItemRegistry.registerItemArtefact((IForgeRegistry<Item>)registry, "body_test", "wizardryutils", new ItemNewArtefact(EnumRarity.EPIC, ItemNewArtefact.Type.BODY));
        }
        ItemRegistry.registerItem((IForgeRegistry<Item>)registry, "dusty_amulet", "wizardryutils", new ItemDustyArtefact("amulet"));
        ItemRegistry.registerItem((IForgeRegistry<Item>)registry, "dusty_ring", "wizardryutils", new ItemDustyArtefact("ring"));
        ItemRegistry.registerItem((IForgeRegistry<Item>)registry, "dusty_charm", "wizardryutils", new ItemDustyArtefact("charm"));
        ItemRegistry.registerItem((IForgeRegistry<Item>)registry, "dusty_headgear", "wizardryutils", new ItemDustyArtefact("head"));
        ItemRegistry.registerItem((IForgeRegistry<Item>)registry, "dusty_belt", "wizardryutils", new ItemDustyArtefact("belt"));
        ItemRegistry.registerItem((IForgeRegistry<Item>)registry, "dusty_spell_book", "wizardryutils", new ItemDustySpellBook());
        ItemRegistry.registerItem((IForgeRegistry<Item>)registry, "dusty_casket", "wizardryutils", new ItemDustyCasket());
    }

    @Nonnull
    public static <T> T placeholder() {
        return null;
    }

    public static void registerItemArtefact(IForgeRegistry<Item> registry, String name, String modid, Item item) {
        ItemRegistry.registerItemArtefact(registry, name, modid, item, true);
    }

    public static void registerItemArtefact(IForgeRegistry<Item> registry, String name, String modid, Item item, boolean addToLoot) {
        ItemRegistry.registerItem(registry, name, modid, item, false);
        if (addToLoot) {
            LootRegistry.addArtefact(item);
        }
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, String modid, Item item) {
        ItemRegistry.registerItem(registry, name, modid, item, false);
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, String modid, Item item, boolean setTabIcon) {
        item.setRegistryName(modid, name);
        item.func_77655_b(item.getRegistryName().toString());
        registry.register((IForgeRegistryEntry)item);
        if (setTabIcon && item.func_77640_w() instanceof WizardryTabs.CreativeTabSorted) {
            ((WizardryTabs.CreativeTabSorted)item.func_77640_w()).setIconItem(new ItemStack(item));
        }
        if (item.func_77640_w() instanceof WizardryTabs.CreativeTabListed) {
            ((WizardryTabs.CreativeTabListed)item.func_77640_w()).order.add(item);
        }
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        Item itemblock = (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)itemblock);
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block, Item itemblock) {
        itemblock.setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)itemblock);
    }
}

