/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.common;

import c4.colytra.common.config.ConfigHandler;
import c4.colytra.common.items.ItemElytraBauble;
import c4.colytra.proxy.CommonProxy;
import c4.colytra.util.ColytraUtil;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CommonEventHandler {
    @SubscribeEvent
    public void onPlayerXPPickUp(PlayerPickupXpEvent e) {
        ItemStack colytra;
        if (!e.getEntityPlayer().field_70170_p.field_72995_K && (colytra = ColytraUtil.wornElytra(e.getEntityLiving())) != ItemStack.field_190927_a && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)colytra) > 0) {
            int durability;
            boolean isBauble = colytra.func_77973_b() instanceof ItemElytraBauble;
            if (isBauble) {
                durability = colytra.func_77958_k() - colytra.func_77952_i();
            } else {
                if (ConfigHandler.durabilityMode != ConfigHandler.DurabilityMode.NORMAL) {
                    return;
                }
                durability = colytra.func_179543_a("Elytra Upgrade").func_74762_e("Durability");
            }
            if (durability >= 432) {
                return;
            }
            e.setCanceled(true);
            EntityXPOrb xpOrb = e.getOrb();
            EntityPlayer player = e.getEntityPlayer();
            if (xpOrb.field_70532_c == 0 && player.field_71090_bL == 0) {
                player.field_71090_bL = 2;
                player.func_71001_a((Entity)xpOrb, 1);
                int i = Math.min(CommonEventHandler.xpToDurability(xpOrb.field_70530_e), 432 - durability);
                xpOrb.field_70530_e -= CommonEventHandler.durabilityToXp(i);
                if (isBauble) {
                    colytra.func_77964_b(colytra.func_77958_k() - (durability + i));
                } else {
                    colytra.func_179543_a("Elytra Upgrade").func_74768_a("Durability", durability + i);
                }
                if (xpOrb.field_70530_e > 0) {
                    player.func_71023_q(xpOrb.field_70530_e);
                }
                xpOrb.func_70106_y();
            }
        }
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void anvilUpdate(AnvilUpdateEvent evt) {
        boolean isChestplate;
        ItemStack left = evt.getLeft();
        boolean bl = isChestplate = EntityLiving.func_184640_d((ItemStack)left) == EntityEquipmentSlot.CHEST;
        boolean isAllowed = ConfigHandler.permissionMode == ConfigHandler.PermissionMode.BLACKLIST ? !ColytraUtil.itemList.contains(left.func_77973_b()) : ColytraUtil.itemList.contains(left.func_77973_b());
        if (isChestplate) {
            ItemStack right = evt.getRight();
            if (right.func_77973_b() instanceof ItemElytra && !(left.func_77973_b() instanceof ItemElytra) && isAllowed && !ColytraUtil.hasElytraUpgrade(left)) {
                CommonEventHandler.handleElytraUpgrade(evt);
            }
            if (ColytraUtil.hasElytraUpgrade(left) && right.func_77973_b() == Items.field_151116_aA) {
                CommonEventHandler.handleLeatherRepair(evt);
            }
        }
    }

    private static void handleElytraUpgrade(AnvilUpdateEvent evt) {
        ItemStack chestplate = evt.getLeft();
        ItemStack elytra = evt.getRight();
        ItemStack output = CommonEventHandler.handleEnchantments(evt);
        NBTTagCompound compound = output.func_190925_c("Elytra Upgrade");
        compound.func_74768_a("Active", 1);
        compound.func_74768_a("Durability", elytra.func_77958_k() - elytra.func_77952_i());
        output.func_82841_c(Math.max(chestplate.func_82838_A(), elytra.func_82838_A()) * 2 + 1);
        int xpCost = 30;
        if (evt.getName() != null && !evt.getName().isEmpty() && !evt.getName().equals(chestplate.func_82833_r())) {
            output.func_151001_c(evt.getName());
            ++xpCost;
        }
        if (CommonProxy.quarkLoaded) {
            CommonEventHandler.copyElytraColor(output, elytra);
        }
        evt.setCost(xpCost);
        evt.setOutput(output);
    }

    private static void handleLeatherRepair(AnvilUpdateEvent evt) {
        ItemStack colytra = evt.getLeft();
        ItemStack leather = evt.getRight();
        int maxDurability = 432;
        int durability = colytra.func_179543_a("Elytra Upgrade").func_74762_e("Durability");
        int toRepair = maxDurability - durability;
        if (toRepair == 0) {
            return;
        }
        int leatherToUse = 0;
        while (toRepair > 0) {
            toRepair -= 108;
            ++leatherToUse;
        }
        leatherToUse = Math.min(leatherToUse, leather.func_190916_E());
        int newDurability = Math.min(durability + leatherToUse * 108, maxDurability);
        ItemStack output = colytra.func_77946_l();
        output.func_179543_a("Elytra Upgrade").func_74768_a("Durability", newDurability);
        output.func_82841_c(colytra.func_82838_A() * 2 + 1);
        int xpCost = leatherToUse + colytra.func_82838_A() + leather.func_82838_A();
        if (!evt.getName().isEmpty() && !evt.getName().equals(colytra.func_82833_r())) {
            output.func_151001_c(evt.getName());
            ++xpCost;
        }
        evt.setMaterialCost(leatherToUse);
        evt.setCost(xpCost);
        evt.setOutput(output);
    }

    private static ItemStack handleEnchantments(AnvilUpdateEvent evt) {
        ItemStack chestplate = evt.getLeft();
        ItemStack elytra = evt.getRight();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)chestplate);
        Map map1 = EnchantmentHelper.func_82781_a((ItemStack)elytra);
        boolean flag2 = false;
        boolean flag3 = false;
        for (Enchantment enchantment1 : map1.keySet()) {
            int j2;
            if (enchantment1 == null) continue;
            int i2 = map.getOrDefault(enchantment1, 0);
            j2 = i2 == (j2 = ((Integer)map1.get(enchantment1)).intValue()) ? j2 + 1 : Math.max(j2, i2);
            boolean flag1 = enchantment1.func_92089_a(chestplate);
            for (Enchantment enchantment : map.keySet()) {
                if (enchantment == enchantment1 || enchantment1.func_191560_c(enchantment)) continue;
                flag1 = false;
            }
            if (!flag1) {
                flag3 = true;
                continue;
            }
            flag2 = true;
            if (j2 > enchantment1.func_77325_b()) {
                j2 = enchantment1.func_77325_b();
            }
            map.put(enchantment1, j2);
        }
        if (flag3 && !flag2) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = chestplate.func_77946_l();
        EnchantmentHelper.func_82782_a((Map)map, (ItemStack)output);
        return output;
    }

    @Optional.Method(modid="quark")
    private static void copyElytraColor(ItemStack output, ItemStack elytra) {
        if (elytra.func_77942_o() && elytra.func_77978_p().func_74764_b("quark:elytraDye")) {
            if (!output.func_77942_o()) {
                output.func_77982_d(new NBTTagCompound());
            }
            output.func_77978_p().func_74768_a("quark:elytraDye", elytra.func_77978_p().func_74762_e("quark:elytraDye"));
        }
    }
}

