/*
 * Decompiled with CFR 0.152.
 */
package com.shovinus.chopdownupdated;

import com.shovinus.chopdownupdated.command.CDUCommand;
import com.shovinus.chopdownupdated.config.Config;
import com.shovinus.chopdownupdated.config.TreeConfiguration;
import com.shovinus.chopdownupdated.tree.Tree;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod(modid="chopdownupdated", name="ChopDownUpdated", version="1.12.2-1.2.4", acceptedMinecraftVersions="[1.12.2]", acceptableRemoteVersions="*", guiFactory="com.shovinus.chopdownupdated.config.GuiConfigFactoryChopDown")
public class ChopDown {
    ExecutorService executor;
    public static final String MODID = "chopdownupdated";
    public static final String MODNAME = "ChopDownUpdated";
    public static final String VERSION = "1.12.2-1.2.4";
    public static final String AUTHOR = "Shovinus";
    public static LinkedList<Tree> FallingTrees = new LinkedList();
    static int tick = 0;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) throws Exception {
        Config.load(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CDUCommand());
        this.executor = Executors.newFixedThreadPool(2);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!Tree.isWood(pos, world) || !ArrayUtils.contains((Object[])Config.allowedPlayers, (Object)event.getPlayer().getClass().getName())) {
            return;
        }
        if (event.getPlayer().func_184614_ca() != null && Config.MatchesTool(Tree.stackName(event.getPlayer().func_184614_ca()))) {
            return;
        }
        TreeConfiguration config = Tree.findConfig(world, pos);
        BlockPos playerStanding = event.getPlayer().func_180425_c();
        if (config == null || !Tree.isTrunk(pos, world, config).booleanValue() || !Tree.isWood(pos.func_177982_a(0, 1, 0), world) || playerStanding.func_177958_n() == 0 && playerStanding.func_177952_p() == 0) {
            return;
        }
        for (Tree tree : FallingTrees) {
            if (tree.player != event.getPlayer()) continue;
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentString("Still chopping down the last tree"));
            event.setCanceled(true);
            return;
        }
        try {
            Tree tree = new Tree(pos, world, event.getPlayer());
            FallingTrees.add(tree);
            this.executor.submit(tree);
        }
        catch (Exception e) {
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentString("Can't find a tree configuration for this log."));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        try {
            if (++tick % 4 == 0) {
                tick = 0;
                for (Tree tree : FallingTrees) {
                    if (tree.finishedCalculation.booleanValue() && tree.dropBlocks()) {
                        FallingTrees.remove(tree);
                    }
                    if (!tree.failedToBuild.booleanValue()) continue;
                    FallingTrees.remove(tree);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error while continuing to chop trees");
        }
    }

    @SubscribeEvent
    public void clickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!(event.getEntityPlayer() instanceof EntityPlayerMP)) {
            return;
        }
        if (Config.getPlayerConfig((UUID)event.getEntityPlayer().func_110124_au()).showBlockName) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Block:" + Tree.blockName(pos, world)));
            if (event.getEntityPlayer().func_184614_ca() != null) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Tool:" + Tree.stackName(event.getEntityPlayer().func_184614_ca())));
            }
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Player Class:" + event.getEntityPlayer().getClass().getName()));
        }
    }
}

