/*
 * Decompiled with CFR 0.152.
 */
package com.shovinus.chopdownupdated.command;

import com.google.common.collect.Lists;
import com.shovinus.chopdownupdated.config.Config;
import com.shovinus.chopdownupdated.config.PersonalConfig;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CDUCommand
extends CommandBase {
    public String func_71517_b() {
        return "chopdownupdated";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"cdu"});
    }

    public String func_71518_a(ICommandSender sender) {
        if (sender == null || !(sender instanceof EntityPlayer) && !(sender instanceof EntityPlayerMP)) {
            return "";
        }
        return "cdu makeGlass/dontDrop/showBlockName/lowerLogs/breakLeaves[true/false]\n" + this.stateProperty(sender, "makeGlass") + ": Turn felled trees in to glass to view what we think a tree should look like\n" + this.stateProperty(sender, "dontDrop") + ": The blocks dont fall, but are placed in the air where we think they should go (when combined with breakGlass it just turns the tree in to glass)\n" + this.stateProperty(sender, "showBlockName") + ": Any time you click on a log or leaf it will show the name as accepted by the trees configuration so if you come across a missing tree you can add it to your configuration (And hopefully report it please!)\n" + this.stateProperty(sender, "breakLeaves") + ": Leaves are all broken and do their drops only logs fall\n";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        this.setBool(sender, args);
    }

    private boolean getValue(int setter, boolean previous) {
        switch (setter) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return !previous;
    }

    private void setBool(ICommandSender sender, String[] args) throws CommandException {
        String action = args[0];
        int value = 2;
        if (args.length > 1) {
            boolean desiredValue = CDUCommand.func_180527_d((String)args[1]);
            value = desiredValue ? 1 : 0;
        }
        if (!(sender.func_174793_f() instanceof EntityPlayerMP)) {
            return;
        }
        PersonalConfig playerConfig = Config.getPlayerConfig(((EntityPlayerMP)sender.func_174793_f()).func_110124_au());
        boolean setValue = true;
        if (action.equals("makeGlass")) {
            playerConfig.makeGlass = setValue = this.getValue(value, playerConfig.makeGlass);
        } else if (action.equals("dontDrop")) {
            playerConfig.dontFell = setValue = this.getValue(value, playerConfig.dontFell);
        } else if (action.equals("showBlockName")) {
            playerConfig.showBlockName = setValue = this.getValue(value, playerConfig.showBlockName);
        } else if (action.equals("breakLeaves")) {
            setValue = this.getValue(value, this.getMainConfigValue("breakLeaves"));
            this.setMainConfigValue("breakLeaves", setValue);
        } else {
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(action + (setValue ? " Enabled" : " Disabled"), new Object[0]));
    }

    public boolean getMainConfigValue(String config) {
        return Config.config.getCategory(Config.CATEGORY).get(config).getBoolean();
    }

    public void setMainConfigValue(String config, boolean value) {
        Config.config.getCategory(Config.CATEGORY).get(config).set(value);
        try {
            Config.reloadConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CDUCommand.func_71530_a((String[])args, (String[])new String[]{"makeGlass", "dontDrop", "showBlockName", "breakLeaves"});
        }
        if (args.length == 2) {
            return CDUCommand.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        return null;
    }

    private PersonalConfig getPlayerConfig(ICommandSender sender) {
        return Config.getPlayerConfig(((EntityPlayerMP)sender.func_174793_f()).func_110124_au());
    }

    private String stateProperty(ICommandSender sender, String property) {
        if (property.equals("makeGlass")) {
            return (this.getPlayerConfig((ICommandSender)sender).makeGlass ? "[x] " : "[ ] ") + "makeGlass";
        }
        if (property.equals("dontDrop")) {
            return (this.getPlayerConfig((ICommandSender)sender).dontFell ? "[x] " : "[ ] ") + "dontDrop";
        }
        if (property.equals("showBlockName")) {
            return (this.getPlayerConfig((ICommandSender)sender).showBlockName ? "[x] " : "[ ] ") + "showBlockName";
        }
        if (property.equals("breakLeaves")) {
            return (this.getMainConfigValue("breakLeaves") ? "[x] " : "[ ] ") + "breakLeaves";
        }
        return "";
    }
}

