/*
 * Decompiled with CFR 0.152.
 */
package com.shovinus.chopdownupdated.config;

import com.shovinus.chopdownupdated.config.TreeConfiguration;
import com.shovinus.chopdownupdated.config.mods.AbyssalCraft;
import com.shovinus.chopdownupdated.config.mods.AetherLegacy;
import com.shovinus.chopdownupdated.config.mods.BetterWithAddons;
import com.shovinus.chopdownupdated.config.mods.BiomesOPlenty;
import com.shovinus.chopdownupdated.config.mods.Cuisine;
import com.shovinus.chopdownupdated.config.mods.DefiledLands;
import com.shovinus.chopdownupdated.config.mods.ExtraTrees;
import com.shovinus.chopdownupdated.config.mods.Forestry;
import com.shovinus.chopdownupdated.config.mods.IndustrialCraft2;
import com.shovinus.chopdownupdated.config.mods.IntegratedDynamics;
import com.shovinus.chopdownupdated.config.mods.JurassiCraft;
import com.shovinus.chopdownupdated.config.mods.Natura;
import com.shovinus.chopdownupdated.config.mods.NaturalPledge;
import com.shovinus.chopdownupdated.config.mods.PamsHarvestCraft;
import com.shovinus.chopdownupdated.config.mods.Plants;
import com.shovinus.chopdownupdated.config.mods.PrimalCore;
import com.shovinus.chopdownupdated.config.mods.Rustic;
import com.shovinus.chopdownupdated.config.mods.SugiForest;
import com.shovinus.chopdownupdated.config.mods.Terra;
import com.shovinus.chopdownupdated.config.mods.Terraqueous;
import com.shovinus.chopdownupdated.config.mods.Thaumcraft;
import com.shovinus.chopdownupdated.config.mods.TheBetweenLands;
import com.shovinus.chopdownupdated.config.mods.TheErebus;
import com.shovinus.chopdownupdated.config.mods.TheMidnight;
import com.shovinus.chopdownupdated.config.mods.TheTwilightForest;
import com.shovinus.chopdownupdated.config.mods.Traverse;
import com.shovinus.chopdownupdated.config.mods.Treasure2;
import com.shovinus.chopdownupdated.config.mods.Tropicraft;
import com.shovinus.chopdownupdated.config.mods.Vanilla;
import com.shovinus.chopdownupdated.config.mods.VibrantJourneys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModTreeConfigurations {
    Map<String, TreeConfiguration[]> Mods = new HashMap<String, TreeConfiguration[]>();
    List<TreeConfiguration> UnifiedTreeConfigs = new ArrayList<TreeConfiguration>();

    public void AddMod(String name, TreeConfiguration ... trees) {
        this.Mods.put(name, trees);
    }

    public List<TreeConfiguration> ActivateMods(String[] mods) throws Exception {
        this.UnifiedTreeConfigs.clear();
        for (String mod : mods) {
            if (!this.Mods.containsKey(mod)) {
                throw new Exception("This mod does not exist:" + mod + " , this should not happen in live, sorry for any inconvience, please report to mod releaser");
            }
            this.MergeInTrees(this.Mods.get(mod));
        }
        if (this.Mods.containsKey("_Custom")) {
            this.MergeInTrees(this.Mods.get("_Custom"));
        }
        return this.UnifiedTreeConfigs;
    }

    private void MergeInTrees(TreeConfiguration[] trees) {
        for (TreeConfiguration newTree : trees) {
            if (this.compareTrees(newTree)) continue;
            this.UnifiedTreeConfigs.add(newTree.Clone());
        }
    }

    private boolean compareTrees(TreeConfiguration newTree) {
        for (TreeConfiguration currentTree : this.UnifiedTreeConfigs) {
            for (String newLog : newTree.Logs()) {
                if (!currentTree.Logs().contains(newLog)) continue;
                currentTree.Merge(newTree);
                return true;
            }
        }
        return false;
    }

    public ModTreeConfigurations() {
        this.Mods.put("Vanilla", Vanilla.Trees);
        this.Mods.put("AbyssalCraft", AbyssalCraft.Trees);
        this.Mods.put("AetherLegacy", AetherLegacy.Trees);
        this.Mods.put("BetterWithAddons", BetterWithAddons.Trees);
        this.Mods.put("BiomesOPlenty", BiomesOPlenty.Trees);
        this.Mods.put("Cuisine", Cuisine.Trees);
        this.Mods.put("DefiledLands", DefiledLands.Trees);
        this.Mods.put("ExtraTrees", ExtraTrees.Trees);
        this.Mods.put("Forestry", Forestry.Trees);
        this.Mods.put("IndustrialCraft2", IndustrialCraft2.Trees);
        this.Mods.put("IntegratedDynamics", IntegratedDynamics.Trees);
        this.Mods.put("JurassiCraft", JurassiCraft.Trees);
        this.Mods.put("Natura", Natura.Trees);
        this.Mods.put("NaturalPledge", NaturalPledge.Trees);
        this.Mods.put("PamsHarvestCraft", PamsHarvestCraft.Trees);
        this.Mods.put("Plants", Plants.Trees);
        this.Mods.put("PrimalCore", PrimalCore.Trees);
        this.Mods.put("Rustic", Rustic.Trees);
        this.Mods.put("SugiForest", SugiForest.Trees);
        this.Mods.put("Terra", Terra.Trees);
        this.Mods.put("Terraqueous", Terraqueous.Trees);
        this.Mods.put("Thaumcraft", Thaumcraft.Trees);
        this.Mods.put("TheBetweenLands", TheBetweenLands.Trees);
        this.Mods.put("TheErebus", TheErebus.Trees);
        this.Mods.put("TheMidnight", TheMidnight.Trees);
        this.Mods.put("TheTwilightForest", TheTwilightForest.Trees);
        this.Mods.put("Traverse", Traverse.Trees);
        this.Mods.put("Treasure2", Treasure2.Trees);
        this.Mods.put("Tropicraft", Tropicraft.Trees);
        this.Mods.put("VibrantJourneys", VibrantJourneys.Trees);
    }

    public void setCustomTrees(TreeConfiguration[] trees) {
        this.Mods.put("_Custom", trees);
    }
}

