/*
 * Decompiled with CFR 0.152.
 */
package com.shovinus.chopdownupdated.config;

import com.shovinus.chopdownupdated.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class TreeConfiguration {
    private int radius = 9;
    private int leaf_limit = 12;
    private int trunk_radius = 1;
    private int min_vertical_logs = 0;
    private List<String> logs;
    private List<String> leaves;
    private String[] leaves_merged;
    private String[] blocks = null;

    public int Radius() {
        return this.radius == 0 ? 9 : this.radius;
    }

    public int Leaf_limit() {
        return this.leaf_limit == 0 ? 12 : this.leaf_limit;
    }

    public int Trunk_Radius() {
        return this.trunk_radius == 0 ? 1 : this.trunk_radius;
    }

    public int Min_vertical_logs() {
        return this.min_vertical_logs;
    }

    public TreeConfiguration() {
    }

    public TreeConfiguration(int radius, int leaf_limit, int min_logs, int trunk_radius, String[] logs, String[] leaves) {
        this.radius = radius;
        this.leaf_limit = leaf_limit;
        this.trunk_radius = trunk_radius;
        this.logs = new ArrayList<String>(Arrays.asList(logs));
        this.leaves = new ArrayList<String>(Arrays.asList(leaves));
        this.min_vertical_logs = min_logs;
    }

    public TreeConfiguration(int radius, int leaf_limit, int min_logs, int trunk_radius) {
        this.radius = radius;
        this.leaf_limit = leaf_limit;
        this.trunk_radius = trunk_radius;
        this.min_vertical_logs = min_logs;
    }

    public TreeConfiguration setLogs(String ... logs) {
        this.logs = new ArrayList<String>(Arrays.asList(logs));
        return this;
    }

    public TreeConfiguration setLeaves(String ... leaves) {
        this.leaves = new ArrayList<String>(Arrays.asList(leaves));
        return this;
    }

    public boolean isLog(String name) {
        for (String block : this.logs) {
            if (!block.equals(name) && !name.matches(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf(String name) {
        for (String block : this.Leaves()) {
            if (!block.equals(name) && !name.matches(block)) continue;
            return true;
        }
        return false;
    }

    public List<String> Logs() {
        return this.logs;
    }

    public String[] Leaves() {
        if (this.leaves_merged == null) {
            this.leaves_merged = Config.MergeArray(Config.ConvertListToArray(this.leaves), Config.sharedLeaves);
        }
        return this.leaves_merged;
    }

    public String[] Blocks() {
        if (this.blocks == null) {
            this.blocks = (String[])ArrayUtils.addAll((Object[])Config.ConvertListToArray(this.logs), (Object[])this.Leaves());
        }
        return this.blocks;
    }

    public void Merge(TreeConfiguration newTree) {
        for (String log : newTree.Logs()) {
            if (this.logs.contains(log)) continue;
            this.logs.add(log);
        }
        for (String leaf : newTree.Leaves()) {
            if (this.leaves.contains(leaf)) continue;
            this.leaves.add(leaf);
        }
        this.leaves_merged = null;
    }

    public TreeConfiguration Clone() {
        return new TreeConfiguration(this.radius, this.leaf_limit, this.min_vertical_logs, this.trunk_radius, Config.ConvertListToArray(this.logs), Config.ConvertListToArray(this.leaves));
    }
}

