/*
 * Decompiled with CFR 0.152.
 */
package com.shovinus.chopdownupdated.tree;

import com.shovinus.chopdownupdated.config.Config;
import com.shovinus.chopdownupdated.config.PersonalConfig;
import com.shovinus.chopdownupdated.config.TreeConfiguration;
import com.shovinus.chopdownupdated.tree.AxisComparer;
import com.shovinus.chopdownupdated.tree.BuilderQueueComparer;
import com.shovinus.chopdownupdated.tree.DirectionSort;
import com.shovinus.chopdownupdated.tree.EnumFallAxis;
import com.shovinus.chopdownupdated.tree.TreeMovePair;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Tree
implements Runnable {
    BlockPos base;
    public World world;
    public EntityPlayer player;
    Boolean main = false;
    LinkedList<BlockPos> queue = new LinkedList();
    HashMap<BlockPos, Integer> estimatedTree = new HashMap();
    LinkedList<BlockPos> estimatedTreeQueue = new LinkedList();
    LinkedList<BlockPos> realisticTree = new LinkedList();
    HashMap<BlockPos, TreeMovePair> fallingBlocks = new HashMap();
    LinkedList<BlockPos> fallingBlocksList;
    int fallX = 1;
    int fallZ = 0;
    int fallOffset = 0;
    EnumFallAxis axis = EnumFallAxis.X;
    TreeConfiguration config;
    int radius = 8;
    int leafLimit = 7;
    boolean wentUp = false;
    public Boolean finishedCalculation = false;
    public Boolean failedToBuild = false;
    LinkedList<Tree> nearbyTrees = new LinkedList();

    public Tree(BlockPos pos, World world) throws Exception {
        this.initTree(pos, world);
        while (this.isLog(pos.func_177982_a(0, -1, 0))) {
            pos = pos.func_177982_a(0, -1, 0);
        }
        this.base = pos;
        this.getPossibleTree();
    }

    public Tree(BlockPos pos, World world, EntityPlayer player) throws Exception {
        this.main = true;
        this.player = player;
        this.initTree(pos, world);
        this.getFallDirection(player);
    }

    public static TreeConfiguration findConfig(World world, BlockPos pos) {
        for (TreeConfiguration treeConfig : Config.treeConfigurations) {
            if (!treeConfig.isLog(Tree.blockName(pos, world))) continue;
            return treeConfig;
        }
        return null;
    }

    private void initTree(BlockPos pos, World world) throws Exception {
        this.base = pos;
        this.world = world;
        this.addEstimateBlock(this.base, 0);
        this.config = Tree.findConfig(world, pos);
        if (this.config == null) {
            System.out.println(Tree.blockName(this.base, world) + " block has no tree configuration");
            throw new Exception("The chopped log type is unknown and not setup");
        }
        this.radius = this.config.Radius();
        this.leafLimit = this.config.Leaf_limit();
    }

    private void getFallDirection(EntityPlayer player) {
        Double x = (double)this.base.func_177958_n() + 0.5 - player.field_70165_t;
        Double z = (double)this.base.func_177952_p() + 0.5 - player.field_70161_v;
        Double abX = Math.abs(x);
        Double abZ = Math.abs(z);
        this.fallX = (int)Math.floor(abX / x);
        this.fallZ = (int)Math.floor(abZ / z);
        if (abX > abZ) {
            this.fallZ = 0;
            this.axis = EnumFallAxis.Z;
        } else {
            this.fallX = 0;
            this.axis = EnumFallAxis.X;
        }
    }

    public boolean isLog(BlockPos pos) {
        return this.isLog(Tree.blockName(pos, this.world));
    }

    private boolean isLog(String name) {
        return this.config.isLog(name);
    }

    public boolean isLeaf(BlockPos pos) {
        return this.isLeaf(Tree.blockName(pos, this.world));
    }

    private boolean isLeaf(String name) {
        return this.config.isLeaf(name);
    }

    private void getPossibleTree() throws Exception {
        BuilderQueueComparer comp = new BuilderQueueComparer(this.estimatedTree);
        while (!this.queue.isEmpty()) {
            Collections.sort(this.queue, comp);
            BlockPos blockStep = this.queue.pollFirst();
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        Integer leafStep;
                        int dzA = dz * dz;
                        int dxA = dx * dx;
                        int dyA = dy * dy;
                        int stepInc = dzA + dxA + dyA;
                        BlockPos inspectPos = blockStep.func_177982_a(dx, dy, dz);
                        String blockName = Tree.blockName(inspectPos, this.world);
                        boolean log = this.isLog(blockName);
                        boolean leaf = false;
                        if (!log) {
                            leaf = this.isLeaf(blockName);
                        }
                        if (!log && !leaf) continue;
                        boolean logAbove = this.isLog(inspectPos.func_177982_a(0, 1, 0));
                        int y = inspectPos.func_177956_o();
                        boolean isTrunk = Tree.isTrunk(inspectPos, this.world, this.config);
                        Boolean yMatch = y == this.base.func_177956_o();
                        if (y > this.base.func_177956_o()) {
                            this.wentUp = true;
                        }
                        if ((leafStep = this.getEstimate(blockStep)) == null) {
                            leafStep = 0;
                        }
                        leafStep = leafStep + (leaf ? stepInc : 0);
                        if (inspectPos.compareTo((Vec3i)this.base) == 0 || y < this.base.func_177956_o() || leafStep >= this.leafLimit || this.horizontalDistance(this.base, inspectPos) > (double)this.radius) continue;
                        if (!(!log || leafStep <= 0 && dy >= 0 || this.estimatedTree.containsKey(inspectPos) || !isTrunk || Math.abs(inspectPos.func_177958_n() - this.base.func_177958_n()) <= this.config.Trunk_Radius() && Math.abs(inspectPos.func_177952_p() - this.base.func_177952_p()) <= this.config.Trunk_Radius())) {
                            if (!this.main.booleanValue()) continue;
                            Boolean treeFound = false;
                            for (Tree tree : this.nearbyTrees) {
                                if (tree.getEstimate(inspectPos) == null || tree.getEstimate(inspectPos) != 0) continue;
                                treeFound = true;
                            }
                            if (treeFound.booleanValue()) continue;
                            Tree otherTree = new Tree(inspectPos, this.world);
                            this.nearbyTrees.add(otherTree);
                            continue;
                        }
                        if (this.main.booleanValue() && log && (leafStep > 0 || dy < 0) && !this.estimatedTree.containsKey(inspectPos) && isTrunk && this.isLog(inspectPos.func_177982_a(0, 1, 0))) {
                            this.estimatedTree.clear();
                            this.queue.clear();
                            return;
                        }
                        if (this.main.booleanValue() && log && (Tree.cantDrag(this.world, inspectPos, this.config) && !yMatch.booleanValue() || yMatch.booleanValue() && logAbove && !this.wentUp) && leafStep == 0) {
                            this.estimatedTree.clear();
                            this.queue.clear();
                            return;
                        }
                        if (yMatch.booleanValue() && Tree.cantDrag(this.world, inspectPos, this.config)) continue;
                        this.addEstimateBlock(inspectPos, leafStep);
                    }
                }
            }
        }
    }

    public void getDropBlocks() throws Exception {
        this.getPossibleTree();
        this.getRealisticTree();
        this.finishedCalculation = true;
    }

    private BlockPos repositionBlock(BlockPos pos) {
        int y = pos.func_177956_o() - this.base.func_177956_o();
        int x = pos.func_177958_n() - (this.base.func_177958_n() + this.fallOffset);
        int z = pos.func_177952_p() - (this.base.func_177952_p() + this.fallOffset);
        int changeX = this.fallZ * z;
        int changeZ = this.fallX * x;
        int normPosX = y * this.fallX;
        int normPosZ = y * this.fallZ;
        return pos.func_177982_a(normPosX - changeZ * this.fallX, -(changeX + changeZ), normPosZ - changeX * this.fallZ);
    }

    private TreeMovePair getLowerTargetBlock(BlockPos pos) {
        BlockPos lower = pos.func_177982_a(0, -1, 0);
        if (this.fallingBlocks.containsKey(lower)) {
            return this.fallingBlocks.get(lower);
        }
        return null;
    }

    public void addEstimateBlock(BlockPos pos, int step) {
        if (this.estimatedTree.containsKey(pos) && this.estimatedTree.get(pos) <= step) {
            return;
        }
        if (!this.queue.contains(pos)) {
            this.queue.add(pos);
        }
        this.estimatedTree.put(pos, step);
    }

    private Integer getEstimate(BlockPos pos) {
        return this.estimatedTree.get(pos);
    }

    public static String blockName(BlockPos pos, World world) {
        ItemStack stack = null;
        try {
            stack = world.func_180495_p(pos).func_177230_c().getPickBlock(world.func_180495_p(pos), null, world, pos, null);
        }
        catch (Exception ex) {
            try {
                stack = world.func_180495_p(pos).func_177230_c().func_185473_a(world, pos, world.func_180495_p(pos));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stack == null) {
            return "unknown, getPickBlock and getItem not set";
        }
        return Tree.stackName(stack);
    }

    public static String stackName(ItemStack stack) {
        try {
            ResourceLocation loc = stack.func_77973_b().getRegistryName();
            int damageValue = stack.func_77973_b().getDamage(stack);
            return loc.func_110624_b() + ":" + loc.func_110623_a() + ":" + String.valueOf(damageValue);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private void getRealisticTree() {
        BlockPos from;
        this.estimatedTreeQueue = new LinkedList<BlockPos>(this.estimatedTree.keySet());
        LinkedList<BlockPos> realisticTree = new LinkedList<BlockPos>();
        while (!this.estimatedTreeQueue.isEmpty()) {
            from = this.estimatedTreeQueue.pollFirst();
            Boolean mine = true;
            int leafStep = this.estimatedTree.get(from);
            double distance = this.horizontalDistance(this.base, from);
            if (distance > (double)this.config.Radius() || leafStep >= this.config.Leaf_limit()) continue;
            for (Tree otherTree : this.nearbyTrees) {
                if (!otherTree.myBlock(from, distance, leafStep).booleanValue()) continue;
                mine = false;
                break;
            }
            if (!mine.booleanValue() || this.base == from) continue;
            if (this.isLog(from) && (from.func_177956_o() == this.base.func_177956_o() + 1 || from.func_177956_o() == this.base.func_177956_o() + 2) && (this.fallZ != 0 && (this.isLog(from.func_177982_a(1, 0, 0)) || this.isLog(from.func_177982_a(-1, 0, 0))) || this.fallX != 0 && (this.isLog(from.func_177982_a(0, 0, 1)) || this.isLog(from.func_177982_a(0, 0, -1))))) {
                if (from.func_177958_n() * this.fallX > (this.fallOffset + this.base.func_177958_n()) * this.fallX) {
                    this.fallOffset = from.func_177958_n() - this.base.func_177958_n();
                } else if (from.func_177952_p() * this.fallZ > (this.fallOffset + this.base.func_177952_p()) * this.fallZ) {
                    this.fallOffset = from.func_177952_p() - this.base.func_177952_p();
                }
            }
            realisticTree.add(from);
        }
        while (!realisticTree.isEmpty()) {
            from = (BlockPos)realisticTree.pollFirst();
            BlockPos to = this.repositionBlock(from);
            TreeMovePair pair = new TreeMovePair(from, to, this);
            this.fallingBlocks.put(pair.to, pair);
        }
        this.fallingBlocksList = new LinkedList<BlockPos>(this.fallingBlocks.keySet());
        Collections.sort(this.fallingBlocksList, new AxisComparer(DirectionSort.UP));
    }

    @Override
    public void run() {
        try {
            this.getDropBlocks();
        }
        catch (Exception e) {
            this.failedToBuild = true;
        }
    }

    public boolean dropBlocks() {
        int blocksRemaining = Config.maxDropsPerTickPerTree;
        int size = this.fallingBlocksList.size();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = this.fallingBlocksList.getFirst();
            TreeMovePair pair = this.fallingBlocks.get(pos);
            this.fallingBlocksList.removeFirst();
            if (!this.drop(pair, this.fallingBlocks.size() > Config.maxFallingBlockBeforeManualMove)) {
                this.fallingBlocksList.add(pos);
            }
            if (--blocksRemaining > 0 || this.fallingBlocksList.isEmpty()) continue;
            return false;
        }
        return this.fallingBlocksList.isEmpty();
    }

    public Boolean myBlock(BlockPos pos, double yourDistance, int yourStepValue) {
        Integer step = this.estimatedTree.get(pos);
        if (step == null || step > yourStepValue) {
            return false;
        }
        if (step == yourStepValue) {
            return this.horizontalDistance(this.base, pos) < yourDistance;
        }
        return true;
    }

    private Boolean isAxis(IBlockState state, IProperty<?> property, String axis) {
        return ((Enum)state.func_177228_b().get(property)).name().equalsIgnoreCase(axis);
    }

    private IBlockState setAxis(IBlockState state, IProperty<?> property, String axis) {
        int i = 10;
        while (i > 0 && !this.isAxis(state, property, axis).booleanValue()) {
            --i;
            state = state.func_177231_a(property);
        }
        return state;
    }

    public IBlockState rotateLog(World world, IBlockState state) {
        IProperty foundProp = null;
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("axis")) continue;
            foundProp = prop;
        }
        if (foundProp == null) {
            return state;
        }
        if (this.axis == EnumFallAxis.X) {
            if (this.isAxis(state, foundProp, "Y").booleanValue()) {
                state = this.setAxis(state, foundProp, "Z");
            } else if (this.isAxis(state, foundProp, "Z").booleanValue()) {
                state = this.setAxis(state, foundProp, "Y");
            }
        } else if (this.isAxis(state, foundProp, "Y").booleanValue()) {
            state = this.setAxis(state, foundProp, "X");
        } else if (this.isAxis(state, foundProp, "X").booleanValue()) {
            state = this.setAxis(state, foundProp, "Y");
        }
        return state;
    }

    public static void dropDrops(BlockPos pos, BlockPos dropPos, IBlockState state, World world) {
        for (ItemStack stacky : state.func_177230_c().getDrops((IBlockAccess)world, pos, state, 0)) {
            EntityItem entityitem = new EntityItem(world, (double)dropPos.func_177958_n(), (double)dropPos.func_177956_o(), (double)dropPos.func_177952_p(), stacky);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    private boolean drop(TreeMovePair pair, Boolean UseSolid) {
        IBlockState state;
        if (!this.isLog(pair.from) && !this.isLeaf(pair.from)) {
            return true;
        }
        PersonalConfig playerConfig = Config.getPlayerConfig(this.player.func_110124_au());
        if (playerConfig.makeGlass && playerConfig.dontFell) {
            if (this.isLog(pair.from)) {
                this.world.func_175656_a(pair.from, Blocks.field_150399_cn.func_176203_a(1));
            } else {
                this.world.func_175656_a(pair.from, Blocks.field_150399_cn.func_176203_a(2));
            }
            return true;
        }
        IBlockState originalState = state = this.world.func_180495_p(pair.from);
        if (!pair.moved.booleanValue() && this.isLog(pair.from)) {
            state = this.rotateLog(this.world, state);
        }
        if (!this.CanMoveTo(pair.to, pair.leaves == false) && !pair.moved.booleanValue() || this.isLeaf(pair.from) && Config.breakLeaves) {
            Tree.dropDrops(pair.from, pair.to, state, this.world);
            this.world.func_175656_a(pair.from, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (!this.CanMoveTo(pair.to, pair.leaves == false)) {
            return true;
        }
        this.world.func_175656_a(pair.from, Blocks.field_150350_a.func_176223_P());
        pair.from = pair.to;
        pair.moved = true;
        if (playerConfig.dontFell) {
            pair.move();
        } else if (!UseSolid.booleanValue()) {
            EntityFallingBlock fallingBlock = new EntityFallingBlock(this.world, (double)pair.to.func_177958_n() + 0.5, (double)pair.to.func_177956_o() + 0.5, (double)pair.to.func_177952_p() + 0.5, state, pair.tile, pair.leaves == false);
            fallingBlock.func_174826_a(new AxisAlignedBB(pair.to.func_177982_a(0, 0, 0), pair.to.func_177982_a(1, 1, 1)));
            fallingBlock.field_145812_b = 1;
            this.world.func_72838_d((Entity)fallingBlock);
        } else {
            this.ManuallyDrop(pair, state);
        }
        return true;
    }

    private void ManuallyDrop(TreeMovePair pair, IBlockState state) {
        while (this.CanMoveTo(pair.to.func_177982_a(0, -1, 0), pair.leaves == false)) {
            pair.to = pair.to.func_177982_a(0, -1, 0);
            if (this.isAir(pair.to).booleanValue()) continue;
            IBlockState state2 = this.world.func_180495_p(pair.to);
            Tree.dropDrops(pair.from, pair.to, this.world.func_180495_p(pair.to), this.world);
            this.world.func_175656_a(pair.to, Blocks.field_150350_a.func_176223_P());
        }
        pair.move();
    }

    private boolean CanMoveTo(BlockPos pos, Boolean log) {
        return (this.isAir(pos) != false || this.isPassable(pos) != false || log != false && Tree.isLeaves(pos, this.world)) && pos.func_177956_o() > 0;
    }

    private double horizontalDistance(BlockPos pos1, BlockPos pos2) {
        int diffX = Math.abs(pos1.func_177958_n() - pos2.func_177958_n());
        int diffZ = Math.abs(pos1.func_177952_p() - pos2.func_177952_p());
        return Math.floor(Math.sqrt(Math.pow(diffX, 2.0) + Math.pow(diffZ, 2.0)));
    }

    public static final Boolean isTrunk(BlockPos pos, World world, TreeConfiguration config) {
        Boolean log = true;
        while (log.booleanValue()) {
            if (config.isLog(Tree.blockName(pos = pos.func_177982_a(0, -1, 0), world))) continue;
            log = false;
            if (Tree.isDraggable(world, pos, config)) continue;
            return true;
        }
        if (config.Min_vertical_logs() == 0) {
            return false;
        }
        int below = 0;
        for (int i = 1; i < config.Min_vertical_logs() && config.isLog(Tree.blockName(pos.func_177982_a(0, -i, 0), world)); ++i) {
            ++below;
        }
        int above = 0;
        for (int i = 1; i < config.Min_vertical_logs() && config.isLog(Tree.blockName(pos.func_177982_a(0, i, 0), world)); ++i) {
            ++above;
        }
        return 1 + below + above >= config.Min_vertical_logs();
    }

    private static boolean cantDrag(World world, BlockPos pos, TreeConfiguration tree) {
        return !Tree.isDraggable(world, pos.func_177982_a(1, 0, 0), tree) || !Tree.isDraggable(world, pos.func_177982_a(-1, 0, 0), tree) || !Tree.isDraggable(world, pos.func_177982_a(0, 1, 0), tree) || !Tree.isDraggable(world, pos.func_177982_a(0, -1, 0), tree) || !Tree.isDraggable(world, pos.func_177982_a(0, 0, 1), tree) || !Tree.isDraggable(world, pos.func_177982_a(0, 0, -1), tree);
    }

    private static boolean isDraggable(World world, BlockPos pos, TreeConfiguration tree) {
        String name;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().func_176205_b((IBlockAccess)world, pos)) {
            return true;
        }
        if (tree != null && (tree.isLog(name = Tree.blockName(pos, world)) || tree.isLeaf(name))) {
            return true;
        }
        return Tree.isWood(pos, world) || Tree.isLeaves(pos, world);
    }

    public Boolean isAir(BlockPos pos) {
        return this.world.func_180495_p(pos).func_177230_c().isAir(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos);
    }

    private Boolean isPassable(BlockPos pos) {
        return this.world.func_180495_p(pos).func_177230_c().func_176205_b((IBlockAccess)this.world, pos);
    }

    public static boolean isWood(BlockPos pos, World world) {
        String blockName = Tree.blockName(pos, world);
        for (String block : Config.logs) {
            if (!block.equals(blockName) && !blockName.matches(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLeaves(BlockPos pos, World world) {
        String blockName = Tree.blockName(pos, world);
        for (String block : Config.leaves) {
            if (!block.equals(blockName) && !blockName.matches(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaves(BlockPos pos) {
        return Tree.isLeaves(pos, this.world);
    }

    public static class EntityFallingBlock
    extends net.minecraft.entity.item.EntityFallingBlock {
        private boolean isLog = true;

        EntityFallingBlock(World worldIn, double x, double y, double z, IBlockState fallingBlockState, TileEntity tile, Boolean isLog) {
            super(worldIn, x, y, z, fallingBlockState);
            this.isLog = isLog;
            this.func_145806_a(true);
            if (tile != null) {
                this.field_145810_d = tile.func_189515_b(new NBTTagCompound());
            }
        }

        @Nullable
        public void func_70071_h_() {
            Block block = this.func_175131_l().func_177230_c();
            if (this.func_175131_l().func_185904_a() == Material.field_151579_a) {
                this.func_70106_y();
            } else {
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                if (this.field_145812_b++ == 0) {
                    BlockPos blockpos = new BlockPos((Entity)this);
                    if (this.field_70170_p.func_180495_p(blockpos).func_177230_c() == block) {
                        this.field_70170_p.func_175698_g(blockpos);
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.func_70106_y();
                        return;
                    }
                }
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= (double)0.04f;
                }
                BlockPos targetBlock = new BlockPos(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                if (this.isLog) {
                    for (int i = 0; i < 100; ++i) {
                        if (Tree.isLeaves(targetBlock, this.field_70170_p)) {
                            Tree.dropDrops(targetBlock, targetBlock, this.field_70170_p.func_180495_p(targetBlock), this.field_70170_p);
                            this.field_70170_p.func_175656_a(targetBlock, Blocks.field_150350_a.func_176223_P());
                        }
                        targetBlock = targetBlock.func_177963_a(0.0, -0.5, 0.0);
                    }
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.98f;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y *= (double)0.98f;
                if (!this.field_70170_p.field_72995_K) {
                    BlockPos blockpos1 = new BlockPos((Entity)this);
                    if (this.field_70122_E) {
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos1);
                        targetBlock = new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v);
                        if (BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(targetBlock)) && Tree.blockName(targetBlock.func_177982_a(0, -1, 0), this.field_70170_p).matches("fence")) {
                            this.field_70122_E = false;
                            return;
                        }
                        if (!this.isLog && Tree.isLeaves(targetBlock, this.field_70170_p)) {
                            Tree.dropDrops(targetBlock, targetBlock, this.field_70170_p.func_180495_p(targetBlock), this.field_70170_p);
                            this.field_70170_p.func_175656_a(targetBlock, Blocks.field_150350_a.func_176223_P());
                            this.field_70122_E = false;
                            return;
                        }
                        this.field_70159_w *= (double)0.7f;
                        this.field_70179_y *= (double)0.7f;
                        this.field_70181_x *= -0.5;
                        if (iblockstate.func_177230_c() != Blocks.field_180384_M) {
                            this.func_70106_y();
                            if (this.field_70170_p.func_190527_a(block, blockpos1, true, EnumFacing.UP, (Entity)null) && !BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(blockpos1.func_177977_b())) && this.field_70170_p.func_180501_a(blockpos1, this.func_175131_l(), 3)) {
                                TileEntity tileentity;
                                if (block instanceof BlockFalling) {
                                    ((BlockFalling)block).func_176502_a_(this.field_70170_p, blockpos1, null, null);
                                }
                                if (this.field_145810_d != null && block instanceof ITileEntityProvider && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                                    for (String s : this.field_145810_d.func_150296_c()) {
                                        NBTBase nbtbase = this.field_145810_d.func_74781_a(s);
                                        if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                        nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                                    }
                                    tileentity.func_145839_a(nbttagcompound);
                                    tileentity.func_70296_d();
                                }
                            } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                                this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.func_175131_l())), 0.0f);
                            }
                        }
                    } else if (this.field_145812_b > 100 && !this.field_70170_p.field_72995_K && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.field_145812_b > 600) {
                        if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.func_175131_l())), 0.0f);
                        }
                        this.func_70106_y();
                    }
                }
            }
        }

        @Nullable
        public EntityItem func_70099_a(ItemStack stack, float offsetY) {
            TileEntity tileentity;
            IBlockState state = this.func_175131_l();
            Block block = this.func_175131_l().func_177230_c();
            BlockPos pos = new BlockPos((Entity)this);
            IBlockState toState = this.field_70170_p.func_180495_p(pos);
            Boolean isPassable = toState.func_177230_c().func_176205_b((IBlockAccess)this.field_70170_p, pos);
            while (!isPassable.booleanValue() && pos.func_177956_o() < 256) {
                pos = pos.func_177982_a(0, 1, 0);
                toState = this.field_70170_p.func_180495_p(pos);
                isPassable = toState.func_177230_c().func_176205_b((IBlockAccess)this.field_70170_p, pos);
            }
            if (pos.func_177956_o() > 255) {
                return null;
            }
            Tree.dropDrops(pos, pos, toState, this.field_70170_p);
            this.field_70170_p.func_175656_a(pos, state);
            if (this.field_145810_d != null && block instanceof ITileEntityProvider && (tileentity = this.field_70170_p.func_175625_s(pos)) != null) {
                NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                for (String s : this.field_145810_d.func_150296_c()) {
                    NBTBase nbtbase = this.field_145810_d.func_74781_a(s);
                    if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                    nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                }
                tileentity.func_145839_a(nbttagcompound);
                tileentity.func_70296_d();
            }
            return null;
        }
    }
}

