/*
 * Decompiled with CFR 0.152.
 */
package api.guide;

import api.guide.BookPage;
import api.materials.AdornmentMaterial;
import api.materials.HaftMaterial;
import api.materials.HandleMaterial;
import api.materials.HeadMaterial;
import api.materials.PartMaterial;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import toolbox.common.recipes.ModRecipes;

public class BookPageMat
extends BookPage {
    private final PartMaterial material;
    private final String description;

    public BookPageMat(PartMaterial mat) {
        super("guide.mat." + mat.getName() + ".name");
        this.material = mat;
        this.description = "guide.mat." + mat.getName() + ".desc";
    }

    public PartMaterial getMat() {
        return this.material;
    }

    public ItemStack getDisplayStack() {
        ItemStack stack;
        block8: {
            block9: {
                stack = ItemStack.field_190927_a;
                if (!(this.material instanceof HeadMaterial)) break block9;
                NonNullList ores = OreDictionary.getOres((String)((HeadMaterial)this.material).getCraftingItem());
                stack = ores.size() <= 0 ? ItemStack.field_190927_a : (ItemStack)ores.get(0);
                if (stack.func_77960_j() != Short.MAX_VALUE) break block8;
                stack = new ItemStack(stack.func_77973_b(), 1, 0, stack.func_77978_p());
                break block8;
            }
            if (this.material instanceof HaftMaterial) {
                Set<ItemStack> keys = ModRecipes.haft_map.keySet();
                for (ItemStack key : keys) {
                    if (ModRecipes.haft_map.get(key) != this.material) continue;
                    stack = key.func_77946_l();
                    break;
                }
            } else if (this.material instanceof HandleMaterial) {
                Set<ItemStack> keys = ModRecipes.handle_map.keySet();
                for (ItemStack key : keys) {
                    if (ModRecipes.handle_map.get(key) != this.material) continue;
                    stack = key.func_77946_l();
                    break;
                }
            } else if (this.material instanceof AdornmentMaterial) {
                Set<ItemStack> keys = ModRecipes.adornment_map.keySet();
                for (ItemStack key : keys) {
                    if (ModRecipes.adornment_map.get(key) != this.material) continue;
                    stack = key.func_77946_l();
                    break;
                }
            }
        }
        return stack;
    }

    public String getDescription() {
        return this.description;
    }
}

