/*
 * Decompiled with CFR 0.152.
 */
package toolbox.client.gui;

import api.guide.BookChapter;
import api.guide.BookPage;
import api.guide.BookPageContents;
import api.guide.BookPageItemDisplay;
import api.guide.BookPageMat;
import api.guide.BookPageText;
import api.guide.BookPageTool;
import api.guide.ChapterLink;
import api.materials.AdornmentMaterial;
import api.materials.HaftMaterial;
import api.materials.HandleMaterial;
import api.materials.HeadMaterial;
import api.materials.Materials;
import api.materials.PartMaterial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import toolbox.common.items.ModItems;
import toolbox.common.materials.ModMaterials;
import toolbox.common.recipes.ModRecipes;

public class GuiBook
extends GuiScreen {
    public static final int WIDTH = 146;
    public static final int HEIGHT = 180;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("toolbox", "textures/gui/book.png");
    private static Map<String, BookChapter> chapters = new HashMap<String, BookChapter>();
    private String currentChapter = "home";
    private int currentPageNum = 0;
    private BookPage currentPage;
    private String lastChapter;
    private int lastPageNum;
    private ItemStack display = ItemStack.field_190927_a;
    private int left;
    private int top;

    public static void initPages() {
        BookPageContents home = new BookPageContents("guide.page.home.name");
        home.addLink(new ChapterLink("guide.chapter.misc.name", "misc"));
        home.addLink(new ChapterLink("guide.chapter.mat.name", "mat"));
        home.addLink(new ChapterLink("guide.chapter.tool.name", "tool"));
        home.addLink(new ChapterLink("guide.chapter.weapon.name", "weapon"));
        BookPageContents matHome = new BookPageContents("guide.page.mat.name");
        matHome.addLink(new ChapterLink("guide.chapter.head_mat.name", "head_mat"));
        matHome.addLink(new ChapterLink("guide.chapter.haft_mat.name", "haft_mat"));
        matHome.addLink(new ChapterLink("guide.chapter.handle_mat.name", "handle_mat"));
        matHome.addLink(new ChapterLink("guide.chapter.adornment_mat.name", "adornment_mat"));
        chapters.put("home", new BookChapter("home"));
        chapters.put("misc", new BookChapter("misc", "home"));
        chapters.put("mat", new BookChapter("mat", "home"));
        chapters.put("tool", new BookChapter("tool", "home"));
        chapters.put("weapon", new BookChapter("weapon", "home"));
        chapters.put("head_mat", new BookChapter("head_mat", "mat"));
        chapters.put("haft_mat", new BookChapter("haft_mat", "mat"));
        chapters.put("handle_mat", new BookChapter("handle_mat", "mat"));
        chapters.put("adornment_mat", new BookChapter("adornment_mat", "mat"));
        chapters.get("home").addPage(home);
        chapters.get("mat").addPage(matHome);
        chapters.get("misc").addPage(new BookPageText("guide.page.misc.name", "guide.page.misc.text"));
        for (HeadMaterial headMaterial : Materials.head_registry.values()) {
            boolean hideUnavailables = true;
            if (hideUnavailables && (OreDictionary.getOres((String)headMaterial.getCraftingItem()).size() <= 0 || OreDictionary.getOres((String)headMaterial.getSmallCraftingItem()).size() <= 0)) continue;
            BookPageMat page = new BookPageMat(headMaterial);
            chapters.get("head_mat").addPage(page);
        }
        for (HaftMaterial haftMaterial : Materials.haft_registry.values()) {
            if (!ModRecipes.haft_map.containsValue(haftMaterial)) continue;
            BookPageMat page = new BookPageMat(haftMaterial);
            chapters.get("haft_mat").addPage(page);
        }
        for (HandleMaterial handleMaterial : Materials.handle_registry.values()) {
            if (!ModRecipes.handle_map.containsValue(handleMaterial)) continue;
            BookPageMat page = new BookPageMat(handleMaterial);
            chapters.get("handle_mat").addPage(page);
        }
        for (AdornmentMaterial adornmentMaterial : Materials.adornment_registry.values()) {
            if (adornmentMaterial == ModMaterials.ADORNMENT_NULL || !ModRecipes.adornment_map.containsValue(adornmentMaterial)) continue;
            BookPageMat page = new BookPageMat(adornmentMaterial);
            chapters.get("adornment_mat").addPage(page);
        }
        chapters.get("tool").addPage(new BookPageTool("guide.tool.pickaxe.name", "guide.tool.pickaxe.desc", (Item)ModItems.pickaxe));
        chapters.get("tool").addPage(new BookPageTool("guide.tool.axe.name", "guide.tool.axe.desc", (Item)ModItems.axe));
        chapters.get("tool").addPage(new BookPageTool("guide.tool.shovel.name", "guide.tool.shovel.desc", (Item)ModItems.shovel));
        chapters.get("tool").addPage(new BookPageTool("guide.tool.hoe.name", "guide.tool.hoe.desc", (Item)ModItems.hoe));
        chapters.get("tool").addPage(new BookPageTool("guide.tool.handpick.name", "guide.tool.handpick.desc", (Item)ModItems.handpick));
        chapters.get("tool").addPage(new BookPageTool("guide.tool.hammer.name", "guide.tool.hammer.desc", (Item)ModItems.hammer));
        chapters.get("weapon").addPage(new BookPageTool("guide.weapon.sword.name", "guide.weapon.sword.desc", (Item)ModItems.sword));
        chapters.get("weapon").addPage(new BookPageTool("guide.weapon.dagger.name", "guide.weapon.dagger.desc", (Item)ModItems.dagger));
        chapters.get("weapon").addPage(new BookPageTool("guide.weapon.mace.name", "guide.weapon.mace.desc", (Item)ModItems.mace));
        for (BookChapter bookChapter : chapters.values()) {
            if (bookChapter.getPageCount() > 0) continue;
            bookChapter.addPage(new BookPage(bookChapter.getName()));
        }
    }

    public void func_73866_w_() {
        this.top = (this.field_146295_m - 180) / 2;
        this.left = (this.field_146294_l - 146) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(BACKGROUND);
        this.func_73729_b(this.left, this.top, 0, 0, 146, 180);
        if (this.currentPage != null) {
            String header = TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + I18n.func_135052_a((String)this.currentPage.getTitle(), (Object[])new Object[0]);
            int headerWidth = this.field_146289_q.func_78256_a(header);
            this.field_146289_q.func_78276_b(header, this.left + (146 - headerWidth) / 2, this.top + 12, 0);
            if (this.currentPage instanceof BookPageItemDisplay) {
                this.renderItemDisplayPage((BookPageItemDisplay)this.currentPage, mouseX, mouseY);
            } else if (this.currentPage instanceof BookPageMat) {
                this.renderMatPage((BookPageMat)this.currentPage, mouseX, mouseY);
            } else if (this.currentPage instanceof BookPageText) {
                this.renderTextPage((BookPageText)this.currentPage, mouseX, mouseY);
            }
            if (chapters.get(this.currentChapter).getPageCount() > 1) {
                GlStateManager.func_179094_E();
                float textScale = 0.5f;
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
                String pageNum = this.currentPageNum + 1 + "/" + chapters.get(this.currentChapter).getPageCount();
                int pageNumWidth = (int)((float)this.field_146289_q.func_78256_a(pageNum) * textScale);
                int x = (int)((float)(this.left + (146 - pageNumWidth) / 2) / textScale);
                this.field_146289_q.func_78276_b(pageNum, x, (int)((float)(this.top + 164) / textScale), 0);
                GlStateManager.func_179121_F();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void renderItemDisplayPage(BookPageItemDisplay page, int mouseX, int mouseY) {
        ItemStack stack = page.getDisplayStack();
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            stack = new ItemStack(stack.func_77973_b(), 1, 0, stack.func_77978_p());
        }
        if (stack.func_77973_b() != this.display.func_77973_b() || stack.func_77960_j() != this.display.func_77960_j()) {
            this.display = stack;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        RenderHelper.func_74520_c();
        int itemX = this.left + 57;
        int itemY = this.top + 24;
        float itemScale = 2.0f;
        this.field_146296_j.func_180450_b(this.display, (int)((float)itemX / itemScale), (int)((float)itemY / itemScale));
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        float textScale = 0.5f;
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)page.getDescription(), (Object[])new Object[0]), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + 58) / textScale), (int)(110.0f / textScale), 0);
        GlStateManager.func_179121_F();
        if (mouseX >= itemX && mouseY >= itemY && (float)mouseX <= (float)itemX + 16.0f * itemScale && (float)mouseY <= (float)itemY + 16.0f * itemScale) {
            GlStateManager.func_179094_E();
            float toolTipScale = 0.5f;
            GlStateManager.func_179152_a((float)toolTipScale, (float)toolTipScale, (float)toolTipScale);
            this.func_146285_a(this.display, (int)((float)mouseX / toolTipScale), (int)((float)mouseY / toolTipScale));
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }

    private void renderMatPage(BookPageMat page, int mouseX, int mouseY) {
        PartMaterial mat;
        this.display = page.getDisplayStack();
        GlStateManager.func_179094_E();
        float itemScale = 2.0f;
        int itemX = this.left + 57;
        int itemY = this.top + 24;
        GlStateManager.func_179152_a((float)itemScale, (float)itemScale, (float)itemScale);
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(this.display, (int)((float)itemX / itemScale), (int)((float)itemY / itemScale));
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        float textScale = 0.5f;
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        int i = 58;
        int increment = (int)(2.0f + (float)this.field_146289_q.field_78288_b * textScale);
        if (page.getMat() instanceof HeadMaterial) {
            mat = (HeadMaterial)page.getMat();
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.harvest_level.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HeadMaterial)mat).getHarvestLevel(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.efficiency.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HeadMaterial)mat).getEfficiency(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.durability.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HeadMaterial)mat).getDurability(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.attack_damage.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HeadMaterial)mat).getAttackDamage(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.enchantability.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HeadMaterial)mat).getEnchantability(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            i += increment;
        } else if (page.getMat() instanceof HaftMaterial) {
            mat = (HaftMaterial)page.getMat();
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.harvest_level_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HaftMaterial)mat).getHarvestLevelMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.efficiency_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HaftMaterial)mat).getEfficiencyMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.durability_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HaftMaterial)mat).getDurabilityMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.attack_damage_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HaftMaterial)mat).getAttackDamageMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.enchantability_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HaftMaterial)mat).getEnchantabilityMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            i += increment;
        } else if (page.getMat() instanceof HandleMaterial) {
            mat = (HandleMaterial)page.getMat();
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.efficiency_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HandleMaterial)mat).getEfficiencyMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.durability_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HandleMaterial)mat).getDurabilityMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.enchantability_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((HandleMaterial)mat).getEnchantabilityMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            i += increment;
        } else if (page.getMat() instanceof AdornmentMaterial) {
            mat = (AdornmentMaterial)page.getMat();
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.harvest_level_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((AdornmentMaterial)mat).getHarvestLevelMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.efficiency_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((AdornmentMaterial)mat).getEfficiencyMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.durability_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((AdornmentMaterial)mat).getDurabilityMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.attack_damage_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((AdornmentMaterial)mat).getAttackDamageMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"guide.mat.stat.enchantability_mod.name", (Object[])new Object[0]) + TextFormatting.RESET + ": " + ((AdornmentMaterial)mat).getEnchantabilityMod(), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += increment)) / textScale), 0);
            i += increment;
        }
        if (!I18n.func_135052_a((String)page.getDescription(), (Object[])new Object[0]).equals(page.getDescription())) {
            this.field_146289_q.func_78279_b(TextFormatting.DARK_RED + I18n.func_135052_a((String)page.getDescription(), (Object[])new Object[0]), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + (i += 6)) / textScale), (int)(110.0f / textScale), 0);
        }
        GlStateManager.func_179121_F();
        if (mouseX >= itemX && mouseY >= itemY && (float)mouseX <= (float)itemX + 16.0f * itemScale && (float)mouseY <= (float)itemY + 16.0f * itemScale) {
            GlStateManager.func_179094_E();
            float toolTipScale = 0.5f;
            GlStateManager.func_179152_a((float)toolTipScale, (float)toolTipScale, (float)toolTipScale);
            this.func_146285_a(this.display, (int)((float)mouseX / toolTipScale), (int)((float)mouseY / toolTipScale));
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }

    private void renderTextPage(BookPageText page, int mouseX, int mouseY) {
        int i;
        GlStateManager.func_179094_E();
        float textScale = 0.5f;
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        String text = I18n.func_135052_a((String)page.getText(), (Object[])new Object[0]);
        ArrayList<String> paragraphs = new ArrayList<String>();
        while (text.indexOf("|") > -1) {
            i = text.indexOf("|");
            paragraphs.add("    " + text.substring(0, i));
            if (i >= text.length() - 1) continue;
            text = text.substring(i + 1);
        }
        paragraphs.add("    " + text);
        i = 24;
        for (String par : paragraphs) {
            this.field_146289_q.func_78279_b(par, (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), (int)(110.0f / textScale), 0);
            i += (int)(2.0f + (float)this.field_146289_q.func_78267_b(par, (int)(110.0f / textScale)) * textScale);
        }
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.currentPage = chapters.get(this.currentChapter).getPage(this.currentPageNum);
        if (this.currentPageNum != this.lastPageNum || !this.currentChapter.equals(this.lastChapter)) {
            this.resetPage();
        }
        this.lastChapter = this.currentChapter;
        this.lastPageNum = this.currentPageNum;
    }

    private void resetPage() {
        this.field_146292_n.clear();
        int i = 0;
        if (this.currentPage instanceof BookPageContents) {
            List<ChapterLink> links = ((BookPageContents)this.currentPage).getLinks();
            for (ChapterLink link : links) {
                this.func_189646_b(new ChapterLinkButton(i, this.left + 16, this.top + 24 + i * 12, link.text, link.chapter));
                ++i;
            }
        }
        if (this.currentPageNum < chapters.get(this.currentChapter).getPageCount() - 1) {
            this.func_189646_b(new PageTurnButton(i, this.left + 100, this.top + 154, true));
            ++i;
        }
        if (this.currentPageNum > 0) {
            this.func_189646_b(new PageTurnButton(i, this.left + 18, this.top + 154, false));
            ++i;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof ChapterLinkButton) {
            this.currentChapter = ((ChapterLinkButton)button).getChapter();
            this.currentPageNum = 0;
        } else if (button instanceof PageTurnButton) {
            this.currentPageNum = ((PageTurnButton)button).isForward() ? ++this.currentPageNum : --this.currentPageNum;
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() == par2) {
            if (this.currentChapter.equals(chapters.get(this.currentChapter).getParent())) {
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            } else {
                this.currentChapter = chapters.get(this.currentChapter).getParent();
                this.currentPageNum = 0;
            }
        } else if (1 == par2) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            this.currentChapter = chapters.get(this.currentChapter).getParent();
            this.currentPageNum = 0;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        this.func_146280_a(mcIn, w, h);
        this.resetPage();
    }

    @SideOnly(value=Side.CLIENT)
    public class PageTurnButton
    extends GuiButton {
        private final boolean isForward;

        public PageTurnButton(int buttonId, int x, int y, boolean isForward) {
            super(buttonId, x, y, 23, 13, "");
            this.isForward = isForward;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BACKGROUND);
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                if (!this.isForward) {
                    j += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 23, 13);
            }
        }

        public boolean isForward() {
            return this.isForward;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ChapterLinkButton
    extends GuiButton {
        private String chapter;

        public ChapterLinkButton(int buttonId, int x, int y, String buttonText, String chapter) {
            super(buttonId, x, y, Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)buttonText, (Object[])new Object[0])), Minecraft.func_71410_x().field_71466_p.field_78288_b, buttonText);
            this.chapter = chapter;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                this.func_146119_b(mc, mouseX, mouseY);
                int j = 0;
                String p = "";
                if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 1450415;
                    p = p + TextFormatting.UNDERLINE;
                }
                fontrenderer.func_78276_b(p + I18n.func_135052_a((String)this.field_146126_j, (Object[])new Object[0]), this.field_146128_h, this.field_146129_i, j);
            }
        }

        public String getChapter() {
            return this.chapter;
        }
    }
}

