/*
 * Decompiled with CFR 0.152.
 */
package toolbox.client.models;

import api.materials.AdornmentMaterial;
import api.materials.HaftMaterial;
import api.materials.HandleMaterial;
import api.materials.HeadMaterial;
import api.materials.Materials;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import toolbox.common.items.ModItems;
import toolbox.common.items.tools.IAdornedTool;
import toolbox.common.items.tools.IHaftTool;
import toolbox.common.items.tools.IHandleTool;
import toolbox.common.items.tools.IHeadTool;
import toolbox.common.materials.ModMaterials;

public class AxeModel
implements IModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("toolbox", "axe"), "inventory");
    public static final IModel MODEL = new AxeModel();
    @Nullable
    private final ResourceLocation headTexture;
    @Nullable
    private final ResourceLocation haftTexture;
    @Nullable
    private final ResourceLocation handleTexture;
    @Nullable
    private final ResourceLocation adornmentTexture;

    public AxeModel() {
        this.headTexture = null;
        this.haftTexture = null;
        this.handleTexture = null;
        this.adornmentTexture = null;
    }

    public AxeModel(ResourceLocation head, ResourceLocation haft, ResourceLocation handle, ResourceLocation adornment) {
        this.headTexture = head;
        this.haftTexture = haft;
        this.handleTexture = handle;
        this.adornmentTexture = adornment;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation head = null;
        ResourceLocation haft = null;
        ResourceLocation handle = null;
        ResourceLocation adornment = null;
        if (textures.containsKey((Object)"head")) {
            head = new ResourceLocation(Materials.head_registry.get(textures.get((Object)"head")).getModId(), "items/axe/head_" + (String)textures.get((Object)"head"));
        }
        if (textures.containsKey((Object)"haft")) {
            haft = new ResourceLocation(Materials.haft_registry.get(textures.get((Object)"haft")).getModId(), "items/axe/haft_" + (String)textures.get((Object)"haft"));
        }
        if (textures.containsKey((Object)"handle")) {
            handle = new ResourceLocation(Materials.handle_registry.get(textures.get((Object)"handle")).getModId(), "items/axe/handle_" + (String)textures.get((Object)"handle"));
        }
        if (textures.containsKey((Object)"adornment")) {
            adornment = new ResourceLocation(Materials.adornment_registry.get(textures.get((Object)"adornment")).getModId(), "items/axe/adornment_" + (String)textures.get((Object)"adornment"));
        }
        return new AxeModel(head, haft, handle, adornment);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ResourceLocation head = null;
        ResourceLocation haft = null;
        ResourceLocation handle = null;
        ResourceLocation adornment = null;
        if (customData.containsKey((Object)"head")) {
            head = new ResourceLocation(Materials.head_registry.get(customData.get((Object)"head")).getModId(), "items/axe/head_" + (String)customData.get((Object)"head"));
        }
        if (customData.containsKey((Object)"haft")) {
            haft = new ResourceLocation(Materials.haft_registry.get(customData.get((Object)"haft")).getModId(), "items/axe/haft_" + (String)customData.get((Object)"haft"));
        }
        if (customData.containsKey((Object)"handle")) {
            handle = new ResourceLocation(Materials.handle_registry.get(customData.get((Object)"handle")).getModId(), "items/axe/handle_" + (String)customData.get((Object)"handle"));
        }
        if (customData.containsKey((Object)"adornment")) {
            adornment = new ResourceLocation(Materials.adornment_registry.get(customData.get((Object)"adornment")).getModId(), "items/axe/adornment_" + (String)customData.get((Object)"adornment"));
        }
        return new AxeModel(head, haft, handle, adornment);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (HeadMaterial headMaterial : Materials.head_registry.values()) {
            builder.add((Object)new ResourceLocation(headMaterial.getModId(), "items/axe/head_" + headMaterial.getName()));
        }
        for (HaftMaterial haftMaterial : Materials.haft_registry.values()) {
            builder.add((Object)new ResourceLocation(haftMaterial.getModId(), "items/axe/haft_" + haftMaterial.getName()));
        }
        for (HandleMaterial handleMaterial : Materials.handle_registry.values()) {
            builder.add((Object)new ResourceLocation(handleMaterial.getModId(), "items/axe/handle_" + handleMaterial.getName()));
        }
        for (AdornmentMaterial adornmentMaterial : Materials.adornment_registry.values()) {
            builder.add((Object)new ResourceLocation(adornmentMaterial.getModId(), "items/axe/adornment_" + adornmentMaterial.getName()));
        }
        ImmutableList textures = builder.build();
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, java.util.function.Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = TRSRTransformation.identity();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.headTexture != null && this.haftTexture != null && this.handleTexture != null) {
            ImmutableList.Builder texBuilder = ImmutableList.builder();
            if (this.haftTexture != null) {
                texBuilder.add((Object)this.haftTexture);
            }
            if (this.headTexture != null) {
                texBuilder.add((Object)this.headTexture);
            }
            if (this.handleTexture != null) {
                texBuilder.add((Object)this.handleTexture);
            }
            if (this.adornmentTexture != null) {
                texBuilder.add((Object)this.adornmentTexture);
            }
            ImmutableList textures = texBuilder.build();
            IBakedModel model = new ItemLayerModel(textures).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        return new BakedAxeModel(this, (ImmutableList<BakedQuad>)builder.build(), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static final class BakedAxeModel
    implements IBakedModel {
        private final AxeModel parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final VertexFormat format;

        public BakedAxeModel(AxeModel parent, ImmutableList<BakedQuad> quads, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.format = format;
            this.parent = parent;
            this.transforms = BakedAxeModel.itemTransforms();
            this.cache = cache;
        }

        public ItemOverrideList func_188617_f() {
            return BakedAxeOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedAxeModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedAxeModel.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)BakedAxeModel.get(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)BakedAxeModel.get(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedAxeModel.get(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)BakedAxeModel.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedAxeModel.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
            return builder.build();
        }

        private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }
    }

    private static final class BakedAxeOverrideHandler
    extends ItemOverrideList {
        public static final BakedAxeOverrideHandler INSTANCE = new BakedAxeOverrideHandler();

        private BakedAxeOverrideHandler() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (stack.func_77973_b() != ModItems.axe) {
                return originalModel;
            }
            BakedAxeModel model = (BakedAxeModel)originalModel;
            String key = IHeadTool.getHeadMat(stack).getName() + "|" + IHaftTool.getHaftMat(stack).getName() + "|" + IHandleTool.getHandleMat(stack).getName() + "|" + IAdornedTool.getAdornmentMat(stack).getName();
            if (!model.cache.containsKey(key)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"head", (Object)IHeadTool.getHeadMat(stack).getName());
                builder.put((Object)"haft", (Object)IHaftTool.getHaftMat(stack).getName());
                builder.put((Object)"handle", (Object)IHandleTool.getHandleMat(stack).getName());
                if (IAdornedTool.getAdornmentMat(stack) != ModMaterials.ADORNMENT_NULL) {
                    builder.put((Object)"adornment", (Object)IAdornedTool.getAdornmentMat(stack).getName());
                }
                IModel parent = model.parent.retexture((ImmutableMap<String, String>)builder.build());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.format, (java.util.function.Function)textureGetter);
                model.cache.put(key, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(key);
        }
    }

    public static enum LoaderAxe implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("toolbox") && modelLocation.func_110623_a().equals("axe");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

