/*
 * Decompiled with CFR 0.152.
 */
package toolbox.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BakedToolModel
implements IBakedModel {
    protected final IModel parent;
    protected final Map<String, IBakedModel> cache;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final ImmutableList<BakedQuad> quads;
    protected final VertexFormat format;

    public BakedToolModel(IModel parent, ImmutableList<BakedQuad> quads, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
        this.quads = quads;
        this.format = format;
        this.parent = parent;
        this.transforms = this.itemTransforms();
        this.cache = cache;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    protected ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)this.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)this.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)this.get(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)this.get(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)this.get(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)this.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)this.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        return builder.build();
    }

    protected TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null) {
            return this.quads;
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

