/*
 * Decompiled with CFR 0.152.
 */
package toolbox.client.models;

import api.materials.AdornmentMaterial;
import api.materials.HaftMaterial;
import api.materials.HandleMaterial;
import api.materials.HeadMaterial;
import api.materials.Materials;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import toolbox.client.models.BakedToolModel;
import toolbox.common.items.ModItems;
import toolbox.common.items.tools.IAdornedTool;
import toolbox.common.items.tools.IHaftTool;
import toolbox.common.items.tools.IHandleTool;
import toolbox.common.items.tools.IHeadTool;
import toolbox.common.materials.ModMaterials;

public class MaceModel
implements IModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("toolbox", "mace"), "inventory");
    public static final IModel MODEL = new MaceModel();
    @Nullable
    private final ResourceLocation headTexture;
    @Nullable
    private final ResourceLocation haftTexture;
    @Nullable
    private final ResourceLocation handleTexture;
    @Nullable
    private final ResourceLocation adornmentTexture;

    public MaceModel() {
        this.headTexture = null;
        this.haftTexture = null;
        this.handleTexture = null;
        this.adornmentTexture = null;
    }

    public MaceModel(ResourceLocation head, ResourceLocation haft, ResourceLocation handle, ResourceLocation adornment) {
        this.headTexture = head;
        this.haftTexture = haft;
        this.handleTexture = handle;
        this.adornmentTexture = adornment;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation head = null;
        ResourceLocation haft = null;
        ResourceLocation handle = null;
        ResourceLocation adornment = null;
        if (textures.containsKey((Object)"head")) {
            head = new ResourceLocation(Materials.head_registry.get(textures.get((Object)"head")).getModId(), "items/mace/head_" + (String)textures.get((Object)"head"));
        }
        if (textures.containsKey((Object)"haft")) {
            haft = new ResourceLocation(Materials.haft_registry.get(textures.get((Object)"haft")).getModId(), "items/mace/haft_" + (String)textures.get((Object)"haft"));
        }
        if (textures.containsKey((Object)"handle")) {
            handle = new ResourceLocation(Materials.handle_registry.get(textures.get((Object)"handle")).getModId(), "items/mace/handle_" + (String)textures.get((Object)"handle"));
        }
        if (textures.containsKey((Object)"adornment")) {
            adornment = new ResourceLocation(Materials.adornment_registry.get(textures.get((Object)"adornment")).getModId(), "items/mace/adornment_" + (String)textures.get((Object)"adornment"));
        }
        return new MaceModel(head, haft, handle, adornment);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ResourceLocation head = null;
        ResourceLocation haft = null;
        ResourceLocation handle = null;
        ResourceLocation adornment = null;
        if (customData.containsKey((Object)"head")) {
            head = new ResourceLocation(Materials.head_registry.get(customData.get((Object)"head")).getModId(), "items/mace/head_" + (String)customData.get((Object)"head"));
        }
        if (customData.containsKey((Object)"haft")) {
            haft = new ResourceLocation(Materials.haft_registry.get(customData.get((Object)"haft")).getModId(), "items/mace/haft_" + (String)customData.get((Object)"haft"));
        }
        if (customData.containsKey((Object)"handle")) {
            handle = new ResourceLocation(Materials.handle_registry.get(customData.get((Object)"handle")).getModId(), "items/mace/handle_" + (String)customData.get((Object)"handle"));
        }
        if (customData.containsKey((Object)"adornment")) {
            adornment = new ResourceLocation(Materials.adornment_registry.get(customData.get((Object)"adornment")).getModId(), "items/mace/adornment_" + (String)customData.get((Object)"adornment"));
        }
        return new MaceModel(head, haft, handle, adornment);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (HeadMaterial headMaterial : Materials.head_registry.values()) {
            builder.add((Object)new ResourceLocation(headMaterial.getModId(), "items/mace/head_" + headMaterial.getName()));
        }
        for (HaftMaterial haftMaterial : Materials.haft_registry.values()) {
            builder.add((Object)new ResourceLocation(haftMaterial.getModId(), "items/mace/haft_" + haftMaterial.getName()));
        }
        for (HandleMaterial handleMaterial : Materials.handle_registry.values()) {
            builder.add((Object)new ResourceLocation(handleMaterial.getModId(), "items/mace/handle_" + handleMaterial.getName()));
        }
        for (AdornmentMaterial adornmentMaterial : Materials.adornment_registry.values()) {
            builder.add((Object)new ResourceLocation(adornmentMaterial.getModId(), "items/mace/adornment_" + adornmentMaterial.getName()));
        }
        ImmutableList textures = builder.build();
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, java.util.function.Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = TRSRTransformation.identity();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.headTexture != null && this.haftTexture != null && this.handleTexture != null) {
            ImmutableList.Builder texBuilder = ImmutableList.builder();
            if (this.haftTexture != null) {
                texBuilder.add((Object)this.haftTexture);
            }
            if (this.headTexture != null) {
                texBuilder.add((Object)this.headTexture);
            }
            if (this.handleTexture != null) {
                texBuilder.add((Object)this.handleTexture);
            }
            if (this.adornmentTexture != null) {
                texBuilder.add((Object)this.adornmentTexture);
            }
            ImmutableList textures = texBuilder.build();
            IBakedModel model = new ItemLayerModel(textures).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        return new BakedMaceModel(this, (ImmutableList<BakedQuad>)builder.build(), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), (Map<String, IBakedModel>)Maps.newHashMap());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static final class BakedMaceModel
    extends BakedToolModel {
        public BakedMaceModel(MaceModel parent, ImmutableList<BakedQuad> quads, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            super(parent, quads, format, transforms, cache);
        }

        public ItemOverrideList func_188617_f() {
            return BakedMaceOverrideHandler.INSTANCE;
        }
    }

    private static final class BakedMaceOverrideHandler
    extends ItemOverrideList {
        public static final BakedMaceOverrideHandler INSTANCE = new BakedMaceOverrideHandler();

        private BakedMaceOverrideHandler() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (stack.func_77973_b() != ModItems.mace) {
                return originalModel;
            }
            BakedMaceModel model = (BakedMaceModel)originalModel;
            String key = IHeadTool.getHeadMat(stack).getName() + "|" + IHaftTool.getHaftMat(stack).getName() + "|" + IHandleTool.getHandleMat(stack).getName() + "|" + IAdornedTool.getAdornmentMat(stack).getName();
            if (!model.cache.containsKey(key)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"head", (Object)IHeadTool.getHeadMat(stack).getName());
                builder.put((Object)"haft", (Object)IHaftTool.getHaftMat(stack).getName());
                builder.put((Object)"handle", (Object)IHandleTool.getHandleMat(stack).getName());
                if (IAdornedTool.getAdornmentMat(stack) != ModMaterials.ADORNMENT_NULL) {
                    builder.put((Object)"adornment", (Object)IAdornedTool.getAdornmentMat(stack).getName());
                }
                IModel parent = model.parent.retexture(builder.build());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.format, (java.util.function.Function)textureGetter);
                model.cache.put(key, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(key);
        }
    }

    public static enum LoaderMace implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("toolbox") && modelLocation.func_110623_a().equals("mace");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

