/*
 * Decompiled with CFR 0.152.
 */
package toolbox.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ToolHeadModel
implements IModel {
    private String modid;
    private String toolName;
    private String partName;
    private String matName;

    public ToolHeadModel(String modid, String toolName, String partName, String matName) {
        this.modid = modid;
        this.toolName = toolName;
        this.partName = partName;
        this.matName = matName;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)new ResourceLocation(this.modid, "items/" + this.toolName + "/" + this.partName + "_" + this.matName));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = TRSRTransformation.identity();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList textures = ImmutableList.of((Object)new ResourceLocation(this.modid, "items/" + this.toolName + "/" + this.partName + "_" + this.matName));
        builder.addAll((Iterable)new ItemLayerModel(textures).bake(state, format, bakedTextureGetter).func_188616_a(null, null, 0L));
        return new BakedToolHeadModel(this, (ImmutableList<BakedQuad>)builder.build(), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static final class BakedToolHeadModel
    implements IBakedModel {
        private final ToolHeadModel parent;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final VertexFormat format;
        private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);

        public BakedToolHeadModel(ToolHeadModel parent, ImmutableList<BakedQuad> quads, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.format = format;
            this.parent = parent;
            this.transforms = BakedToolHeadModel.itemTransforms();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedToolHeadModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedToolHeadModel.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)BakedToolHeadModel.get(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)BakedToolHeadModel.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedToolHeadModel.leftify(BakedToolHeadModel.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)BakedToolHeadModel.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedToolHeadModel.leftify(BakedToolHeadModel.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f)));
            return builder.build();
        }

        private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
        }

        private static TRSRTransformation leftify(TRSRTransformation transform) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }
    }

    public static enum LoaderToolHead implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110623_a().length() > 3 && modelLocation.func_110623_a().substring(0, 3).equals("th_");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            String path = modelLocation.func_110623_a().substring(3);
            int index = path.indexOf(95);
            if (path.charAt(0) == 'c') {
                index = path.indexOf(95, index + 1);
            }
            String toolName = path.substring(0, index);
            path = path.substring(index + 1);
            index = path.indexOf(95);
            String partName = path.substring(0, index);
            String matName = path = path.substring(index + 1);
            return new ToolHeadModel(modelLocation.func_110624_b(), toolName, partName, matName);
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

