/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common;

import api.materials.HeadMaterial;
import api.materials.Materials;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.apache.logging.log4j.Level;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.common.lib.research.ResearchManager;
import toolbox.Toolbox;
import toolbox.common.Config;
import toolbox.common.GuiProxy;
import toolbox.common.entities.ModEntities;
import toolbox.common.handlers.HammerHandler;
import toolbox.common.handlers.HandpickHarvestHandler;
import toolbox.common.handlers.SpecialToolAbilityHandler;
import toolbox.common.handlers.ToolRepairHandler;
import toolbox.common.handlers.WeaponHandler;
import toolbox.common.handlers.WorldHandler;
import toolbox.common.items.ModItems;
import toolbox.common.materials.ModMaterials;
import toolbox.common.recipes.ModRecipes;
import toolbox.compat.tconstruct.TConstructCompat;
import toolbox.compat.thaumcraft.ThaumcraftCompat;

public class CommonProxy {
    public static Configuration config;
    public static List<HeadMaterial> smelteryMaterials;
    public static boolean thaumcraftLoaded;
    public static List<ResourceLocation> removed_recipes;

    public void preInit(FMLPreInitializationEvent event) {
        File directory = event.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "adventurers_toolbox.cfg"));
        Config.readConfig();
        MinecraftForge.EVENT_BUS.register((Object)new HandpickHarvestHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpecialToolAbilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ToolRepairHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HammerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WeaponHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldHandler());
        ModMaterials.init();
        Toolbox.logger.log(Level.INFO, "Initialized tool part materials with " + Materials.head_registry.size() + " head materials, " + Materials.haft_registry.size() + " haft materials, " + Materials.handle_registry.size() + " handle materials, and " + Materials.adornment_registry.size() + " adornment materials");
        ModEntities.init();
        if (Loader.isModLoaded((String)"tconstruct") && Config.ENABLE_TINKERS_COMPAT) {
            TConstructCompat.preInit();
        }
    }

    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Toolbox.instance, (IGuiHandler)new GuiProxy());
        if (Loader.isModLoaded((String)"tconstruct") && Config.ENABLE_TINKERS_COMPAT) {
            TConstructCompat.init();
        }
        ModRecipes.init();
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (config.hasChanged()) {
            config.save();
        }
        ModMaterials.initHeadRepairItems();
        thaumcraftLoaded = Loader.isModLoaded((String)"thaumcraft");
        if (Config.DISABLE_VANILLA_TOOLS) {
            this.processRecipes();
            if (thaumcraftLoaded) {
                this.processThaumcraftRecipes();
                ThaumcraftCompat.fixThaumonomiconRecipeLists();
            }
        }
    }

    protected void processRecipes() {
        if (ForgeRegistries.RECIPES instanceof IForgeRegistryModifiable) {
            IForgeRegistryModifiable registry = (IForgeRegistryModifiable)ForgeRegistries.RECIPES;
            Map.Entry[] recipeEntries = ForgeRegistries.RECIPES.getEntries().toArray(new Map.Entry[ForgeRegistries.RECIPES.getEntries().size()]);
            for (int recipeIndex = 0; recipeIndex < recipeEntries.length; ++recipeIndex) {
                Map.Entry recipeEntry = recipeEntries[recipeIndex];
                IRecipe recipe = (IRecipe)recipeEntry.getValue();
                NonNullList ingredients = recipe.func_192400_c();
                Item output = recipe.func_77571_b().func_77973_b();
                String rp = output.getRegistryName().func_110623_a();
                boolean exception = false;
                for (String s : Config.REMOVAL_EXCEPTIONS) {
                    if (!output.getRegistryName().toString().contains(s)) continue;
                    exception = true;
                }
                if (!exception && (output instanceof ItemHoe || output instanceof ItemAxe || output instanceof ItemSpade || output instanceof ItemPickaxe || output instanceof ItemSword) || output instanceof ItemTool && (rp.contains("pick") || rp.contains("axe") || rp.contains("shovel") || rp.contains("spade")) || output instanceof ItemTool && output.getRegistryName().func_110624_b().equals("thermalfoundation") && rp.contains("hammer")) {
                    String materialName;
                    String string = output instanceof ItemHoe ? ((ItemHoe)output).func_77842_f() : (materialName = output instanceof ItemSword ? ((ItemSword)output).func_150932_j() : ((ItemTool)output).func_77861_e());
                    if (Materials.canReplaceMaterial(materialName, recipe.func_77571_b())) {
                        registry.remove((ResourceLocation)recipeEntry.getKey());
                        registry.register((IForgeRegistryEntry)new IRecipe(){
                            private ResourceLocation registryName;

                            public IRecipe setRegistryName(ResourceLocation name) {
                                this.registryName = name;
                                return this;
                            }

                            public ResourceLocation getRegistryName() {
                                return this.registryName;
                            }

                            public Class<IRecipe> getRegistryType() {
                                return IRecipe.class;
                            }

                            public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
                                return false;
                            }

                            public ItemStack func_77572_b(InventoryCrafting inv) {
                                return ItemStack.field_190927_a;
                            }

                            public boolean func_194133_a(int width, int height) {
                                return false;
                            }

                            public ItemStack func_77571_b() {
                                return ItemStack.field_190927_a;
                            }
                        }.setRegistryName((ResourceLocation)recipeEntry.getKey()));
                        removed_recipes.add((ResourceLocation)recipeEntry.getKey());
                        continue;
                    }
                    System.out.println(output.getRegistryName() + " -> " + materialName);
                    continue;
                }
                for (int i = 0; i < ingredients.size(); ++i) {
                    ItemStack[] matchingStacks = ((Ingredient)ingredients.get(i)).func_193365_a();
                    boolean flag = false;
                    Item ingredientItem = null;
                    for (int j = 0; j < matchingStacks.length && !flag; ++j) {
                        Item item = matchingStacks[j].func_77973_b();
                        if (this.getToolReplacement(item).func_190926_b()) continue;
                        ingredientItem = item;
                        flag = true;
                    }
                    if (!flag || ingredientItem == null || this.getToolReplacement(ingredientItem).func_190926_b()) continue;
                    ingredients.set(i, (Object)new IngredientNBT(this.getToolReplacement(ingredientItem)){});
                }
            }
        }
    }

    protected void processThaumcraftRecipes() {
        Map.Entry[] recipeEntries = ThaumcraftApi.getCraftingRecipes().entrySet().toArray(new Map.Entry[ThaumcraftApi.getCraftingRecipes().entrySet().size()]);
        for (int recipeIndex = 0; recipeIndex < recipeEntries.length; ++recipeIndex) {
            NonNullList ingredients;
            IRecipe recipe;
            Map.Entry recipeEntry = recipeEntries[recipeIndex];
            if (recipeEntry.getValue() instanceof IRecipe) {
                recipe = (IRecipe)recipeEntry.getValue();
                ingredients = recipe.func_192400_c();
                Item output = recipe.func_77571_b().func_77973_b();
                String rp = output.getRegistryName().func_110623_a();
                for (int i = 0; i < ingredients.size(); ++i) {
                    ItemStack[] matchingStacks = ((Ingredient)ingredients.get(i)).func_193365_a();
                    boolean flag = false;
                    Item ingredientItem = null;
                    for (int j = 0; j < matchingStacks.length && !flag; ++j) {
                        Item item = matchingStacks[j].func_77973_b();
                        if (this.getToolReplacement(item).func_190926_b()) continue;
                        ingredientItem = item;
                        flag = true;
                    }
                    if (!flag || ingredientItem == null || this.getToolReplacement(ingredientItem).func_190926_b()) continue;
                    ingredients.set(i, (Object)new IngredientNBT(this.getToolReplacement(ingredientItem)){});
                }
                continue;
            }
            if (!(recipeEntry.getValue() instanceof InfusionRecipe)) continue;
            recipe = (InfusionRecipe)recipeEntry.getValue();
            ingredients = recipe.getComponents();
            Ingredient input = recipe.getRecipeInput();
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack[] matchingStacks = ((Ingredient)ingredients.get(i)).func_193365_a();
                boolean flag = false;
                Item ingredientItem = null;
                for (int j = 0; j < matchingStacks.length && !flag; ++j) {
                    Item item = matchingStacks[j].func_77973_b();
                    if (this.getToolReplacement(item).func_190926_b()) continue;
                    ingredientItem = item;
                    flag = true;
                }
                if (!flag || ingredientItem == null || this.getToolReplacement(ingredientItem).func_190926_b()) continue;
                ingredients.set(i, (Object)new IngredientNBT(this.getToolReplacement(ingredientItem)){});
            }
            ItemStack[] matchingStacks = input.func_193365_a();
            boolean flag = false;
            Item ingredientItem = null;
            for (int j = 0; j < matchingStacks.length && !flag; ++j) {
                Item item = matchingStacks[j].func_77973_b();
                if (this.getToolReplacement(item).func_190926_b()) continue;
                ingredientItem = item;
                flag = true;
            }
            if (!flag || ingredientItem == null || this.getToolReplacement(ingredientItem).func_190926_b()) continue;
            recipe.sourceInput = new IngredientNBT(this.getToolReplacement(ingredientItem)){};
        }
        for (ResearchCategory category : ResearchCategories.researchCategories.values()) {
            for (ResearchEntry entry : category.research.values()) {
                for (ResearchStage stage : entry.getStages()) {
                    Object[] craft = stage.getCraft();
                    int[] craftRef = stage.getCraftReference();
                    if (craft == null || craftRef == null || craft.length != craftRef.length) continue;
                    for (int i = 0; i < craft.length; ++i) {
                        ItemStack replacement;
                        if (!(craft[i] instanceof ItemStack) || (replacement = this.getToolReplacement(((ItemStack)craft[i]).func_77973_b())).func_190926_b()) continue;
                        int replacementHash = ResearchManager.createItemStackHash((ItemStack)replacement);
                        int originalHash = craftRef[i];
                        stage.getCraft()[i] = replacement;
                        stage.getCraftReference()[i] = replacementHash;
                        if (!ResearchManager.craftingReferences.contains(originalHash)) continue;
                        ResearchManager.craftingReferences.remove(originalHash);
                        ResearchManager.craftingReferences.add(replacementHash);
                    }
                }
            }
        }
    }

    public ItemStack createWoodTool(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Head", ModMaterials.HEAD_WOOD.getName());
        tag.func_74778_a("Haft", ModMaterials.HAFT_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createStoneTool(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Head", ModMaterials.HEAD_STONE.getName());
        tag.func_74778_a("Haft", ModMaterials.HAFT_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createIronTool(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Head", ModMaterials.HEAD_IRON.getName());
        tag.func_74778_a("Haft", ModMaterials.HAFT_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createDiamondTool(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Head", ModMaterials.HEAD_IRON.getName());
        tag.func_74778_a("Haft", ModMaterials.HAFT_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_DIAMOND.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createGoldTool(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Head", ModMaterials.HEAD_GOLD.getName());
        tag.func_74778_a("Haft", ModMaterials.HAFT_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createThaumiumTool(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Head", ModMaterials.HEAD_THAUMIUM.getName());
        tag.func_74778_a("Haft", ModMaterials.HAFT_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createVoidTool(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Head", ModMaterials.HEAD_VOID.getName());
        tag.func_74778_a("Haft", ModMaterials.HAFT_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createWoodSword(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Blade", ModMaterials.HEAD_WOOD.getName());
        tag.func_74778_a("Crossguard", ModMaterials.HEAD_WOOD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createStoneSword(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Blade", ModMaterials.HEAD_STONE.getName());
        tag.func_74778_a("Crossguard", ModMaterials.HEAD_STONE.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createIronSword(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Blade", ModMaterials.HEAD_IRON.getName());
        tag.func_74778_a("Crossguard", ModMaterials.HEAD_IRON.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createDiamondSword(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Blade", ModMaterials.HEAD_IRON.getName());
        tag.func_74778_a("Crossguard", ModMaterials.HEAD_IRON.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_DIAMOND.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createGoldSword(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Blade", ModMaterials.HEAD_GOLD.getName());
        tag.func_74778_a("Crossguard", ModMaterials.HEAD_GOLD.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createThaumiumSword(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Blade", ModMaterials.HEAD_THAUMIUM.getName());
        tag.func_74778_a("Crossguard", ModMaterials.HEAD_THAUMIUM.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    public ItemStack createVoidSword(Item item) {
        ItemStack tool = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Blade", ModMaterials.HEAD_VOID.getName());
        tag.func_74778_a("Crossguard", ModMaterials.HEAD_VOID.getName());
        tag.func_74778_a("Handle", ModMaterials.HANDLE_WOOD.getName());
        tag.func_74778_a("ADORNMENT", ModMaterials.ADORNMENT_NULL.getName());
        tool.func_77982_d(tag);
        return tool;
    }

    private ItemStack getToolReplacement(Item item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        if (item == Items.field_151046_w) {
            return this.createDiamondTool((Item)ModItems.pickaxe);
        }
        if (item == Items.field_151005_D) {
            return this.createGoldTool((Item)ModItems.pickaxe);
        }
        if (item == Items.field_151035_b) {
            return this.createIronTool((Item)ModItems.pickaxe);
        }
        if (item == Items.field_151050_s) {
            return this.createStoneTool((Item)ModItems.pickaxe);
        }
        if (item == Items.field_151039_o) {
            return this.createWoodTool((Item)ModItems.pickaxe);
        }
        if (thaumcraftLoaded && item == ItemsTC.thaumiumPick) {
            return this.createThaumiumTool((Item)ModItems.pickaxe);
        }
        if (thaumcraftLoaded && item == ItemsTC.voidPick) {
            return this.createVoidTool((Item)ModItems.pickaxe);
        }
        if (item == Items.field_151056_x) {
            return this.createDiamondTool((Item)ModItems.axe);
        }
        if (item == Items.field_151006_E) {
            return this.createGoldTool((Item)ModItems.axe);
        }
        if (item == Items.field_151036_c) {
            return this.createIronTool((Item)ModItems.axe);
        }
        if (item == Items.field_151049_t) {
            return this.createStoneTool((Item)ModItems.axe);
        }
        if (item == Items.field_151053_p) {
            return this.createWoodTool((Item)ModItems.axe);
        }
        if (thaumcraftLoaded && item == ItemsTC.thaumiumAxe) {
            return this.createThaumiumTool((Item)ModItems.axe);
        }
        if (thaumcraftLoaded && item == ItemsTC.voidAxe) {
            return this.createVoidTool((Item)ModItems.axe);
        }
        if (item == Items.field_151047_v) {
            return this.createDiamondTool((Item)ModItems.shovel);
        }
        if (item == Items.field_151011_C) {
            return this.createGoldTool((Item)ModItems.shovel);
        }
        if (item == Items.field_151037_a) {
            return this.createIronTool((Item)ModItems.shovel);
        }
        if (item == Items.field_151051_r) {
            return this.createStoneTool((Item)ModItems.shovel);
        }
        if (item == Items.field_151038_n) {
            return this.createWoodTool((Item)ModItems.shovel);
        }
        if (thaumcraftLoaded && item == ItemsTC.thaumiumShovel) {
            return this.createThaumiumTool((Item)ModItems.shovel);
        }
        if (thaumcraftLoaded && item == ItemsTC.voidShovel) {
            return this.createVoidTool((Item)ModItems.shovel);
        }
        if (item == Items.field_151012_L) {
            return this.createDiamondTool((Item)ModItems.hoe);
        }
        if (item == Items.field_151013_M) {
            return this.createGoldTool((Item)ModItems.hoe);
        }
        if (item == Items.field_151019_K) {
            return this.createIronTool((Item)ModItems.hoe);
        }
        if (item == Items.field_151018_J) {
            return this.createStoneTool((Item)ModItems.hoe);
        }
        if (item == Items.field_151017_I) {
            return this.createWoodTool((Item)ModItems.hoe);
        }
        if (thaumcraftLoaded && item == ItemsTC.thaumiumHoe) {
            return this.createThaumiumTool((Item)ModItems.hoe);
        }
        if (thaumcraftLoaded && item == ItemsTC.voidHoe) {
            return this.createVoidTool((Item)ModItems.hoe);
        }
        if (item == Items.field_151048_u) {
            return this.createDiamondSword((Item)ModItems.sword);
        }
        if (item == Items.field_151010_B) {
            return this.createGoldSword((Item)ModItems.sword);
        }
        if (item == Items.field_151040_l) {
            return this.createIronSword((Item)ModItems.sword);
        }
        if (item == Items.field_151052_q) {
            return this.createStoneSword((Item)ModItems.sword);
        }
        if (item == Items.field_151041_m) {
            return this.createWoodSword((Item)ModItems.sword);
        }
        if (thaumcraftLoaded && item == ItemsTC.thaumiumSword) {
            return this.createThaumiumSword((Item)ModItems.sword);
        }
        if (thaumcraftLoaded && item == ItemsTC.voidSword) {
            return this.createVoidSword((Item)ModItems.sword);
        }
        return ItemStack.field_190927_a;
    }

    static {
        smelteryMaterials = new ArrayList<HeadMaterial>();
        removed_recipes = new ArrayList<ResourceLocation>();
    }
}

