/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.handlers;

import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import toolbox.common.Config;
import toolbox.common.items.ModItems;

@Mod.EventBusSubscriber(modid="toolbox")
public class LootTableHandler {
    @SubscribeEvent
    public static void lootTableLoad(LootTableLoadEvent event) {
        if (Config.ENABLE_SCHEMATICS) {
            LootPool pool;
            NBTTagCompound nbt;
            LootEntry[] entries;
            if (!Config.DUNGEON_SCHEMATICS.isEmpty() && event.getName().toString().equals("minecraft:chests/simple_dungeon")) {
                entries = new LootEntry[Config.DUNGEON_SCHEMATICS.size()];
                for (int i = 0; i < entries.length; ++i) {
                    nbt = new NBTTagCompound();
                    nbt.func_74778_a("Type", Config.DUNGEON_SCHEMATICS.get(i));
                    entries[i] = new LootEntryItem((Item)ModItems.schematic, 1, 0, new LootFunction[]{new SetNBT(new LootCondition[0], nbt)}, new LootCondition[0], Config.DUNGEON_SCHEMATICS.get(i));
                }
                pool = new LootPool(entries, new LootCondition[0], new RandomValueRange(0.0f, (float)Math.min(3, entries.length)), new RandomValueRange(0.0f), "schematics");
                event.getTable().addPool(pool);
            }
            if (!Config.BLACKSMITH_SCHEMATICS.isEmpty() && event.getName().toString().equals("minecraft:chests/village_blacksmith")) {
                entries = new LootEntry[Config.BLACKSMITH_SCHEMATICS.size()];
                for (int i = 0; i < entries.length; ++i) {
                    nbt = new NBTTagCompound();
                    nbt.func_74778_a("Type", Config.BLACKSMITH_SCHEMATICS.get(i));
                    entries[i] = new LootEntryItem((Item)ModItems.schematic, 1, 0, new LootFunction[]{new SetNBT(new LootCondition[0], nbt)}, new LootCondition[0], Config.BLACKSMITH_SCHEMATICS.get(i));
                }
                pool = new LootPool(entries, new LootCondition[0], new RandomValueRange(0.0f, (float)Math.min(3, entries.length)), new RandomValueRange(0.0f), "schematics");
                event.getTable().addPool(pool);
            }
            if (!Config.BONUS_CHEST_SCHEMATICS.isEmpty() && event.getName().toString().equals("minecraft:chests/spawn_bonus_chest")) {
                entries = new LootEntry[Config.BONUS_CHEST_SCHEMATICS.size()];
                for (int i = 0; i < entries.length; ++i) {
                    nbt = new NBTTagCompound();
                    nbt.func_74778_a("Type", Config.BONUS_CHEST_SCHEMATICS.get(i));
                    entries[i] = new LootEntryItem((Item)ModItems.schematic, 1, 0, new LootFunction[]{new SetNBT(new LootCondition[0], nbt)}, new LootCondition[0], Config.BONUS_CHEST_SCHEMATICS.get(i));
                }
                LootPool pool2 = new LootPool(entries, new LootCondition[0], new RandomValueRange(0.0f, (float)Math.min(3, entries.length)), new RandomValueRange(0.0f), "schematics");
                event.getTable().addPool(pool2);
            }
        }
    }
}

