/*
 * Decompiled with CFR 0.152.
 */
package toolbox.common.handlers;

import api.materials.AdornmentMaterial;
import api.materials.HaftMaterial;
import api.materials.HandleMaterial;
import api.materials.HeadMaterial;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toolbox.common.CommonProxy;
import toolbox.common.items.ItemBase;
import toolbox.common.items.tools.IAdornedTool;
import toolbox.common.items.tools.IBladeTool;
import toolbox.common.items.tools.ICrossguardTool;
import toolbox.common.items.tools.IHaftTool;
import toolbox.common.items.tools.IHandleTool;
import toolbox.common.items.tools.IHeadTool;
import toolbox.common.items.tools.ItemATAxe;
import toolbox.common.items.tools.ItemATDagger;
import toolbox.common.items.tools.ItemATHammer;
import toolbox.common.items.tools.ItemATHandpick;
import toolbox.common.items.tools.ItemATHoe;
import toolbox.common.items.tools.ItemATMace;
import toolbox.common.items.tools.ItemATPickaxe;
import toolbox.common.items.tools.ItemATShovel;
import toolbox.common.items.tools.ItemATSword;
import toolbox.common.materials.ModMaterials;

public class SpecialToolAbilityHandler {
    private Random rand = new Random();
    private static final UUID BLOCK_REACH_MODIFIER = UUID.fromString("DF472D1A-4281-2854-D26C-BDBE9785CC93");
    private static final AttributeModifier enderPearlReachModifier = new AttributeModifier(BLOCK_REACH_MODIFIER, "ender pearl reach", 1.0, 0);

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack;
        Item item;
        if (event.getItemStack() != null && event.getEntityPlayer() != null && ((item = (stack = event.getItemStack()).func_77973_b()) instanceof ItemATAxe || item instanceof ItemATDagger || item instanceof ItemATHammer || item instanceof ItemATHandpick || item instanceof ItemATHoe || item instanceof ItemATMace || item instanceof ItemATPickaxe || item instanceof ItemATShovel || item instanceof ItemATSword)) {
            NBTTagList nbttaglist1;
            boolean shift = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E);
            boolean advanced = event.getFlags().func_194127_a();
            List tooltip = event.getToolTip();
            tooltip.clear();
            String s = stack.func_82833_r();
            s = s + TextFormatting.RESET;
            if (advanced) {
                String s1 = "";
                if (!s.isEmpty()) {
                    s = s + " (";
                    s1 = ")";
                }
                int i = Item.func_150891_b((Item)item);
                s = stack.func_77981_g() ? s + String.format("#%04d/%d%s", i, stack.func_77952_i(), s1) : s + String.format("#%04d%s", i, s1);
            }
            tooltip.add(s);
            int i1 = 0;
            if (shift) {
                AdornmentMaterial mat;
                tooltip.add("");
                if (item instanceof IHeadTool) {
                    HeadMaterial mat2 = IHeadTool.getHeadMat(stack);
                    tooltip.add(TextFormatting.YELLOW + " " + I18n.func_74838_a((String)"desc.head.name") + ": " + I18n.func_74838_a((String)("guide.mat." + mat2.getName() + ".name")));
                }
                if (item instanceof IBladeTool) {
                    HeadMaterial mat3 = IBladeTool.getBladeMat(stack);
                    tooltip.add(TextFormatting.YELLOW + " " + I18n.func_74838_a((String)"desc.blade.name") + ": " + I18n.func_74838_a((String)("guide.mat." + mat3.getName() + ".name")));
                }
                if (item instanceof ICrossguardTool) {
                    HeadMaterial mat4 = ICrossguardTool.getCrossguardMat(stack);
                    tooltip.add(TextFormatting.YELLOW + " " + I18n.func_74838_a((String)"desc.crossguard.name") + ": " + I18n.func_74838_a((String)("guide.mat." + mat4.getName() + ".name")));
                }
                if (item instanceof IHaftTool) {
                    HaftMaterial mat5 = IHaftTool.getHaftMat(stack);
                    tooltip.add(TextFormatting.YELLOW + " " + I18n.func_74838_a((String)"desc.haft.name") + ": " + I18n.func_74838_a((String)("guide.mat." + mat5.getName() + ".name")));
                }
                if (item instanceof IHandleTool) {
                    HandleMaterial mat6 = IHandleTool.getHandleMat(stack);
                    tooltip.add(TextFormatting.YELLOW + " " + I18n.func_74838_a((String)"desc.handle.name") + ": " + I18n.func_74838_a((String)("guide.mat." + mat6.getName() + ".name")));
                }
                if (item instanceof IAdornedTool && !(mat = IAdornedTool.getAdornmentMat(stack)).getName().equals("null")) {
                    tooltip.add(TextFormatting.YELLOW + " " + I18n.func_74838_a((String)"desc.adornment.name") + ": " + I18n.func_74838_a((String)("guide.mat." + mat.getName() + ".name")));
                }
                tooltip.add("");
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("HideFlags", 99)) {
                i1 = stack.func_77978_p().func_74762_e("HideFlags");
            }
            if ((i1 & 0x20) == 0) {
                item.func_77624_a(stack, event.getEntityPlayer() == null ? null : event.getEntityPlayer().field_70170_p, tooltip, event.getFlags());
            }
            if (item instanceof ItemSword && this.isVoidTool(stack) && CommonProxy.thaumcraftLoaded) {
                tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"enchantment.special.sapless"));
            }
            if (stack.func_77942_o()) {
                NBTTagList nbttaglist3;
                NBTTagCompound nbttagcompound1;
                if ((i1 & 1) == 0) {
                    NBTTagList nbttaglist = stack.func_77986_q();
                    for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                        NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
                        short k = nbttagcompound.func_74765_d("id");
                        short l = nbttagcompound.func_74765_d("lvl");
                        Enchantment enchantment = Enchantment.func_185262_c((int)k);
                        if (enchantment == null) continue;
                        tooltip.add(enchantment.func_77316_c((int)l));
                    }
                }
                if (stack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound1 = stack.func_77978_p().func_74775_l("display")).func_150299_b("Lore") == 9 && !(nbttaglist3 = nbttagcompound1.func_150295_c("Lore", 8)).func_82582_d()) {
                    for (int l1 = 0; l1 < nbttaglist3.func_74745_c(); ++l1) {
                        tooltip.add(TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + nbttaglist3.func_150307_f(l1));
                    }
                }
            }
            Multimap multimap = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
            if ((i1 & 2) == 0) {
                if (!((String)tooltip.get(tooltip.size() - 1)).isEmpty()) {
                    tooltip.add("");
                }
                if (item instanceof ItemATPickaxe || item instanceof ItemATHandpick || item instanceof ItemATHammer || item instanceof ItemATAxe || item instanceof ItemATShovel) {
                    int harvestLvl = -1;
                    float efficiency = 0.0f;
                    if (item instanceof ItemATPickaxe) {
                        harvestLvl = ((ItemATPickaxe)item).getHarvestLevel(stack);
                        efficiency = ((ItemATPickaxe)item).getEfficiency(stack);
                    } else if (item instanceof ItemATHandpick) {
                        harvestLvl = ((ItemATHandpick)item).getHarvestLevel(stack);
                        efficiency = ((ItemATHandpick)item).getEfficiency(stack);
                    } else if (item instanceof ItemATHammer) {
                        harvestLvl = ((ItemATHammer)item).getHarvestLevel(stack);
                        efficiency = ((ItemATHammer)item).getEfficiency(stack);
                    } else if (item instanceof ItemATAxe) {
                        harvestLvl = ((ItemATAxe)item).getHarvestLevel(stack);
                        efficiency = ((ItemATAxe)item).getEfficiency(stack);
                    } else if (item instanceof ItemATShovel) {
                        harvestLvl = ((ItemATShovel)item).getHarvestLevel(stack);
                        efficiency = ((ItemATShovel)item).getEfficiency(stack);
                    }
                    tooltip.add(I18n.func_74838_a((String)"desc.harvest_level.name") + ": " + harvestLvl);
                    tooltip.add(I18n.func_74838_a((String)"desc.efficiency.name") + ": " + ItemStack.field_111284_a.format(efficiency));
                }
                for (Map.Entry entry : multimap.entries()) {
                    double d1;
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.func_111164_d();
                    if (event.getEntityPlayer() == null || !shift && !(item instanceof ItemSword)) continue;
                    if (attributemodifier.func_111167_a() == ItemBase.getAttackDamageUUID()) {
                        d0 += event.getEntityPlayer().func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                        d1 = (d0 += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)) * 100.0;
                        if (attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2) {
                            d1 = d0;
                        }
                        tooltip.add(I18n.func_74838_a((String)"desc.attack_damage.name") + ": " + ItemStack.field_111284_a.format(d1));
                        continue;
                    }
                    if (attributemodifier.func_111167_a() != ItemBase.getAttackSpeedUUID()) continue;
                    d1 = (d0 += event.getEntityPlayer().func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b()) * 100.0;
                    if (attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2) {
                        d1 = d0;
                    }
                    tooltip.add(I18n.func_74838_a((String)"desc.attack_speed.name") + ": " + ItemStack.field_111284_a.format(d1));
                }
                if (shift) {
                    tooltip.add(I18n.func_74838_a((String)"desc.enchantability.name") + ": " + item.getItemEnchantability(stack));
                }
                if (stack.func_77951_h() && stack.func_77984_f()) {
                    tooltip.add(I18n.func_74838_a((String)"desc.durability.name") + ": " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + ItemStack.field_111284_a.format(stack.func_77958_k()));
                } else if (stack.func_77984_f()) {
                    tooltip.add(I18n.func_74838_a((String)"desc.durability.name") + ": " + stack.func_77958_k());
                }
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Unbreakable") && (i1 & 4) == 0) {
                tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"item.unbreakable"));
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CanDestroy", 9) && (i1 & 8) == 0 && !(nbttaglist1 = stack.func_77978_p().func_150295_c("CanDestroy", 8)).func_82582_d()) {
                tooltip.add("");
                tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.canBreak"));
                for (int j1 = 0; j1 < nbttaglist1.func_74745_c(); ++j1) {
                    Block block = Block.func_149684_b((String)nbttaglist1.func_150307_f(j1));
                    if (block != null) {
                        tooltip.add(TextFormatting.DARK_GRAY + block.func_149732_F());
                        continue;
                    }
                    tooltip.add(TextFormatting.DARK_GRAY + "missingno");
                }
            }
            if (advanced) {
                tooltip.add(TextFormatting.DARK_GRAY + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString());
                tooltip.add(TextFormatting.DARK_GRAY + I18n.func_74837_a((String)"item.nbt_tags", (Object[])new Object[]{stack.func_77942_o() ? stack.func_77978_p().func_150296_c().size() : 0}));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEndRodToolHarvestEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack stack = event.getHarvester().func_184614_ca();
        boolean flag = false;
        if (stack.func_77973_b() instanceof IHaftTool && IHaftTool.getHaftMat(stack) == ModMaterials.HAFT_END_ROD) {
            flag = true;
        }
        if (flag) {
            if (!event.getWorld().field_72995_K) {
                BlockPos pos = event.getPos();
                for (ItemStack itemstack : event.getDrops()) {
                    if (!(this.rand.nextFloat() < event.getDropChance())) continue;
                    EntityItem entity = new EntityItem(event.getWorld(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5, itemstack);
                    entity.func_189654_d(true);
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = 0.0;
                    entity.field_70179_y = 0.0;
                    entity.field_70133_I = true;
                    event.getWorld().func_72838_d((Entity)entity);
                }
            }
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public void onBlazeRodToolRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!event.getEntityPlayer().func_70093_af()) {
            return;
        }
        boolean flag = false;
        if (stack.func_77973_b() instanceof IHaftTool && IHaftTool.getHaftMat(stack) == ModMaterials.HAFT_BLAZE_ROD) {
            flag = true;
        }
        if (flag && event.getEntityPlayer().func_175151_a(event.getPos(), event.getFace(), stack)) {
            BlockPos pos = event.getPos().func_177972_a(event.getFace());
            if (event.getWorld().func_175623_d(pos)) {
                if (!event.getWorld().field_72995_K) {
                    event.getWorld().func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
                }
                event.getWorld().func_184133_a(event.getEntityPlayer(), pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                event.getEntityPlayer().func_184609_a(event.getHand());
            }
        }
    }

    @SubscribeEvent
    public void onPrismarineAdornedToolMine(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (stack.func_77973_b() instanceof IAdornedTool && IAdornedTool.getAdornmentMat(stack) == ModMaterials.ADORNMENT_PRISMARINE && player.func_70090_H()) {
            event.setNewSpeed(event.getOriginalSpeed() * 2.0f);
        }
    }

    @SubscribeEvent
    public void onLapisToolEnchant(EnchantmentLevelSetEvent event) {
        ItemStack stack = event.getItem();
        if (stack.func_77973_b() instanceof IAdornedTool && IAdornedTool.getAdornmentMat(stack) == ModMaterials.ADORNMENT_LAPIS) {
            event.setLevel((int)((float)event.getLevel() * 1.6666666f));
        }
    }

    @SubscribeEvent
    public void onLapisToolMine(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (stack.func_77973_b() instanceof IAdornedTool && IAdornedTool.getAdornmentMat(stack) == ModMaterials.ADORNMENT_LAPIS && this.rand.nextInt(4) == 0) {
            event.setExpToDrop(event.getExpToDrop() + event.getState().func_177230_c().getExpDrop(event.getState(), (IBlockAccess)event.getWorld(), event.getPos(), 0));
        }
    }

    @SubscribeEvent
    public void onLapisToolKill(LivingExperienceDropEvent event) {
        int exp;
        if (event.getAttackingPlayer() == null) {
            return;
        }
        ItemStack stack = event.getAttackingPlayer().func_184614_ca();
        if (stack.func_77973_b() instanceof IAdornedTool && IAdornedTool.getAdornmentMat(stack) == ModMaterials.ADORNMENT_LAPIS && (exp = event.getDroppedExperience()) > 0 && this.rand.nextBoolean()) {
            event.setDroppedExperience(exp + 1 + this.rand.nextInt(exp + 1));
        }
    }

    @SubscribeEvent
    public void onToolSwitch(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSlot() == EntityEquipmentSlot.MAINHAND) {
            HashMultimap multimap;
            ItemStack from = event.getFrom();
            ItemStack to = event.getTo();
            if (this.isEnderPearlTool(from)) {
                multimap = HashMultimap.create();
                multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)enderPearlReachModifier);
                event.getEntityLiving().func_110140_aT().func_111148_a((Multimap)multimap);
            }
            if (this.isEnderPearlTool(to)) {
                multimap = HashMultimap.create();
                multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)enderPearlReachModifier);
                event.getEntityLiving().func_110140_aT().func_111147_b((Multimap)multimap);
            }
        }
    }

    private boolean isEnderPearlTool(ItemStack stack) {
        return stack.func_77973_b() instanceof IAdornedTool && IAdornedTool.getAdornmentMat(stack) == ModMaterials.ADORNMENT_ENDER_PEARL;
    }

    private boolean isVoidTool(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IHeadTool && IHeadTool.getHeadMat(stack) == ModMaterials.HEAD_VOID) {
            return true;
        }
        if (item instanceof IBladeTool && IBladeTool.getBladeMat(stack) == ModMaterials.HEAD_VOID) {
            return true;
        }
        return item instanceof ICrossguardTool && ICrossguardTool.getCrossguardMat(stack) == ModMaterials.HEAD_VOID;
    }

    @SubscribeEvent
    public void onToolUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_70173_aa % 20 == 0) {
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (!stack.func_77951_h() || !this.isVoidTool(stack)) continue;
                    stack.func_77972_a(-1, (EntityLivingBase)player);
                }
                for (ItemStack stack : player.field_71071_by.field_184439_c) {
                    if (!stack.func_77951_h() || !this.isVoidTool(stack)) continue;
                    stack.func_77972_a(-1, (EntityLivingBase)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity targetEntity = event.getTarget();
        ItemStack weapon = player.func_184614_ca();
        if (targetEntity instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)targetEntity;
            if (!player.field_70170_p.field_72995_K && this.isVoidTool(weapon)) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, weapon.func_77973_b() instanceof ItemSword ? 60 : 80));
            }
        }
    }

    @SubscribeEvent
    public void onWitheredBoneToolCrit(CriticalHitEvent event) {
        if (event.getEntityPlayer() == null || event.getTarget() == null || !(event.getTarget() instanceof EntityLivingBase) || event.getResult() == Event.Result.DENY || !event.isVanillaCritical() && event.getResult() != Event.Result.ALLOW) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        int i = 0;
        if (stack.func_77973_b() instanceof IHaftTool && IHaftTool.getHaftMat(stack) == ModMaterials.HAFT_WITHERED_BONE) {
            ++i;
        }
        if (stack.func_77973_b() instanceof IHandleTool && IHandleTool.getHandleMat(stack) == ModMaterials.HANDLE_WITHERED_BONE) {
            ++i;
        }
        if (i > 0) {
            ((EntityLivingBase)event.getTarget()).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 160, i - 1));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWitherBoneHarvestEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        ItemStack stack = player.func_184614_ca();
        boolean flag = false;
        if (stack.func_77973_b() instanceof IHaftTool && IHaftTool.getHaftMat(stack) == ModMaterials.HAFT_WITHER_BONE) {
            flag = true;
        }
        if (flag && player.field_71093_bK != DimensionType.NETHER.func_186068_a()) {
            stack.func_77972_a(7, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onWitherBoneAttackEvent(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        boolean flag = false;
        if (stack.func_77973_b() instanceof IHaftTool && IHaftTool.getHaftMat(stack) == ModMaterials.HAFT_WITHER_BONE) {
            flag = true;
        }
        if (flag && player.field_71093_bK != DimensionType.NETHER.func_186068_a()) {
            stack.func_77972_a(7, (EntityLivingBase)player);
        }
    }
}

